
#ifndef _EEPROM_H
#define _EEPROM_H

enum {
  HARD_POWER_ON_SATE_OFF = 0x00,
  HARD_POWER_ON_STATE_COLOR = 0x01,
  HARD_POWER_ON_STATE_AUTOSAVE = 0x02,
  _HARD_POWER_ON_MASK = 0x03,
  SOFT_POWER_ON_STATE_COLOR = 0x04,
  SOFT_POWER_ON_STATE_AUTOSAVE = 0x08,
  _SOFT_POWER_ON_MASK = 0x0C,
  _AUTOSAVE_TIMEOUT_MASK = 0x30,
};
struct powerOnState {
  byte state;
  byte rgbw[4];
};
#define EEPROM_POWER_ON_STATE   EEPROM_FIRST_CUSTOM

#ifdef ENABLE_REPEATER
extern byte maxRepeaterHop;
#endif
#define EEPROM_CONFIG_REPEATER  EEPROM_POWER_ON_STATE+sizeof(powerOnState)

struct irCmd{
  unsigned long ir_cmd;
  byte cmd[10];
};
extern irCmd ir_cmds[0x10];
#define EEPROM_CONFIG_IR  EEPROM_CONFIG_REPEATER+1

struct fadeStep{
  byte rgb[3];
  byte secs;
};
extern fadeStep fade_steps[0x10];
#define EEPROM_CONFIG_FADE  EEPROM_CONFIG_IR+sizeof(ir_cmds)

#define EEPROM_CONFIG_DMX  EEPROM_CONFIG_FADE+sizeof(fade_steps)

#endif
