// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package connectiface provides an interface to enable mocking the Amazon Connect Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package connectiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/connect"
)

// ConnectAPI provides an interface to enable mocking the
// connect.Connect service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Connect Service.
//	func myFunc(svc connectiface.ConnectAPI) bool {
//	    // Make svc.ActivateEvaluationForm request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := connect.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockConnectClient struct {
//	    connectiface.ConnectAPI
//	}
//	func (m *mockConnectClient) ActivateEvaluationForm(input *connect.ActivateEvaluationFormInput) (*connect.ActivateEvaluationFormOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockConnectClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ConnectAPI interface {
	ActivateEvaluationForm(*connect.ActivateEvaluationFormInput) (*connect.ActivateEvaluationFormOutput, error)
	ActivateEvaluationFormWithContext(aws.Context, *connect.ActivateEvaluationFormInput, ...request.Option) (*connect.ActivateEvaluationFormOutput, error)
	ActivateEvaluationFormRequest(*connect.ActivateEvaluationFormInput) (*request.Request, *connect.ActivateEvaluationFormOutput)

	AssociateApprovedOrigin(*connect.AssociateApprovedOriginInput) (*connect.AssociateApprovedOriginOutput, error)
	AssociateApprovedOriginWithContext(aws.Context, *connect.AssociateApprovedOriginInput, ...request.Option) (*connect.AssociateApprovedOriginOutput, error)
	AssociateApprovedOriginRequest(*connect.AssociateApprovedOriginInput) (*request.Request, *connect.AssociateApprovedOriginOutput)

	AssociateBot(*connect.AssociateBotInput) (*connect.AssociateBotOutput, error)
	AssociateBotWithContext(aws.Context, *connect.AssociateBotInput, ...request.Option) (*connect.AssociateBotOutput, error)
	AssociateBotRequest(*connect.AssociateBotInput) (*request.Request, *connect.AssociateBotOutput)

	AssociateDefaultVocabulary(*connect.AssociateDefaultVocabularyInput) (*connect.AssociateDefaultVocabularyOutput, error)
	AssociateDefaultVocabularyWithContext(aws.Context, *connect.AssociateDefaultVocabularyInput, ...request.Option) (*connect.AssociateDefaultVocabularyOutput, error)
	AssociateDefaultVocabularyRequest(*connect.AssociateDefaultVocabularyInput) (*request.Request, *connect.AssociateDefaultVocabularyOutput)

	AssociateInstanceStorageConfig(*connect.AssociateInstanceStorageConfigInput) (*connect.AssociateInstanceStorageConfigOutput, error)
	AssociateInstanceStorageConfigWithContext(aws.Context, *connect.AssociateInstanceStorageConfigInput, ...request.Option) (*connect.AssociateInstanceStorageConfigOutput, error)
	AssociateInstanceStorageConfigRequest(*connect.AssociateInstanceStorageConfigInput) (*request.Request, *connect.AssociateInstanceStorageConfigOutput)

	AssociateLambdaFunction(*connect.AssociateLambdaFunctionInput) (*connect.AssociateLambdaFunctionOutput, error)
	AssociateLambdaFunctionWithContext(aws.Context, *connect.AssociateLambdaFunctionInput, ...request.Option) (*connect.AssociateLambdaFunctionOutput, error)
	AssociateLambdaFunctionRequest(*connect.AssociateLambdaFunctionInput) (*request.Request, *connect.AssociateLambdaFunctionOutput)

	AssociateLexBot(*connect.AssociateLexBotInput) (*connect.AssociateLexBotOutput, error)
	AssociateLexBotWithContext(aws.Context, *connect.AssociateLexBotInput, ...request.Option) (*connect.AssociateLexBotOutput, error)
	AssociateLexBotRequest(*connect.AssociateLexBotInput) (*request.Request, *connect.AssociateLexBotOutput)

	AssociatePhoneNumberContactFlow(*connect.AssociatePhoneNumberContactFlowInput) (*connect.AssociatePhoneNumberContactFlowOutput, error)
	AssociatePhoneNumberContactFlowWithContext(aws.Context, *connect.AssociatePhoneNumberContactFlowInput, ...request.Option) (*connect.AssociatePhoneNumberContactFlowOutput, error)
	AssociatePhoneNumberContactFlowRequest(*connect.AssociatePhoneNumberContactFlowInput) (*request.Request, *connect.AssociatePhoneNumberContactFlowOutput)

	AssociateQueueQuickConnects(*connect.AssociateQueueQuickConnectsInput) (*connect.AssociateQueueQuickConnectsOutput, error)
	AssociateQueueQuickConnectsWithContext(aws.Context, *connect.AssociateQueueQuickConnectsInput, ...request.Option) (*connect.AssociateQueueQuickConnectsOutput, error)
	AssociateQueueQuickConnectsRequest(*connect.AssociateQueueQuickConnectsInput) (*request.Request, *connect.AssociateQueueQuickConnectsOutput)

	AssociateRoutingProfileQueues(*connect.AssociateRoutingProfileQueuesInput) (*connect.AssociateRoutingProfileQueuesOutput, error)
	AssociateRoutingProfileQueuesWithContext(aws.Context, *connect.AssociateRoutingProfileQueuesInput, ...request.Option) (*connect.AssociateRoutingProfileQueuesOutput, error)
	AssociateRoutingProfileQueuesRequest(*connect.AssociateRoutingProfileQueuesInput) (*request.Request, *connect.AssociateRoutingProfileQueuesOutput)

	AssociateSecurityKey(*connect.AssociateSecurityKeyInput) (*connect.AssociateSecurityKeyOutput, error)
	AssociateSecurityKeyWithContext(aws.Context, *connect.AssociateSecurityKeyInput, ...request.Option) (*connect.AssociateSecurityKeyOutput, error)
	AssociateSecurityKeyRequest(*connect.AssociateSecurityKeyInput) (*request.Request, *connect.AssociateSecurityKeyOutput)

	ClaimPhoneNumber(*connect.ClaimPhoneNumberInput) (*connect.ClaimPhoneNumberOutput, error)
	ClaimPhoneNumberWithContext(aws.Context, *connect.ClaimPhoneNumberInput, ...request.Option) (*connect.ClaimPhoneNumberOutput, error)
	ClaimPhoneNumberRequest(*connect.ClaimPhoneNumberInput) (*request.Request, *connect.ClaimPhoneNumberOutput)

	CreateAgentStatus(*connect.CreateAgentStatusInput) (*connect.CreateAgentStatusOutput, error)
	CreateAgentStatusWithContext(aws.Context, *connect.CreateAgentStatusInput, ...request.Option) (*connect.CreateAgentStatusOutput, error)
	CreateAgentStatusRequest(*connect.CreateAgentStatusInput) (*request.Request, *connect.CreateAgentStatusOutput)

	CreateContactFlow(*connect.CreateContactFlowInput) (*connect.CreateContactFlowOutput, error)
	CreateContactFlowWithContext(aws.Context, *connect.CreateContactFlowInput, ...request.Option) (*connect.CreateContactFlowOutput, error)
	CreateContactFlowRequest(*connect.CreateContactFlowInput) (*request.Request, *connect.CreateContactFlowOutput)

	CreateContactFlowModule(*connect.CreateContactFlowModuleInput) (*connect.CreateContactFlowModuleOutput, error)
	CreateContactFlowModuleWithContext(aws.Context, *connect.CreateContactFlowModuleInput, ...request.Option) (*connect.CreateContactFlowModuleOutput, error)
	CreateContactFlowModuleRequest(*connect.CreateContactFlowModuleInput) (*request.Request, *connect.CreateContactFlowModuleOutput)

	CreateEvaluationForm(*connect.CreateEvaluationFormInput) (*connect.CreateEvaluationFormOutput, error)
	CreateEvaluationFormWithContext(aws.Context, *connect.CreateEvaluationFormInput, ...request.Option) (*connect.CreateEvaluationFormOutput, error)
	CreateEvaluationFormRequest(*connect.CreateEvaluationFormInput) (*request.Request, *connect.CreateEvaluationFormOutput)

	CreateHoursOfOperation(*connect.CreateHoursOfOperationInput) (*connect.CreateHoursOfOperationOutput, error)
	CreateHoursOfOperationWithContext(aws.Context, *connect.CreateHoursOfOperationInput, ...request.Option) (*connect.CreateHoursOfOperationOutput, error)
	CreateHoursOfOperationRequest(*connect.CreateHoursOfOperationInput) (*request.Request, *connect.CreateHoursOfOperationOutput)

	CreateInstance(*connect.CreateInstanceInput) (*connect.CreateInstanceOutput, error)
	CreateInstanceWithContext(aws.Context, *connect.CreateInstanceInput, ...request.Option) (*connect.CreateInstanceOutput, error)
	CreateInstanceRequest(*connect.CreateInstanceInput) (*request.Request, *connect.CreateInstanceOutput)

	CreateIntegrationAssociation(*connect.CreateIntegrationAssociationInput) (*connect.CreateIntegrationAssociationOutput, error)
	CreateIntegrationAssociationWithContext(aws.Context, *connect.CreateIntegrationAssociationInput, ...request.Option) (*connect.CreateIntegrationAssociationOutput, error)
	CreateIntegrationAssociationRequest(*connect.CreateIntegrationAssociationInput) (*request.Request, *connect.CreateIntegrationAssociationOutput)

	CreateParticipant(*connect.CreateParticipantInput) (*connect.CreateParticipantOutput, error)
	CreateParticipantWithContext(aws.Context, *connect.CreateParticipantInput, ...request.Option) (*connect.CreateParticipantOutput, error)
	CreateParticipantRequest(*connect.CreateParticipantInput) (*request.Request, *connect.CreateParticipantOutput)

	CreatePrompt(*connect.CreatePromptInput) (*connect.CreatePromptOutput, error)
	CreatePromptWithContext(aws.Context, *connect.CreatePromptInput, ...request.Option) (*connect.CreatePromptOutput, error)
	CreatePromptRequest(*connect.CreatePromptInput) (*request.Request, *connect.CreatePromptOutput)

	CreateQueue(*connect.CreateQueueInput) (*connect.CreateQueueOutput, error)
	CreateQueueWithContext(aws.Context, *connect.CreateQueueInput, ...request.Option) (*connect.CreateQueueOutput, error)
	CreateQueueRequest(*connect.CreateQueueInput) (*request.Request, *connect.CreateQueueOutput)

	CreateQuickConnect(*connect.CreateQuickConnectInput) (*connect.CreateQuickConnectOutput, error)
	CreateQuickConnectWithContext(aws.Context, *connect.CreateQuickConnectInput, ...request.Option) (*connect.CreateQuickConnectOutput, error)
	CreateQuickConnectRequest(*connect.CreateQuickConnectInput) (*request.Request, *connect.CreateQuickConnectOutput)

	CreateRoutingProfile(*connect.CreateRoutingProfileInput) (*connect.CreateRoutingProfileOutput, error)
	CreateRoutingProfileWithContext(aws.Context, *connect.CreateRoutingProfileInput, ...request.Option) (*connect.CreateRoutingProfileOutput, error)
	CreateRoutingProfileRequest(*connect.CreateRoutingProfileInput) (*request.Request, *connect.CreateRoutingProfileOutput)

	CreateRule(*connect.CreateRuleInput) (*connect.CreateRuleOutput, error)
	CreateRuleWithContext(aws.Context, *connect.CreateRuleInput, ...request.Option) (*connect.CreateRuleOutput, error)
	CreateRuleRequest(*connect.CreateRuleInput) (*request.Request, *connect.CreateRuleOutput)

	CreateSecurityProfile(*connect.CreateSecurityProfileInput) (*connect.CreateSecurityProfileOutput, error)
	CreateSecurityProfileWithContext(aws.Context, *connect.CreateSecurityProfileInput, ...request.Option) (*connect.CreateSecurityProfileOutput, error)
	CreateSecurityProfileRequest(*connect.CreateSecurityProfileInput) (*request.Request, *connect.CreateSecurityProfileOutput)

	CreateTaskTemplate(*connect.CreateTaskTemplateInput) (*connect.CreateTaskTemplateOutput, error)
	CreateTaskTemplateWithContext(aws.Context, *connect.CreateTaskTemplateInput, ...request.Option) (*connect.CreateTaskTemplateOutput, error)
	CreateTaskTemplateRequest(*connect.CreateTaskTemplateInput) (*request.Request, *connect.CreateTaskTemplateOutput)

	CreateTrafficDistributionGroup(*connect.CreateTrafficDistributionGroupInput) (*connect.CreateTrafficDistributionGroupOutput, error)
	CreateTrafficDistributionGroupWithContext(aws.Context, *connect.CreateTrafficDistributionGroupInput, ...request.Option) (*connect.CreateTrafficDistributionGroupOutput, error)
	CreateTrafficDistributionGroupRequest(*connect.CreateTrafficDistributionGroupInput) (*request.Request, *connect.CreateTrafficDistributionGroupOutput)

	CreateUseCase(*connect.CreateUseCaseInput) (*connect.CreateUseCaseOutput, error)
	CreateUseCaseWithContext(aws.Context, *connect.CreateUseCaseInput, ...request.Option) (*connect.CreateUseCaseOutput, error)
	CreateUseCaseRequest(*connect.CreateUseCaseInput) (*request.Request, *connect.CreateUseCaseOutput)

	CreateUser(*connect.CreateUserInput) (*connect.CreateUserOutput, error)
	CreateUserWithContext(aws.Context, *connect.CreateUserInput, ...request.Option) (*connect.CreateUserOutput, error)
	CreateUserRequest(*connect.CreateUserInput) (*request.Request, *connect.CreateUserOutput)

	CreateUserHierarchyGroup(*connect.CreateUserHierarchyGroupInput) (*connect.CreateUserHierarchyGroupOutput, error)
	CreateUserHierarchyGroupWithContext(aws.Context, *connect.CreateUserHierarchyGroupInput, ...request.Option) (*connect.CreateUserHierarchyGroupOutput, error)
	CreateUserHierarchyGroupRequest(*connect.CreateUserHierarchyGroupInput) (*request.Request, *connect.CreateUserHierarchyGroupOutput)

	CreateVocabulary(*connect.CreateVocabularyInput) (*connect.CreateVocabularyOutput, error)
	CreateVocabularyWithContext(aws.Context, *connect.CreateVocabularyInput, ...request.Option) (*connect.CreateVocabularyOutput, error)
	CreateVocabularyRequest(*connect.CreateVocabularyInput) (*request.Request, *connect.CreateVocabularyOutput)

	DeactivateEvaluationForm(*connect.DeactivateEvaluationFormInput) (*connect.DeactivateEvaluationFormOutput, error)
	DeactivateEvaluationFormWithContext(aws.Context, *connect.DeactivateEvaluationFormInput, ...request.Option) (*connect.DeactivateEvaluationFormOutput, error)
	DeactivateEvaluationFormRequest(*connect.DeactivateEvaluationFormInput) (*request.Request, *connect.DeactivateEvaluationFormOutput)

	DeleteContactEvaluation(*connect.DeleteContactEvaluationInput) (*connect.DeleteContactEvaluationOutput, error)
	DeleteContactEvaluationWithContext(aws.Context, *connect.DeleteContactEvaluationInput, ...request.Option) (*connect.DeleteContactEvaluationOutput, error)
	DeleteContactEvaluationRequest(*connect.DeleteContactEvaluationInput) (*request.Request, *connect.DeleteContactEvaluationOutput)

	DeleteContactFlow(*connect.DeleteContactFlowInput) (*connect.DeleteContactFlowOutput, error)
	DeleteContactFlowWithContext(aws.Context, *connect.DeleteContactFlowInput, ...request.Option) (*connect.DeleteContactFlowOutput, error)
	DeleteContactFlowRequest(*connect.DeleteContactFlowInput) (*request.Request, *connect.DeleteContactFlowOutput)

	DeleteContactFlowModule(*connect.DeleteContactFlowModuleInput) (*connect.DeleteContactFlowModuleOutput, error)
	DeleteContactFlowModuleWithContext(aws.Context, *connect.DeleteContactFlowModuleInput, ...request.Option) (*connect.DeleteContactFlowModuleOutput, error)
	DeleteContactFlowModuleRequest(*connect.DeleteContactFlowModuleInput) (*request.Request, *connect.DeleteContactFlowModuleOutput)

	DeleteEvaluationForm(*connect.DeleteEvaluationFormInput) (*connect.DeleteEvaluationFormOutput, error)
	DeleteEvaluationFormWithContext(aws.Context, *connect.DeleteEvaluationFormInput, ...request.Option) (*connect.DeleteEvaluationFormOutput, error)
	DeleteEvaluationFormRequest(*connect.DeleteEvaluationFormInput) (*request.Request, *connect.DeleteEvaluationFormOutput)

	DeleteHoursOfOperation(*connect.DeleteHoursOfOperationInput) (*connect.DeleteHoursOfOperationOutput, error)
	DeleteHoursOfOperationWithContext(aws.Context, *connect.DeleteHoursOfOperationInput, ...request.Option) (*connect.DeleteHoursOfOperationOutput, error)
	DeleteHoursOfOperationRequest(*connect.DeleteHoursOfOperationInput) (*request.Request, *connect.DeleteHoursOfOperationOutput)

	DeleteInstance(*connect.DeleteInstanceInput) (*connect.DeleteInstanceOutput, error)
	DeleteInstanceWithContext(aws.Context, *connect.DeleteInstanceInput, ...request.Option) (*connect.DeleteInstanceOutput, error)
	DeleteInstanceRequest(*connect.DeleteInstanceInput) (*request.Request, *connect.DeleteInstanceOutput)

	DeleteIntegrationAssociation(*connect.DeleteIntegrationAssociationInput) (*connect.DeleteIntegrationAssociationOutput, error)
	DeleteIntegrationAssociationWithContext(aws.Context, *connect.DeleteIntegrationAssociationInput, ...request.Option) (*connect.DeleteIntegrationAssociationOutput, error)
	DeleteIntegrationAssociationRequest(*connect.DeleteIntegrationAssociationInput) (*request.Request, *connect.DeleteIntegrationAssociationOutput)

	DeletePrompt(*connect.DeletePromptInput) (*connect.DeletePromptOutput, error)
	DeletePromptWithContext(aws.Context, *connect.DeletePromptInput, ...request.Option) (*connect.DeletePromptOutput, error)
	DeletePromptRequest(*connect.DeletePromptInput) (*request.Request, *connect.DeletePromptOutput)

	DeleteQueue(*connect.DeleteQueueInput) (*connect.DeleteQueueOutput, error)
	DeleteQueueWithContext(aws.Context, *connect.DeleteQueueInput, ...request.Option) (*connect.DeleteQueueOutput, error)
	DeleteQueueRequest(*connect.DeleteQueueInput) (*request.Request, *connect.DeleteQueueOutput)

	DeleteQuickConnect(*connect.DeleteQuickConnectInput) (*connect.DeleteQuickConnectOutput, error)
	DeleteQuickConnectWithContext(aws.Context, *connect.DeleteQuickConnectInput, ...request.Option) (*connect.DeleteQuickConnectOutput, error)
	DeleteQuickConnectRequest(*connect.DeleteQuickConnectInput) (*request.Request, *connect.DeleteQuickConnectOutput)

	DeleteRoutingProfile(*connect.DeleteRoutingProfileInput) (*connect.DeleteRoutingProfileOutput, error)
	DeleteRoutingProfileWithContext(aws.Context, *connect.DeleteRoutingProfileInput, ...request.Option) (*connect.DeleteRoutingProfileOutput, error)
	DeleteRoutingProfileRequest(*connect.DeleteRoutingProfileInput) (*request.Request, *connect.DeleteRoutingProfileOutput)

	DeleteRule(*connect.DeleteRuleInput) (*connect.DeleteRuleOutput, error)
	DeleteRuleWithContext(aws.Context, *connect.DeleteRuleInput, ...request.Option) (*connect.DeleteRuleOutput, error)
	DeleteRuleRequest(*connect.DeleteRuleInput) (*request.Request, *connect.DeleteRuleOutput)

	DeleteSecurityProfile(*connect.DeleteSecurityProfileInput) (*connect.DeleteSecurityProfileOutput, error)
	DeleteSecurityProfileWithContext(aws.Context, *connect.DeleteSecurityProfileInput, ...request.Option) (*connect.DeleteSecurityProfileOutput, error)
	DeleteSecurityProfileRequest(*connect.DeleteSecurityProfileInput) (*request.Request, *connect.DeleteSecurityProfileOutput)

	DeleteTaskTemplate(*connect.DeleteTaskTemplateInput) (*connect.DeleteTaskTemplateOutput, error)
	DeleteTaskTemplateWithContext(aws.Context, *connect.DeleteTaskTemplateInput, ...request.Option) (*connect.DeleteTaskTemplateOutput, error)
	DeleteTaskTemplateRequest(*connect.DeleteTaskTemplateInput) (*request.Request, *connect.DeleteTaskTemplateOutput)

	DeleteTrafficDistributionGroup(*connect.DeleteTrafficDistributionGroupInput) (*connect.DeleteTrafficDistributionGroupOutput, error)
	DeleteTrafficDistributionGroupWithContext(aws.Context, *connect.DeleteTrafficDistributionGroupInput, ...request.Option) (*connect.DeleteTrafficDistributionGroupOutput, error)
	DeleteTrafficDistributionGroupRequest(*connect.DeleteTrafficDistributionGroupInput) (*request.Request, *connect.DeleteTrafficDistributionGroupOutput)

	DeleteUseCase(*connect.DeleteUseCaseInput) (*connect.DeleteUseCaseOutput, error)
	DeleteUseCaseWithContext(aws.Context, *connect.DeleteUseCaseInput, ...request.Option) (*connect.DeleteUseCaseOutput, error)
	DeleteUseCaseRequest(*connect.DeleteUseCaseInput) (*request.Request, *connect.DeleteUseCaseOutput)

	DeleteUser(*connect.DeleteUserInput) (*connect.DeleteUserOutput, error)
	DeleteUserWithContext(aws.Context, *connect.DeleteUserInput, ...request.Option) (*connect.DeleteUserOutput, error)
	DeleteUserRequest(*connect.DeleteUserInput) (*request.Request, *connect.DeleteUserOutput)

	DeleteUserHierarchyGroup(*connect.DeleteUserHierarchyGroupInput) (*connect.DeleteUserHierarchyGroupOutput, error)
	DeleteUserHierarchyGroupWithContext(aws.Context, *connect.DeleteUserHierarchyGroupInput, ...request.Option) (*connect.DeleteUserHierarchyGroupOutput, error)
	DeleteUserHierarchyGroupRequest(*connect.DeleteUserHierarchyGroupInput) (*request.Request, *connect.DeleteUserHierarchyGroupOutput)

	DeleteVocabulary(*connect.DeleteVocabularyInput) (*connect.DeleteVocabularyOutput, error)
	DeleteVocabularyWithContext(aws.Context, *connect.DeleteVocabularyInput, ...request.Option) (*connect.DeleteVocabularyOutput, error)
	DeleteVocabularyRequest(*connect.DeleteVocabularyInput) (*request.Request, *connect.DeleteVocabularyOutput)

	DescribeAgentStatus(*connect.DescribeAgentStatusInput) (*connect.DescribeAgentStatusOutput, error)
	DescribeAgentStatusWithContext(aws.Context, *connect.DescribeAgentStatusInput, ...request.Option) (*connect.DescribeAgentStatusOutput, error)
	DescribeAgentStatusRequest(*connect.DescribeAgentStatusInput) (*request.Request, *connect.DescribeAgentStatusOutput)

	DescribeContact(*connect.DescribeContactInput) (*connect.DescribeContactOutput, error)
	DescribeContactWithContext(aws.Context, *connect.DescribeContactInput, ...request.Option) (*connect.DescribeContactOutput, error)
	DescribeContactRequest(*connect.DescribeContactInput) (*request.Request, *connect.DescribeContactOutput)

	DescribeContactEvaluation(*connect.DescribeContactEvaluationInput) (*connect.DescribeContactEvaluationOutput, error)
	DescribeContactEvaluationWithContext(aws.Context, *connect.DescribeContactEvaluationInput, ...request.Option) (*connect.DescribeContactEvaluationOutput, error)
	DescribeContactEvaluationRequest(*connect.DescribeContactEvaluationInput) (*request.Request, *connect.DescribeContactEvaluationOutput)

	DescribeContactFlow(*connect.DescribeContactFlowInput) (*connect.DescribeContactFlowOutput, error)
	DescribeContactFlowWithContext(aws.Context, *connect.DescribeContactFlowInput, ...request.Option) (*connect.DescribeContactFlowOutput, error)
	DescribeContactFlowRequest(*connect.DescribeContactFlowInput) (*request.Request, *connect.DescribeContactFlowOutput)

	DescribeContactFlowModule(*connect.DescribeContactFlowModuleInput) (*connect.DescribeContactFlowModuleOutput, error)
	DescribeContactFlowModuleWithContext(aws.Context, *connect.DescribeContactFlowModuleInput, ...request.Option) (*connect.DescribeContactFlowModuleOutput, error)
	DescribeContactFlowModuleRequest(*connect.DescribeContactFlowModuleInput) (*request.Request, *connect.DescribeContactFlowModuleOutput)

	DescribeEvaluationForm(*connect.DescribeEvaluationFormInput) (*connect.DescribeEvaluationFormOutput, error)
	DescribeEvaluationFormWithContext(aws.Context, *connect.DescribeEvaluationFormInput, ...request.Option) (*connect.DescribeEvaluationFormOutput, error)
	DescribeEvaluationFormRequest(*connect.DescribeEvaluationFormInput) (*request.Request, *connect.DescribeEvaluationFormOutput)

	DescribeHoursOfOperation(*connect.DescribeHoursOfOperationInput) (*connect.DescribeHoursOfOperationOutput, error)
	DescribeHoursOfOperationWithContext(aws.Context, *connect.DescribeHoursOfOperationInput, ...request.Option) (*connect.DescribeHoursOfOperationOutput, error)
	DescribeHoursOfOperationRequest(*connect.DescribeHoursOfOperationInput) (*request.Request, *connect.DescribeHoursOfOperationOutput)

	DescribeInstance(*connect.DescribeInstanceInput) (*connect.DescribeInstanceOutput, error)
	DescribeInstanceWithContext(aws.Context, *connect.DescribeInstanceInput, ...request.Option) (*connect.DescribeInstanceOutput, error)
	DescribeInstanceRequest(*connect.DescribeInstanceInput) (*request.Request, *connect.DescribeInstanceOutput)

	DescribeInstanceAttribute(*connect.DescribeInstanceAttributeInput) (*connect.DescribeInstanceAttributeOutput, error)
	DescribeInstanceAttributeWithContext(aws.Context, *connect.DescribeInstanceAttributeInput, ...request.Option) (*connect.DescribeInstanceAttributeOutput, error)
	DescribeInstanceAttributeRequest(*connect.DescribeInstanceAttributeInput) (*request.Request, *connect.DescribeInstanceAttributeOutput)

	DescribeInstanceStorageConfig(*connect.DescribeInstanceStorageConfigInput) (*connect.DescribeInstanceStorageConfigOutput, error)
	DescribeInstanceStorageConfigWithContext(aws.Context, *connect.DescribeInstanceStorageConfigInput, ...request.Option) (*connect.DescribeInstanceStorageConfigOutput, error)
	DescribeInstanceStorageConfigRequest(*connect.DescribeInstanceStorageConfigInput) (*request.Request, *connect.DescribeInstanceStorageConfigOutput)

	DescribePhoneNumber(*connect.DescribePhoneNumberInput) (*connect.DescribePhoneNumberOutput, error)
	DescribePhoneNumberWithContext(aws.Context, *connect.DescribePhoneNumberInput, ...request.Option) (*connect.DescribePhoneNumberOutput, error)
	DescribePhoneNumberRequest(*connect.DescribePhoneNumberInput) (*request.Request, *connect.DescribePhoneNumberOutput)

	DescribePrompt(*connect.DescribePromptInput) (*connect.DescribePromptOutput, error)
	DescribePromptWithContext(aws.Context, *connect.DescribePromptInput, ...request.Option) (*connect.DescribePromptOutput, error)
	DescribePromptRequest(*connect.DescribePromptInput) (*request.Request, *connect.DescribePromptOutput)

	DescribeQueue(*connect.DescribeQueueInput) (*connect.DescribeQueueOutput, error)
	DescribeQueueWithContext(aws.Context, *connect.DescribeQueueInput, ...request.Option) (*connect.DescribeQueueOutput, error)
	DescribeQueueRequest(*connect.DescribeQueueInput) (*request.Request, *connect.DescribeQueueOutput)

	DescribeQuickConnect(*connect.DescribeQuickConnectInput) (*connect.DescribeQuickConnectOutput, error)
	DescribeQuickConnectWithContext(aws.Context, *connect.DescribeQuickConnectInput, ...request.Option) (*connect.DescribeQuickConnectOutput, error)
	DescribeQuickConnectRequest(*connect.DescribeQuickConnectInput) (*request.Request, *connect.DescribeQuickConnectOutput)

	DescribeRoutingProfile(*connect.DescribeRoutingProfileInput) (*connect.DescribeRoutingProfileOutput, error)
	DescribeRoutingProfileWithContext(aws.Context, *connect.DescribeRoutingProfileInput, ...request.Option) (*connect.DescribeRoutingProfileOutput, error)
	DescribeRoutingProfileRequest(*connect.DescribeRoutingProfileInput) (*request.Request, *connect.DescribeRoutingProfileOutput)

	DescribeRule(*connect.DescribeRuleInput) (*connect.DescribeRuleOutput, error)
	DescribeRuleWithContext(aws.Context, *connect.DescribeRuleInput, ...request.Option) (*connect.DescribeRuleOutput, error)
	DescribeRuleRequest(*connect.DescribeRuleInput) (*request.Request, *connect.DescribeRuleOutput)

	DescribeSecurityProfile(*connect.DescribeSecurityProfileInput) (*connect.DescribeSecurityProfileOutput, error)
	DescribeSecurityProfileWithContext(aws.Context, *connect.DescribeSecurityProfileInput, ...request.Option) (*connect.DescribeSecurityProfileOutput, error)
	DescribeSecurityProfileRequest(*connect.DescribeSecurityProfileInput) (*request.Request, *connect.DescribeSecurityProfileOutput)

	DescribeTrafficDistributionGroup(*connect.DescribeTrafficDistributionGroupInput) (*connect.DescribeTrafficDistributionGroupOutput, error)
	DescribeTrafficDistributionGroupWithContext(aws.Context, *connect.DescribeTrafficDistributionGroupInput, ...request.Option) (*connect.DescribeTrafficDistributionGroupOutput, error)
	DescribeTrafficDistributionGroupRequest(*connect.DescribeTrafficDistributionGroupInput) (*request.Request, *connect.DescribeTrafficDistributionGroupOutput)

	DescribeUser(*connect.DescribeUserInput) (*connect.DescribeUserOutput, error)
	DescribeUserWithContext(aws.Context, *connect.DescribeUserInput, ...request.Option) (*connect.DescribeUserOutput, error)
	DescribeUserRequest(*connect.DescribeUserInput) (*request.Request, *connect.DescribeUserOutput)

	DescribeUserHierarchyGroup(*connect.DescribeUserHierarchyGroupInput) (*connect.DescribeUserHierarchyGroupOutput, error)
	DescribeUserHierarchyGroupWithContext(aws.Context, *connect.DescribeUserHierarchyGroupInput, ...request.Option) (*connect.DescribeUserHierarchyGroupOutput, error)
	DescribeUserHierarchyGroupRequest(*connect.DescribeUserHierarchyGroupInput) (*request.Request, *connect.DescribeUserHierarchyGroupOutput)

	DescribeUserHierarchyStructure(*connect.DescribeUserHierarchyStructureInput) (*connect.DescribeUserHierarchyStructureOutput, error)
	DescribeUserHierarchyStructureWithContext(aws.Context, *connect.DescribeUserHierarchyStructureInput, ...request.Option) (*connect.DescribeUserHierarchyStructureOutput, error)
	DescribeUserHierarchyStructureRequest(*connect.DescribeUserHierarchyStructureInput) (*request.Request, *connect.DescribeUserHierarchyStructureOutput)

	DescribeVocabulary(*connect.DescribeVocabularyInput) (*connect.DescribeVocabularyOutput, error)
	DescribeVocabularyWithContext(aws.Context, *connect.DescribeVocabularyInput, ...request.Option) (*connect.DescribeVocabularyOutput, error)
	DescribeVocabularyRequest(*connect.DescribeVocabularyInput) (*request.Request, *connect.DescribeVocabularyOutput)

	DisassociateApprovedOrigin(*connect.DisassociateApprovedOriginInput) (*connect.DisassociateApprovedOriginOutput, error)
	DisassociateApprovedOriginWithContext(aws.Context, *connect.DisassociateApprovedOriginInput, ...request.Option) (*connect.DisassociateApprovedOriginOutput, error)
	DisassociateApprovedOriginRequest(*connect.DisassociateApprovedOriginInput) (*request.Request, *connect.DisassociateApprovedOriginOutput)

	DisassociateBot(*connect.DisassociateBotInput) (*connect.DisassociateBotOutput, error)
	DisassociateBotWithContext(aws.Context, *connect.DisassociateBotInput, ...request.Option) (*connect.DisassociateBotOutput, error)
	DisassociateBotRequest(*connect.DisassociateBotInput) (*request.Request, *connect.DisassociateBotOutput)

	DisassociateInstanceStorageConfig(*connect.DisassociateInstanceStorageConfigInput) (*connect.DisassociateInstanceStorageConfigOutput, error)
	DisassociateInstanceStorageConfigWithContext(aws.Context, *connect.DisassociateInstanceStorageConfigInput, ...request.Option) (*connect.DisassociateInstanceStorageConfigOutput, error)
	DisassociateInstanceStorageConfigRequest(*connect.DisassociateInstanceStorageConfigInput) (*request.Request, *connect.DisassociateInstanceStorageConfigOutput)

	DisassociateLambdaFunction(*connect.DisassociateLambdaFunctionInput) (*connect.DisassociateLambdaFunctionOutput, error)
	DisassociateLambdaFunctionWithContext(aws.Context, *connect.DisassociateLambdaFunctionInput, ...request.Option) (*connect.DisassociateLambdaFunctionOutput, error)
	DisassociateLambdaFunctionRequest(*connect.DisassociateLambdaFunctionInput) (*request.Request, *connect.DisassociateLambdaFunctionOutput)

	DisassociateLexBot(*connect.DisassociateLexBotInput) (*connect.DisassociateLexBotOutput, error)
	DisassociateLexBotWithContext(aws.Context, *connect.DisassociateLexBotInput, ...request.Option) (*connect.DisassociateLexBotOutput, error)
	DisassociateLexBotRequest(*connect.DisassociateLexBotInput) (*request.Request, *connect.DisassociateLexBotOutput)

	DisassociatePhoneNumberContactFlow(*connect.DisassociatePhoneNumberContactFlowInput) (*connect.DisassociatePhoneNumberContactFlowOutput, error)
	DisassociatePhoneNumberContactFlowWithContext(aws.Context, *connect.DisassociatePhoneNumberContactFlowInput, ...request.Option) (*connect.DisassociatePhoneNumberContactFlowOutput, error)
	DisassociatePhoneNumberContactFlowRequest(*connect.DisassociatePhoneNumberContactFlowInput) (*request.Request, *connect.DisassociatePhoneNumberContactFlowOutput)

	DisassociateQueueQuickConnects(*connect.DisassociateQueueQuickConnectsInput) (*connect.DisassociateQueueQuickConnectsOutput, error)
	DisassociateQueueQuickConnectsWithContext(aws.Context, *connect.DisassociateQueueQuickConnectsInput, ...request.Option) (*connect.DisassociateQueueQuickConnectsOutput, error)
	DisassociateQueueQuickConnectsRequest(*connect.DisassociateQueueQuickConnectsInput) (*request.Request, *connect.DisassociateQueueQuickConnectsOutput)

	DisassociateRoutingProfileQueues(*connect.DisassociateRoutingProfileQueuesInput) (*connect.DisassociateRoutingProfileQueuesOutput, error)
	DisassociateRoutingProfileQueuesWithContext(aws.Context, *connect.DisassociateRoutingProfileQueuesInput, ...request.Option) (*connect.DisassociateRoutingProfileQueuesOutput, error)
	DisassociateRoutingProfileQueuesRequest(*connect.DisassociateRoutingProfileQueuesInput) (*request.Request, *connect.DisassociateRoutingProfileQueuesOutput)

	DisassociateSecurityKey(*connect.DisassociateSecurityKeyInput) (*connect.DisassociateSecurityKeyOutput, error)
	DisassociateSecurityKeyWithContext(aws.Context, *connect.DisassociateSecurityKeyInput, ...request.Option) (*connect.DisassociateSecurityKeyOutput, error)
	DisassociateSecurityKeyRequest(*connect.DisassociateSecurityKeyInput) (*request.Request, *connect.DisassociateSecurityKeyOutput)

	DismissUserContact(*connect.DismissUserContactInput) (*connect.DismissUserContactOutput, error)
	DismissUserContactWithContext(aws.Context, *connect.DismissUserContactInput, ...request.Option) (*connect.DismissUserContactOutput, error)
	DismissUserContactRequest(*connect.DismissUserContactInput) (*request.Request, *connect.DismissUserContactOutput)

	GetContactAttributes(*connect.GetContactAttributesInput) (*connect.GetContactAttributesOutput, error)
	GetContactAttributesWithContext(aws.Context, *connect.GetContactAttributesInput, ...request.Option) (*connect.GetContactAttributesOutput, error)
	GetContactAttributesRequest(*connect.GetContactAttributesInput) (*request.Request, *connect.GetContactAttributesOutput)

	GetCurrentMetricData(*connect.GetCurrentMetricDataInput) (*connect.GetCurrentMetricDataOutput, error)
	GetCurrentMetricDataWithContext(aws.Context, *connect.GetCurrentMetricDataInput, ...request.Option) (*connect.GetCurrentMetricDataOutput, error)
	GetCurrentMetricDataRequest(*connect.GetCurrentMetricDataInput) (*request.Request, *connect.GetCurrentMetricDataOutput)

	GetCurrentMetricDataPages(*connect.GetCurrentMetricDataInput, func(*connect.GetCurrentMetricDataOutput, bool) bool) error
	GetCurrentMetricDataPagesWithContext(aws.Context, *connect.GetCurrentMetricDataInput, func(*connect.GetCurrentMetricDataOutput, bool) bool, ...request.Option) error

	GetCurrentUserData(*connect.GetCurrentUserDataInput) (*connect.GetCurrentUserDataOutput, error)
	GetCurrentUserDataWithContext(aws.Context, *connect.GetCurrentUserDataInput, ...request.Option) (*connect.GetCurrentUserDataOutput, error)
	GetCurrentUserDataRequest(*connect.GetCurrentUserDataInput) (*request.Request, *connect.GetCurrentUserDataOutput)

	GetCurrentUserDataPages(*connect.GetCurrentUserDataInput, func(*connect.GetCurrentUserDataOutput, bool) bool) error
	GetCurrentUserDataPagesWithContext(aws.Context, *connect.GetCurrentUserDataInput, func(*connect.GetCurrentUserDataOutput, bool) bool, ...request.Option) error

	GetFederationToken(*connect.GetFederationTokenInput) (*connect.GetFederationTokenOutput, error)
	GetFederationTokenWithContext(aws.Context, *connect.GetFederationTokenInput, ...request.Option) (*connect.GetFederationTokenOutput, error)
	GetFederationTokenRequest(*connect.GetFederationTokenInput) (*request.Request, *connect.GetFederationTokenOutput)

	GetMetricData(*connect.GetMetricDataInput) (*connect.GetMetricDataOutput, error)
	GetMetricDataWithContext(aws.Context, *connect.GetMetricDataInput, ...request.Option) (*connect.GetMetricDataOutput, error)
	GetMetricDataRequest(*connect.GetMetricDataInput) (*request.Request, *connect.GetMetricDataOutput)

	GetMetricDataPages(*connect.GetMetricDataInput, func(*connect.GetMetricDataOutput, bool) bool) error
	GetMetricDataPagesWithContext(aws.Context, *connect.GetMetricDataInput, func(*connect.GetMetricDataOutput, bool) bool, ...request.Option) error

	GetMetricDataV2(*connect.GetMetricDataV2Input) (*connect.GetMetricDataV2Output, error)
	GetMetricDataV2WithContext(aws.Context, *connect.GetMetricDataV2Input, ...request.Option) (*connect.GetMetricDataV2Output, error)
	GetMetricDataV2Request(*connect.GetMetricDataV2Input) (*request.Request, *connect.GetMetricDataV2Output)

	GetMetricDataV2Pages(*connect.GetMetricDataV2Input, func(*connect.GetMetricDataV2Output, bool) bool) error
	GetMetricDataV2PagesWithContext(aws.Context, *connect.GetMetricDataV2Input, func(*connect.GetMetricDataV2Output, bool) bool, ...request.Option) error

	GetPromptFile(*connect.GetPromptFileInput) (*connect.GetPromptFileOutput, error)
	GetPromptFileWithContext(aws.Context, *connect.GetPromptFileInput, ...request.Option) (*connect.GetPromptFileOutput, error)
	GetPromptFileRequest(*connect.GetPromptFileInput) (*request.Request, *connect.GetPromptFileOutput)

	GetTaskTemplate(*connect.GetTaskTemplateInput) (*connect.GetTaskTemplateOutput, error)
	GetTaskTemplateWithContext(aws.Context, *connect.GetTaskTemplateInput, ...request.Option) (*connect.GetTaskTemplateOutput, error)
	GetTaskTemplateRequest(*connect.GetTaskTemplateInput) (*request.Request, *connect.GetTaskTemplateOutput)

	GetTrafficDistribution(*connect.GetTrafficDistributionInput) (*connect.GetTrafficDistributionOutput, error)
	GetTrafficDistributionWithContext(aws.Context, *connect.GetTrafficDistributionInput, ...request.Option) (*connect.GetTrafficDistributionOutput, error)
	GetTrafficDistributionRequest(*connect.GetTrafficDistributionInput) (*request.Request, *connect.GetTrafficDistributionOutput)

	ListAgentStatuses(*connect.ListAgentStatusesInput) (*connect.ListAgentStatusesOutput, error)
	ListAgentStatusesWithContext(aws.Context, *connect.ListAgentStatusesInput, ...request.Option) (*connect.ListAgentStatusesOutput, error)
	ListAgentStatusesRequest(*connect.ListAgentStatusesInput) (*request.Request, *connect.ListAgentStatusesOutput)

	ListAgentStatusesPages(*connect.ListAgentStatusesInput, func(*connect.ListAgentStatusesOutput, bool) bool) error
	ListAgentStatusesPagesWithContext(aws.Context, *connect.ListAgentStatusesInput, func(*connect.ListAgentStatusesOutput, bool) bool, ...request.Option) error

	ListApprovedOrigins(*connect.ListApprovedOriginsInput) (*connect.ListApprovedOriginsOutput, error)
	ListApprovedOriginsWithContext(aws.Context, *connect.ListApprovedOriginsInput, ...request.Option) (*connect.ListApprovedOriginsOutput, error)
	ListApprovedOriginsRequest(*connect.ListApprovedOriginsInput) (*request.Request, *connect.ListApprovedOriginsOutput)

	ListApprovedOriginsPages(*connect.ListApprovedOriginsInput, func(*connect.ListApprovedOriginsOutput, bool) bool) error
	ListApprovedOriginsPagesWithContext(aws.Context, *connect.ListApprovedOriginsInput, func(*connect.ListApprovedOriginsOutput, bool) bool, ...request.Option) error

	ListBots(*connect.ListBotsInput) (*connect.ListBotsOutput, error)
	ListBotsWithContext(aws.Context, *connect.ListBotsInput, ...request.Option) (*connect.ListBotsOutput, error)
	ListBotsRequest(*connect.ListBotsInput) (*request.Request, *connect.ListBotsOutput)

	ListBotsPages(*connect.ListBotsInput, func(*connect.ListBotsOutput, bool) bool) error
	ListBotsPagesWithContext(aws.Context, *connect.ListBotsInput, func(*connect.ListBotsOutput, bool) bool, ...request.Option) error

	ListContactEvaluations(*connect.ListContactEvaluationsInput) (*connect.ListContactEvaluationsOutput, error)
	ListContactEvaluationsWithContext(aws.Context, *connect.ListContactEvaluationsInput, ...request.Option) (*connect.ListContactEvaluationsOutput, error)
	ListContactEvaluationsRequest(*connect.ListContactEvaluationsInput) (*request.Request, *connect.ListContactEvaluationsOutput)

	ListContactEvaluationsPages(*connect.ListContactEvaluationsInput, func(*connect.ListContactEvaluationsOutput, bool) bool) error
	ListContactEvaluationsPagesWithContext(aws.Context, *connect.ListContactEvaluationsInput, func(*connect.ListContactEvaluationsOutput, bool) bool, ...request.Option) error

	ListContactFlowModules(*connect.ListContactFlowModulesInput) (*connect.ListContactFlowModulesOutput, error)
	ListContactFlowModulesWithContext(aws.Context, *connect.ListContactFlowModulesInput, ...request.Option) (*connect.ListContactFlowModulesOutput, error)
	ListContactFlowModulesRequest(*connect.ListContactFlowModulesInput) (*request.Request, *connect.ListContactFlowModulesOutput)

	ListContactFlowModulesPages(*connect.ListContactFlowModulesInput, func(*connect.ListContactFlowModulesOutput, bool) bool) error
	ListContactFlowModulesPagesWithContext(aws.Context, *connect.ListContactFlowModulesInput, func(*connect.ListContactFlowModulesOutput, bool) bool, ...request.Option) error

	ListContactFlows(*connect.ListContactFlowsInput) (*connect.ListContactFlowsOutput, error)
	ListContactFlowsWithContext(aws.Context, *connect.ListContactFlowsInput, ...request.Option) (*connect.ListContactFlowsOutput, error)
	ListContactFlowsRequest(*connect.ListContactFlowsInput) (*request.Request, *connect.ListContactFlowsOutput)

	ListContactFlowsPages(*connect.ListContactFlowsInput, func(*connect.ListContactFlowsOutput, bool) bool) error
	ListContactFlowsPagesWithContext(aws.Context, *connect.ListContactFlowsInput, func(*connect.ListContactFlowsOutput, bool) bool, ...request.Option) error

	ListContactReferences(*connect.ListContactReferencesInput) (*connect.ListContactReferencesOutput, error)
	ListContactReferencesWithContext(aws.Context, *connect.ListContactReferencesInput, ...request.Option) (*connect.ListContactReferencesOutput, error)
	ListContactReferencesRequest(*connect.ListContactReferencesInput) (*request.Request, *connect.ListContactReferencesOutput)

	ListContactReferencesPages(*connect.ListContactReferencesInput, func(*connect.ListContactReferencesOutput, bool) bool) error
	ListContactReferencesPagesWithContext(aws.Context, *connect.ListContactReferencesInput, func(*connect.ListContactReferencesOutput, bool) bool, ...request.Option) error

	ListDefaultVocabularies(*connect.ListDefaultVocabulariesInput) (*connect.ListDefaultVocabulariesOutput, error)
	ListDefaultVocabulariesWithContext(aws.Context, *connect.ListDefaultVocabulariesInput, ...request.Option) (*connect.ListDefaultVocabulariesOutput, error)
	ListDefaultVocabulariesRequest(*connect.ListDefaultVocabulariesInput) (*request.Request, *connect.ListDefaultVocabulariesOutput)

	ListDefaultVocabulariesPages(*connect.ListDefaultVocabulariesInput, func(*connect.ListDefaultVocabulariesOutput, bool) bool) error
	ListDefaultVocabulariesPagesWithContext(aws.Context, *connect.ListDefaultVocabulariesInput, func(*connect.ListDefaultVocabulariesOutput, bool) bool, ...request.Option) error

	ListEvaluationFormVersions(*connect.ListEvaluationFormVersionsInput) (*connect.ListEvaluationFormVersionsOutput, error)
	ListEvaluationFormVersionsWithContext(aws.Context, *connect.ListEvaluationFormVersionsInput, ...request.Option) (*connect.ListEvaluationFormVersionsOutput, error)
	ListEvaluationFormVersionsRequest(*connect.ListEvaluationFormVersionsInput) (*request.Request, *connect.ListEvaluationFormVersionsOutput)

	ListEvaluationFormVersionsPages(*connect.ListEvaluationFormVersionsInput, func(*connect.ListEvaluationFormVersionsOutput, bool) bool) error
	ListEvaluationFormVersionsPagesWithContext(aws.Context, *connect.ListEvaluationFormVersionsInput, func(*connect.ListEvaluationFormVersionsOutput, bool) bool, ...request.Option) error

	ListEvaluationForms(*connect.ListEvaluationFormsInput) (*connect.ListEvaluationFormsOutput, error)
	ListEvaluationFormsWithContext(aws.Context, *connect.ListEvaluationFormsInput, ...request.Option) (*connect.ListEvaluationFormsOutput, error)
	ListEvaluationFormsRequest(*connect.ListEvaluationFormsInput) (*request.Request, *connect.ListEvaluationFormsOutput)

	ListEvaluationFormsPages(*connect.ListEvaluationFormsInput, func(*connect.ListEvaluationFormsOutput, bool) bool) error
	ListEvaluationFormsPagesWithContext(aws.Context, *connect.ListEvaluationFormsInput, func(*connect.ListEvaluationFormsOutput, bool) bool, ...request.Option) error

	ListHoursOfOperations(*connect.ListHoursOfOperationsInput) (*connect.ListHoursOfOperationsOutput, error)
	ListHoursOfOperationsWithContext(aws.Context, *connect.ListHoursOfOperationsInput, ...request.Option) (*connect.ListHoursOfOperationsOutput, error)
	ListHoursOfOperationsRequest(*connect.ListHoursOfOperationsInput) (*request.Request, *connect.ListHoursOfOperationsOutput)

	ListHoursOfOperationsPages(*connect.ListHoursOfOperationsInput, func(*connect.ListHoursOfOperationsOutput, bool) bool) error
	ListHoursOfOperationsPagesWithContext(aws.Context, *connect.ListHoursOfOperationsInput, func(*connect.ListHoursOfOperationsOutput, bool) bool, ...request.Option) error

	ListInstanceAttributes(*connect.ListInstanceAttributesInput) (*connect.ListInstanceAttributesOutput, error)
	ListInstanceAttributesWithContext(aws.Context, *connect.ListInstanceAttributesInput, ...request.Option) (*connect.ListInstanceAttributesOutput, error)
	ListInstanceAttributesRequest(*connect.ListInstanceAttributesInput) (*request.Request, *connect.ListInstanceAttributesOutput)

	ListInstanceAttributesPages(*connect.ListInstanceAttributesInput, func(*connect.ListInstanceAttributesOutput, bool) bool) error
	ListInstanceAttributesPagesWithContext(aws.Context, *connect.ListInstanceAttributesInput, func(*connect.ListInstanceAttributesOutput, bool) bool, ...request.Option) error

	ListInstanceStorageConfigs(*connect.ListInstanceStorageConfigsInput) (*connect.ListInstanceStorageConfigsOutput, error)
	ListInstanceStorageConfigsWithContext(aws.Context, *connect.ListInstanceStorageConfigsInput, ...request.Option) (*connect.ListInstanceStorageConfigsOutput, error)
	ListInstanceStorageConfigsRequest(*connect.ListInstanceStorageConfigsInput) (*request.Request, *connect.ListInstanceStorageConfigsOutput)

	ListInstanceStorageConfigsPages(*connect.ListInstanceStorageConfigsInput, func(*connect.ListInstanceStorageConfigsOutput, bool) bool) error
	ListInstanceStorageConfigsPagesWithContext(aws.Context, *connect.ListInstanceStorageConfigsInput, func(*connect.ListInstanceStorageConfigsOutput, bool) bool, ...request.Option) error

	ListInstances(*connect.ListInstancesInput) (*connect.ListInstancesOutput, error)
	ListInstancesWithContext(aws.Context, *connect.ListInstancesInput, ...request.Option) (*connect.ListInstancesOutput, error)
	ListInstancesRequest(*connect.ListInstancesInput) (*request.Request, *connect.ListInstancesOutput)

	ListInstancesPages(*connect.ListInstancesInput, func(*connect.ListInstancesOutput, bool) bool) error
	ListInstancesPagesWithContext(aws.Context, *connect.ListInstancesInput, func(*connect.ListInstancesOutput, bool) bool, ...request.Option) error

	ListIntegrationAssociations(*connect.ListIntegrationAssociationsInput) (*connect.ListIntegrationAssociationsOutput, error)
	ListIntegrationAssociationsWithContext(aws.Context, *connect.ListIntegrationAssociationsInput, ...request.Option) (*connect.ListIntegrationAssociationsOutput, error)
	ListIntegrationAssociationsRequest(*connect.ListIntegrationAssociationsInput) (*request.Request, *connect.ListIntegrationAssociationsOutput)

	ListIntegrationAssociationsPages(*connect.ListIntegrationAssociationsInput, func(*connect.ListIntegrationAssociationsOutput, bool) bool) error
	ListIntegrationAssociationsPagesWithContext(aws.Context, *connect.ListIntegrationAssociationsInput, func(*connect.ListIntegrationAssociationsOutput, bool) bool, ...request.Option) error

	ListLambdaFunctions(*connect.ListLambdaFunctionsInput) (*connect.ListLambdaFunctionsOutput, error)
	ListLambdaFunctionsWithContext(aws.Context, *connect.ListLambdaFunctionsInput, ...request.Option) (*connect.ListLambdaFunctionsOutput, error)
	ListLambdaFunctionsRequest(*connect.ListLambdaFunctionsInput) (*request.Request, *connect.ListLambdaFunctionsOutput)

	ListLambdaFunctionsPages(*connect.ListLambdaFunctionsInput, func(*connect.ListLambdaFunctionsOutput, bool) bool) error
	ListLambdaFunctionsPagesWithContext(aws.Context, *connect.ListLambdaFunctionsInput, func(*connect.ListLambdaFunctionsOutput, bool) bool, ...request.Option) error

	ListLexBots(*connect.ListLexBotsInput) (*connect.ListLexBotsOutput, error)
	ListLexBotsWithContext(aws.Context, *connect.ListLexBotsInput, ...request.Option) (*connect.ListLexBotsOutput, error)
	ListLexBotsRequest(*connect.ListLexBotsInput) (*request.Request, *connect.ListLexBotsOutput)

	ListLexBotsPages(*connect.ListLexBotsInput, func(*connect.ListLexBotsOutput, bool) bool) error
	ListLexBotsPagesWithContext(aws.Context, *connect.ListLexBotsInput, func(*connect.ListLexBotsOutput, bool) bool, ...request.Option) error

	ListPhoneNumbers(*connect.ListPhoneNumbersInput) (*connect.ListPhoneNumbersOutput, error)
	ListPhoneNumbersWithContext(aws.Context, *connect.ListPhoneNumbersInput, ...request.Option) (*connect.ListPhoneNumbersOutput, error)
	ListPhoneNumbersRequest(*connect.ListPhoneNumbersInput) (*request.Request, *connect.ListPhoneNumbersOutput)

	ListPhoneNumbersPages(*connect.ListPhoneNumbersInput, func(*connect.ListPhoneNumbersOutput, bool) bool) error
	ListPhoneNumbersPagesWithContext(aws.Context, *connect.ListPhoneNumbersInput, func(*connect.ListPhoneNumbersOutput, bool) bool, ...request.Option) error

	ListPhoneNumbersV2(*connect.ListPhoneNumbersV2Input) (*connect.ListPhoneNumbersV2Output, error)
	ListPhoneNumbersV2WithContext(aws.Context, *connect.ListPhoneNumbersV2Input, ...request.Option) (*connect.ListPhoneNumbersV2Output, error)
	ListPhoneNumbersV2Request(*connect.ListPhoneNumbersV2Input) (*request.Request, *connect.ListPhoneNumbersV2Output)

	ListPhoneNumbersV2Pages(*connect.ListPhoneNumbersV2Input, func(*connect.ListPhoneNumbersV2Output, bool) bool) error
	ListPhoneNumbersV2PagesWithContext(aws.Context, *connect.ListPhoneNumbersV2Input, func(*connect.ListPhoneNumbersV2Output, bool) bool, ...request.Option) error

	ListPrompts(*connect.ListPromptsInput) (*connect.ListPromptsOutput, error)
	ListPromptsWithContext(aws.Context, *connect.ListPromptsInput, ...request.Option) (*connect.ListPromptsOutput, error)
	ListPromptsRequest(*connect.ListPromptsInput) (*request.Request, *connect.ListPromptsOutput)

	ListPromptsPages(*connect.ListPromptsInput, func(*connect.ListPromptsOutput, bool) bool) error
	ListPromptsPagesWithContext(aws.Context, *connect.ListPromptsInput, func(*connect.ListPromptsOutput, bool) bool, ...request.Option) error

	ListQueueQuickConnects(*connect.ListQueueQuickConnectsInput) (*connect.ListQueueQuickConnectsOutput, error)
	ListQueueQuickConnectsWithContext(aws.Context, *connect.ListQueueQuickConnectsInput, ...request.Option) (*connect.ListQueueQuickConnectsOutput, error)
	ListQueueQuickConnectsRequest(*connect.ListQueueQuickConnectsInput) (*request.Request, *connect.ListQueueQuickConnectsOutput)

	ListQueueQuickConnectsPages(*connect.ListQueueQuickConnectsInput, func(*connect.ListQueueQuickConnectsOutput, bool) bool) error
	ListQueueQuickConnectsPagesWithContext(aws.Context, *connect.ListQueueQuickConnectsInput, func(*connect.ListQueueQuickConnectsOutput, bool) bool, ...request.Option) error

	ListQueues(*connect.ListQueuesInput) (*connect.ListQueuesOutput, error)
	ListQueuesWithContext(aws.Context, *connect.ListQueuesInput, ...request.Option) (*connect.ListQueuesOutput, error)
	ListQueuesRequest(*connect.ListQueuesInput) (*request.Request, *connect.ListQueuesOutput)

	ListQueuesPages(*connect.ListQueuesInput, func(*connect.ListQueuesOutput, bool) bool) error
	ListQueuesPagesWithContext(aws.Context, *connect.ListQueuesInput, func(*connect.ListQueuesOutput, bool) bool, ...request.Option) error

	ListQuickConnects(*connect.ListQuickConnectsInput) (*connect.ListQuickConnectsOutput, error)
	ListQuickConnectsWithContext(aws.Context, *connect.ListQuickConnectsInput, ...request.Option) (*connect.ListQuickConnectsOutput, error)
	ListQuickConnectsRequest(*connect.ListQuickConnectsInput) (*request.Request, *connect.ListQuickConnectsOutput)

	ListQuickConnectsPages(*connect.ListQuickConnectsInput, func(*connect.ListQuickConnectsOutput, bool) bool) error
	ListQuickConnectsPagesWithContext(aws.Context, *connect.ListQuickConnectsInput, func(*connect.ListQuickConnectsOutput, bool) bool, ...request.Option) error

	ListRoutingProfileQueues(*connect.ListRoutingProfileQueuesInput) (*connect.ListRoutingProfileQueuesOutput, error)
	ListRoutingProfileQueuesWithContext(aws.Context, *connect.ListRoutingProfileQueuesInput, ...request.Option) (*connect.ListRoutingProfileQueuesOutput, error)
	ListRoutingProfileQueuesRequest(*connect.ListRoutingProfileQueuesInput) (*request.Request, *connect.ListRoutingProfileQueuesOutput)

	ListRoutingProfileQueuesPages(*connect.ListRoutingProfileQueuesInput, func(*connect.ListRoutingProfileQueuesOutput, bool) bool) error
	ListRoutingProfileQueuesPagesWithContext(aws.Context, *connect.ListRoutingProfileQueuesInput, func(*connect.ListRoutingProfileQueuesOutput, bool) bool, ...request.Option) error

	ListRoutingProfiles(*connect.ListRoutingProfilesInput) (*connect.ListRoutingProfilesOutput, error)
	ListRoutingProfilesWithContext(aws.Context, *connect.ListRoutingProfilesInput, ...request.Option) (*connect.ListRoutingProfilesOutput, error)
	ListRoutingProfilesRequest(*connect.ListRoutingProfilesInput) (*request.Request, *connect.ListRoutingProfilesOutput)

	ListRoutingProfilesPages(*connect.ListRoutingProfilesInput, func(*connect.ListRoutingProfilesOutput, bool) bool) error
	ListRoutingProfilesPagesWithContext(aws.Context, *connect.ListRoutingProfilesInput, func(*connect.ListRoutingProfilesOutput, bool) bool, ...request.Option) error

	ListRules(*connect.ListRulesInput) (*connect.ListRulesOutput, error)
	ListRulesWithContext(aws.Context, *connect.ListRulesInput, ...request.Option) (*connect.ListRulesOutput, error)
	ListRulesRequest(*connect.ListRulesInput) (*request.Request, *connect.ListRulesOutput)

	ListRulesPages(*connect.ListRulesInput, func(*connect.ListRulesOutput, bool) bool) error
	ListRulesPagesWithContext(aws.Context, *connect.ListRulesInput, func(*connect.ListRulesOutput, bool) bool, ...request.Option) error

	ListSecurityKeys(*connect.ListSecurityKeysInput) (*connect.ListSecurityKeysOutput, error)
	ListSecurityKeysWithContext(aws.Context, *connect.ListSecurityKeysInput, ...request.Option) (*connect.ListSecurityKeysOutput, error)
	ListSecurityKeysRequest(*connect.ListSecurityKeysInput) (*request.Request, *connect.ListSecurityKeysOutput)

	ListSecurityKeysPages(*connect.ListSecurityKeysInput, func(*connect.ListSecurityKeysOutput, bool) bool) error
	ListSecurityKeysPagesWithContext(aws.Context, *connect.ListSecurityKeysInput, func(*connect.ListSecurityKeysOutput, bool) bool, ...request.Option) error

	ListSecurityProfilePermissions(*connect.ListSecurityProfilePermissionsInput) (*connect.ListSecurityProfilePermissionsOutput, error)
	ListSecurityProfilePermissionsWithContext(aws.Context, *connect.ListSecurityProfilePermissionsInput, ...request.Option) (*connect.ListSecurityProfilePermissionsOutput, error)
	ListSecurityProfilePermissionsRequest(*connect.ListSecurityProfilePermissionsInput) (*request.Request, *connect.ListSecurityProfilePermissionsOutput)

	ListSecurityProfilePermissionsPages(*connect.ListSecurityProfilePermissionsInput, func(*connect.ListSecurityProfilePermissionsOutput, bool) bool) error
	ListSecurityProfilePermissionsPagesWithContext(aws.Context, *connect.ListSecurityProfilePermissionsInput, func(*connect.ListSecurityProfilePermissionsOutput, bool) bool, ...request.Option) error

	ListSecurityProfiles(*connect.ListSecurityProfilesInput) (*connect.ListSecurityProfilesOutput, error)
	ListSecurityProfilesWithContext(aws.Context, *connect.ListSecurityProfilesInput, ...request.Option) (*connect.ListSecurityProfilesOutput, error)
	ListSecurityProfilesRequest(*connect.ListSecurityProfilesInput) (*request.Request, *connect.ListSecurityProfilesOutput)

	ListSecurityProfilesPages(*connect.ListSecurityProfilesInput, func(*connect.ListSecurityProfilesOutput, bool) bool) error
	ListSecurityProfilesPagesWithContext(aws.Context, *connect.ListSecurityProfilesInput, func(*connect.ListSecurityProfilesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*connect.ListTagsForResourceInput) (*connect.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *connect.ListTagsForResourceInput, ...request.Option) (*connect.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*connect.ListTagsForResourceInput) (*request.Request, *connect.ListTagsForResourceOutput)

	ListTaskTemplates(*connect.ListTaskTemplatesInput) (*connect.ListTaskTemplatesOutput, error)
	ListTaskTemplatesWithContext(aws.Context, *connect.ListTaskTemplatesInput, ...request.Option) (*connect.ListTaskTemplatesOutput, error)
	ListTaskTemplatesRequest(*connect.ListTaskTemplatesInput) (*request.Request, *connect.ListTaskTemplatesOutput)

	ListTaskTemplatesPages(*connect.ListTaskTemplatesInput, func(*connect.ListTaskTemplatesOutput, bool) bool) error
	ListTaskTemplatesPagesWithContext(aws.Context, *connect.ListTaskTemplatesInput, func(*connect.ListTaskTemplatesOutput, bool) bool, ...request.Option) error

	ListTrafficDistributionGroups(*connect.ListTrafficDistributionGroupsInput) (*connect.ListTrafficDistributionGroupsOutput, error)
	ListTrafficDistributionGroupsWithContext(aws.Context, *connect.ListTrafficDistributionGroupsInput, ...request.Option) (*connect.ListTrafficDistributionGroupsOutput, error)
	ListTrafficDistributionGroupsRequest(*connect.ListTrafficDistributionGroupsInput) (*request.Request, *connect.ListTrafficDistributionGroupsOutput)

	ListTrafficDistributionGroupsPages(*connect.ListTrafficDistributionGroupsInput, func(*connect.ListTrafficDistributionGroupsOutput, bool) bool) error
	ListTrafficDistributionGroupsPagesWithContext(aws.Context, *connect.ListTrafficDistributionGroupsInput, func(*connect.ListTrafficDistributionGroupsOutput, bool) bool, ...request.Option) error

	ListUseCases(*connect.ListUseCasesInput) (*connect.ListUseCasesOutput, error)
	ListUseCasesWithContext(aws.Context, *connect.ListUseCasesInput, ...request.Option) (*connect.ListUseCasesOutput, error)
	ListUseCasesRequest(*connect.ListUseCasesInput) (*request.Request, *connect.ListUseCasesOutput)

	ListUseCasesPages(*connect.ListUseCasesInput, func(*connect.ListUseCasesOutput, bool) bool) error
	ListUseCasesPagesWithContext(aws.Context, *connect.ListUseCasesInput, func(*connect.ListUseCasesOutput, bool) bool, ...request.Option) error

	ListUserHierarchyGroups(*connect.ListUserHierarchyGroupsInput) (*connect.ListUserHierarchyGroupsOutput, error)
	ListUserHierarchyGroupsWithContext(aws.Context, *connect.ListUserHierarchyGroupsInput, ...request.Option) (*connect.ListUserHierarchyGroupsOutput, error)
	ListUserHierarchyGroupsRequest(*connect.ListUserHierarchyGroupsInput) (*request.Request, *connect.ListUserHierarchyGroupsOutput)

	ListUserHierarchyGroupsPages(*connect.ListUserHierarchyGroupsInput, func(*connect.ListUserHierarchyGroupsOutput, bool) bool) error
	ListUserHierarchyGroupsPagesWithContext(aws.Context, *connect.ListUserHierarchyGroupsInput, func(*connect.ListUserHierarchyGroupsOutput, bool) bool, ...request.Option) error

	ListUsers(*connect.ListUsersInput) (*connect.ListUsersOutput, error)
	ListUsersWithContext(aws.Context, *connect.ListUsersInput, ...request.Option) (*connect.ListUsersOutput, error)
	ListUsersRequest(*connect.ListUsersInput) (*request.Request, *connect.ListUsersOutput)

	ListUsersPages(*connect.ListUsersInput, func(*connect.ListUsersOutput, bool) bool) error
	ListUsersPagesWithContext(aws.Context, *connect.ListUsersInput, func(*connect.ListUsersOutput, bool) bool, ...request.Option) error

	MonitorContact(*connect.MonitorContactInput) (*connect.MonitorContactOutput, error)
	MonitorContactWithContext(aws.Context, *connect.MonitorContactInput, ...request.Option) (*connect.MonitorContactOutput, error)
	MonitorContactRequest(*connect.MonitorContactInput) (*request.Request, *connect.MonitorContactOutput)

	PutUserStatus(*connect.PutUserStatusInput) (*connect.PutUserStatusOutput, error)
	PutUserStatusWithContext(aws.Context, *connect.PutUserStatusInput, ...request.Option) (*connect.PutUserStatusOutput, error)
	PutUserStatusRequest(*connect.PutUserStatusInput) (*request.Request, *connect.PutUserStatusOutput)

	ReleasePhoneNumber(*connect.ReleasePhoneNumberInput) (*connect.ReleasePhoneNumberOutput, error)
	ReleasePhoneNumberWithContext(aws.Context, *connect.ReleasePhoneNumberInput, ...request.Option) (*connect.ReleasePhoneNumberOutput, error)
	ReleasePhoneNumberRequest(*connect.ReleasePhoneNumberInput) (*request.Request, *connect.ReleasePhoneNumberOutput)

	ReplicateInstance(*connect.ReplicateInstanceInput) (*connect.ReplicateInstanceOutput, error)
	ReplicateInstanceWithContext(aws.Context, *connect.ReplicateInstanceInput, ...request.Option) (*connect.ReplicateInstanceOutput, error)
	ReplicateInstanceRequest(*connect.ReplicateInstanceInput) (*request.Request, *connect.ReplicateInstanceOutput)

	ResumeContactRecording(*connect.ResumeContactRecordingInput) (*connect.ResumeContactRecordingOutput, error)
	ResumeContactRecordingWithContext(aws.Context, *connect.ResumeContactRecordingInput, ...request.Option) (*connect.ResumeContactRecordingOutput, error)
	ResumeContactRecordingRequest(*connect.ResumeContactRecordingInput) (*request.Request, *connect.ResumeContactRecordingOutput)

	SearchAvailablePhoneNumbers(*connect.SearchAvailablePhoneNumbersInput) (*connect.SearchAvailablePhoneNumbersOutput, error)
	SearchAvailablePhoneNumbersWithContext(aws.Context, *connect.SearchAvailablePhoneNumbersInput, ...request.Option) (*connect.SearchAvailablePhoneNumbersOutput, error)
	SearchAvailablePhoneNumbersRequest(*connect.SearchAvailablePhoneNumbersInput) (*request.Request, *connect.SearchAvailablePhoneNumbersOutput)

	SearchAvailablePhoneNumbersPages(*connect.SearchAvailablePhoneNumbersInput, func(*connect.SearchAvailablePhoneNumbersOutput, bool) bool) error
	SearchAvailablePhoneNumbersPagesWithContext(aws.Context, *connect.SearchAvailablePhoneNumbersInput, func(*connect.SearchAvailablePhoneNumbersOutput, bool) bool, ...request.Option) error

	SearchHoursOfOperations(*connect.SearchHoursOfOperationsInput) (*connect.SearchHoursOfOperationsOutput, error)
	SearchHoursOfOperationsWithContext(aws.Context, *connect.SearchHoursOfOperationsInput, ...request.Option) (*connect.SearchHoursOfOperationsOutput, error)
	SearchHoursOfOperationsRequest(*connect.SearchHoursOfOperationsInput) (*request.Request, *connect.SearchHoursOfOperationsOutput)

	SearchHoursOfOperationsPages(*connect.SearchHoursOfOperationsInput, func(*connect.SearchHoursOfOperationsOutput, bool) bool) error
	SearchHoursOfOperationsPagesWithContext(aws.Context, *connect.SearchHoursOfOperationsInput, func(*connect.SearchHoursOfOperationsOutput, bool) bool, ...request.Option) error

	SearchPrompts(*connect.SearchPromptsInput) (*connect.SearchPromptsOutput, error)
	SearchPromptsWithContext(aws.Context, *connect.SearchPromptsInput, ...request.Option) (*connect.SearchPromptsOutput, error)
	SearchPromptsRequest(*connect.SearchPromptsInput) (*request.Request, *connect.SearchPromptsOutput)

	SearchPromptsPages(*connect.SearchPromptsInput, func(*connect.SearchPromptsOutput, bool) bool) error
	SearchPromptsPagesWithContext(aws.Context, *connect.SearchPromptsInput, func(*connect.SearchPromptsOutput, bool) bool, ...request.Option) error

	SearchQueues(*connect.SearchQueuesInput) (*connect.SearchQueuesOutput, error)
	SearchQueuesWithContext(aws.Context, *connect.SearchQueuesInput, ...request.Option) (*connect.SearchQueuesOutput, error)
	SearchQueuesRequest(*connect.SearchQueuesInput) (*request.Request, *connect.SearchQueuesOutput)

	SearchQueuesPages(*connect.SearchQueuesInput, func(*connect.SearchQueuesOutput, bool) bool) error
	SearchQueuesPagesWithContext(aws.Context, *connect.SearchQueuesInput, func(*connect.SearchQueuesOutput, bool) bool, ...request.Option) error

	SearchQuickConnects(*connect.SearchQuickConnectsInput) (*connect.SearchQuickConnectsOutput, error)
	SearchQuickConnectsWithContext(aws.Context, *connect.SearchQuickConnectsInput, ...request.Option) (*connect.SearchQuickConnectsOutput, error)
	SearchQuickConnectsRequest(*connect.SearchQuickConnectsInput) (*request.Request, *connect.SearchQuickConnectsOutput)

	SearchQuickConnectsPages(*connect.SearchQuickConnectsInput, func(*connect.SearchQuickConnectsOutput, bool) bool) error
	SearchQuickConnectsPagesWithContext(aws.Context, *connect.SearchQuickConnectsInput, func(*connect.SearchQuickConnectsOutput, bool) bool, ...request.Option) error

	SearchResourceTags(*connect.SearchResourceTagsInput) (*connect.SearchResourceTagsOutput, error)
	SearchResourceTagsWithContext(aws.Context, *connect.SearchResourceTagsInput, ...request.Option) (*connect.SearchResourceTagsOutput, error)
	SearchResourceTagsRequest(*connect.SearchResourceTagsInput) (*request.Request, *connect.SearchResourceTagsOutput)

	SearchResourceTagsPages(*connect.SearchResourceTagsInput, func(*connect.SearchResourceTagsOutput, bool) bool) error
	SearchResourceTagsPagesWithContext(aws.Context, *connect.SearchResourceTagsInput, func(*connect.SearchResourceTagsOutput, bool) bool, ...request.Option) error

	SearchRoutingProfiles(*connect.SearchRoutingProfilesInput) (*connect.SearchRoutingProfilesOutput, error)
	SearchRoutingProfilesWithContext(aws.Context, *connect.SearchRoutingProfilesInput, ...request.Option) (*connect.SearchRoutingProfilesOutput, error)
	SearchRoutingProfilesRequest(*connect.SearchRoutingProfilesInput) (*request.Request, *connect.SearchRoutingProfilesOutput)

	SearchRoutingProfilesPages(*connect.SearchRoutingProfilesInput, func(*connect.SearchRoutingProfilesOutput, bool) bool) error
	SearchRoutingProfilesPagesWithContext(aws.Context, *connect.SearchRoutingProfilesInput, func(*connect.SearchRoutingProfilesOutput, bool) bool, ...request.Option) error

	SearchSecurityProfiles(*connect.SearchSecurityProfilesInput) (*connect.SearchSecurityProfilesOutput, error)
	SearchSecurityProfilesWithContext(aws.Context, *connect.SearchSecurityProfilesInput, ...request.Option) (*connect.SearchSecurityProfilesOutput, error)
	SearchSecurityProfilesRequest(*connect.SearchSecurityProfilesInput) (*request.Request, *connect.SearchSecurityProfilesOutput)

	SearchSecurityProfilesPages(*connect.SearchSecurityProfilesInput, func(*connect.SearchSecurityProfilesOutput, bool) bool) error
	SearchSecurityProfilesPagesWithContext(aws.Context, *connect.SearchSecurityProfilesInput, func(*connect.SearchSecurityProfilesOutput, bool) bool, ...request.Option) error

	SearchUsers(*connect.SearchUsersInput) (*connect.SearchUsersOutput, error)
	SearchUsersWithContext(aws.Context, *connect.SearchUsersInput, ...request.Option) (*connect.SearchUsersOutput, error)
	SearchUsersRequest(*connect.SearchUsersInput) (*request.Request, *connect.SearchUsersOutput)

	SearchUsersPages(*connect.SearchUsersInput, func(*connect.SearchUsersOutput, bool) bool) error
	SearchUsersPagesWithContext(aws.Context, *connect.SearchUsersInput, func(*connect.SearchUsersOutput, bool) bool, ...request.Option) error

	SearchVocabularies(*connect.SearchVocabulariesInput) (*connect.SearchVocabulariesOutput, error)
	SearchVocabulariesWithContext(aws.Context, *connect.SearchVocabulariesInput, ...request.Option) (*connect.SearchVocabulariesOutput, error)
	SearchVocabulariesRequest(*connect.SearchVocabulariesInput) (*request.Request, *connect.SearchVocabulariesOutput)

	SearchVocabulariesPages(*connect.SearchVocabulariesInput, func(*connect.SearchVocabulariesOutput, bool) bool) error
	SearchVocabulariesPagesWithContext(aws.Context, *connect.SearchVocabulariesInput, func(*connect.SearchVocabulariesOutput, bool) bool, ...request.Option) error

	StartChatContact(*connect.StartChatContactInput) (*connect.StartChatContactOutput, error)
	StartChatContactWithContext(aws.Context, *connect.StartChatContactInput, ...request.Option) (*connect.StartChatContactOutput, error)
	StartChatContactRequest(*connect.StartChatContactInput) (*request.Request, *connect.StartChatContactOutput)

	StartContactEvaluation(*connect.StartContactEvaluationInput) (*connect.StartContactEvaluationOutput, error)
	StartContactEvaluationWithContext(aws.Context, *connect.StartContactEvaluationInput, ...request.Option) (*connect.StartContactEvaluationOutput, error)
	StartContactEvaluationRequest(*connect.StartContactEvaluationInput) (*request.Request, *connect.StartContactEvaluationOutput)

	StartContactRecording(*connect.StartContactRecordingInput) (*connect.StartContactRecordingOutput, error)
	StartContactRecordingWithContext(aws.Context, *connect.StartContactRecordingInput, ...request.Option) (*connect.StartContactRecordingOutput, error)
	StartContactRecordingRequest(*connect.StartContactRecordingInput) (*request.Request, *connect.StartContactRecordingOutput)

	StartContactStreaming(*connect.StartContactStreamingInput) (*connect.StartContactStreamingOutput, error)
	StartContactStreamingWithContext(aws.Context, *connect.StartContactStreamingInput, ...request.Option) (*connect.StartContactStreamingOutput, error)
	StartContactStreamingRequest(*connect.StartContactStreamingInput) (*request.Request, *connect.StartContactStreamingOutput)

	StartOutboundVoiceContact(*connect.StartOutboundVoiceContactInput) (*connect.StartOutboundVoiceContactOutput, error)
	StartOutboundVoiceContactWithContext(aws.Context, *connect.StartOutboundVoiceContactInput, ...request.Option) (*connect.StartOutboundVoiceContactOutput, error)
	StartOutboundVoiceContactRequest(*connect.StartOutboundVoiceContactInput) (*request.Request, *connect.StartOutboundVoiceContactOutput)

	StartTaskContact(*connect.StartTaskContactInput) (*connect.StartTaskContactOutput, error)
	StartTaskContactWithContext(aws.Context, *connect.StartTaskContactInput, ...request.Option) (*connect.StartTaskContactOutput, error)
	StartTaskContactRequest(*connect.StartTaskContactInput) (*request.Request, *connect.StartTaskContactOutput)

	StopContact(*connect.StopContactInput) (*connect.StopContactOutput, error)
	StopContactWithContext(aws.Context, *connect.StopContactInput, ...request.Option) (*connect.StopContactOutput, error)
	StopContactRequest(*connect.StopContactInput) (*request.Request, *connect.StopContactOutput)

	StopContactRecording(*connect.StopContactRecordingInput) (*connect.StopContactRecordingOutput, error)
	StopContactRecordingWithContext(aws.Context, *connect.StopContactRecordingInput, ...request.Option) (*connect.StopContactRecordingOutput, error)
	StopContactRecordingRequest(*connect.StopContactRecordingInput) (*request.Request, *connect.StopContactRecordingOutput)

	StopContactStreaming(*connect.StopContactStreamingInput) (*connect.StopContactStreamingOutput, error)
	StopContactStreamingWithContext(aws.Context, *connect.StopContactStreamingInput, ...request.Option) (*connect.StopContactStreamingOutput, error)
	StopContactStreamingRequest(*connect.StopContactStreamingInput) (*request.Request, *connect.StopContactStreamingOutput)

	SubmitContactEvaluation(*connect.SubmitContactEvaluationInput) (*connect.SubmitContactEvaluationOutput, error)
	SubmitContactEvaluationWithContext(aws.Context, *connect.SubmitContactEvaluationInput, ...request.Option) (*connect.SubmitContactEvaluationOutput, error)
	SubmitContactEvaluationRequest(*connect.SubmitContactEvaluationInput) (*request.Request, *connect.SubmitContactEvaluationOutput)

	SuspendContactRecording(*connect.SuspendContactRecordingInput) (*connect.SuspendContactRecordingOutput, error)
	SuspendContactRecordingWithContext(aws.Context, *connect.SuspendContactRecordingInput, ...request.Option) (*connect.SuspendContactRecordingOutput, error)
	SuspendContactRecordingRequest(*connect.SuspendContactRecordingInput) (*request.Request, *connect.SuspendContactRecordingOutput)

	TagResource(*connect.TagResourceInput) (*connect.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *connect.TagResourceInput, ...request.Option) (*connect.TagResourceOutput, error)
	TagResourceRequest(*connect.TagResourceInput) (*request.Request, *connect.TagResourceOutput)

	TransferContact(*connect.TransferContactInput) (*connect.TransferContactOutput, error)
	TransferContactWithContext(aws.Context, *connect.TransferContactInput, ...request.Option) (*connect.TransferContactOutput, error)
	TransferContactRequest(*connect.TransferContactInput) (*request.Request, *connect.TransferContactOutput)

	UntagResource(*connect.UntagResourceInput) (*connect.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *connect.UntagResourceInput, ...request.Option) (*connect.UntagResourceOutput, error)
	UntagResourceRequest(*connect.UntagResourceInput) (*request.Request, *connect.UntagResourceOutput)

	UpdateAgentStatus(*connect.UpdateAgentStatusInput) (*connect.UpdateAgentStatusOutput, error)
	UpdateAgentStatusWithContext(aws.Context, *connect.UpdateAgentStatusInput, ...request.Option) (*connect.UpdateAgentStatusOutput, error)
	UpdateAgentStatusRequest(*connect.UpdateAgentStatusInput) (*request.Request, *connect.UpdateAgentStatusOutput)

	UpdateContact(*connect.UpdateContactInput) (*connect.UpdateContactOutput, error)
	UpdateContactWithContext(aws.Context, *connect.UpdateContactInput, ...request.Option) (*connect.UpdateContactOutput, error)
	UpdateContactRequest(*connect.UpdateContactInput) (*request.Request, *connect.UpdateContactOutput)

	UpdateContactAttributes(*connect.UpdateContactAttributesInput) (*connect.UpdateContactAttributesOutput, error)
	UpdateContactAttributesWithContext(aws.Context, *connect.UpdateContactAttributesInput, ...request.Option) (*connect.UpdateContactAttributesOutput, error)
	UpdateContactAttributesRequest(*connect.UpdateContactAttributesInput) (*request.Request, *connect.UpdateContactAttributesOutput)

	UpdateContactEvaluation(*connect.UpdateContactEvaluationInput) (*connect.UpdateContactEvaluationOutput, error)
	UpdateContactEvaluationWithContext(aws.Context, *connect.UpdateContactEvaluationInput, ...request.Option) (*connect.UpdateContactEvaluationOutput, error)
	UpdateContactEvaluationRequest(*connect.UpdateContactEvaluationInput) (*request.Request, *connect.UpdateContactEvaluationOutput)

	UpdateContactFlowContent(*connect.UpdateContactFlowContentInput) (*connect.UpdateContactFlowContentOutput, error)
	UpdateContactFlowContentWithContext(aws.Context, *connect.UpdateContactFlowContentInput, ...request.Option) (*connect.UpdateContactFlowContentOutput, error)
	UpdateContactFlowContentRequest(*connect.UpdateContactFlowContentInput) (*request.Request, *connect.UpdateContactFlowContentOutput)

	UpdateContactFlowMetadata(*connect.UpdateContactFlowMetadataInput) (*connect.UpdateContactFlowMetadataOutput, error)
	UpdateContactFlowMetadataWithContext(aws.Context, *connect.UpdateContactFlowMetadataInput, ...request.Option) (*connect.UpdateContactFlowMetadataOutput, error)
	UpdateContactFlowMetadataRequest(*connect.UpdateContactFlowMetadataInput) (*request.Request, *connect.UpdateContactFlowMetadataOutput)

	UpdateContactFlowModuleContent(*connect.UpdateContactFlowModuleContentInput) (*connect.UpdateContactFlowModuleContentOutput, error)
	UpdateContactFlowModuleContentWithContext(aws.Context, *connect.UpdateContactFlowModuleContentInput, ...request.Option) (*connect.UpdateContactFlowModuleContentOutput, error)
	UpdateContactFlowModuleContentRequest(*connect.UpdateContactFlowModuleContentInput) (*request.Request, *connect.UpdateContactFlowModuleContentOutput)

	UpdateContactFlowModuleMetadata(*connect.UpdateContactFlowModuleMetadataInput) (*connect.UpdateContactFlowModuleMetadataOutput, error)
	UpdateContactFlowModuleMetadataWithContext(aws.Context, *connect.UpdateContactFlowModuleMetadataInput, ...request.Option) (*connect.UpdateContactFlowModuleMetadataOutput, error)
	UpdateContactFlowModuleMetadataRequest(*connect.UpdateContactFlowModuleMetadataInput) (*request.Request, *connect.UpdateContactFlowModuleMetadataOutput)

	UpdateContactFlowName(*connect.UpdateContactFlowNameInput) (*connect.UpdateContactFlowNameOutput, error)
	UpdateContactFlowNameWithContext(aws.Context, *connect.UpdateContactFlowNameInput, ...request.Option) (*connect.UpdateContactFlowNameOutput, error)
	UpdateContactFlowNameRequest(*connect.UpdateContactFlowNameInput) (*request.Request, *connect.UpdateContactFlowNameOutput)

	UpdateContactSchedule(*connect.UpdateContactScheduleInput) (*connect.UpdateContactScheduleOutput, error)
	UpdateContactScheduleWithContext(aws.Context, *connect.UpdateContactScheduleInput, ...request.Option) (*connect.UpdateContactScheduleOutput, error)
	UpdateContactScheduleRequest(*connect.UpdateContactScheduleInput) (*request.Request, *connect.UpdateContactScheduleOutput)

	UpdateEvaluationForm(*connect.UpdateEvaluationFormInput) (*connect.UpdateEvaluationFormOutput, error)
	UpdateEvaluationFormWithContext(aws.Context, *connect.UpdateEvaluationFormInput, ...request.Option) (*connect.UpdateEvaluationFormOutput, error)
	UpdateEvaluationFormRequest(*connect.UpdateEvaluationFormInput) (*request.Request, *connect.UpdateEvaluationFormOutput)

	UpdateHoursOfOperation(*connect.UpdateHoursOfOperationInput) (*connect.UpdateHoursOfOperationOutput, error)
	UpdateHoursOfOperationWithContext(aws.Context, *connect.UpdateHoursOfOperationInput, ...request.Option) (*connect.UpdateHoursOfOperationOutput, error)
	UpdateHoursOfOperationRequest(*connect.UpdateHoursOfOperationInput) (*request.Request, *connect.UpdateHoursOfOperationOutput)

	UpdateInstanceAttribute(*connect.UpdateInstanceAttributeInput) (*connect.UpdateInstanceAttributeOutput, error)
	UpdateInstanceAttributeWithContext(aws.Context, *connect.UpdateInstanceAttributeInput, ...request.Option) (*connect.UpdateInstanceAttributeOutput, error)
	UpdateInstanceAttributeRequest(*connect.UpdateInstanceAttributeInput) (*request.Request, *connect.UpdateInstanceAttributeOutput)

	UpdateInstanceStorageConfig(*connect.UpdateInstanceStorageConfigInput) (*connect.UpdateInstanceStorageConfigOutput, error)
	UpdateInstanceStorageConfigWithContext(aws.Context, *connect.UpdateInstanceStorageConfigInput, ...request.Option) (*connect.UpdateInstanceStorageConfigOutput, error)
	UpdateInstanceStorageConfigRequest(*connect.UpdateInstanceStorageConfigInput) (*request.Request, *connect.UpdateInstanceStorageConfigOutput)

	UpdateParticipantRoleConfig(*connect.UpdateParticipantRoleConfigInput) (*connect.UpdateParticipantRoleConfigOutput, error)
	UpdateParticipantRoleConfigWithContext(aws.Context, *connect.UpdateParticipantRoleConfigInput, ...request.Option) (*connect.UpdateParticipantRoleConfigOutput, error)
	UpdateParticipantRoleConfigRequest(*connect.UpdateParticipantRoleConfigInput) (*request.Request, *connect.UpdateParticipantRoleConfigOutput)

	UpdatePhoneNumber(*connect.UpdatePhoneNumberInput) (*connect.UpdatePhoneNumberOutput, error)
	UpdatePhoneNumberWithContext(aws.Context, *connect.UpdatePhoneNumberInput, ...request.Option) (*connect.UpdatePhoneNumberOutput, error)
	UpdatePhoneNumberRequest(*connect.UpdatePhoneNumberInput) (*request.Request, *connect.UpdatePhoneNumberOutput)

	UpdatePrompt(*connect.UpdatePromptInput) (*connect.UpdatePromptOutput, error)
	UpdatePromptWithContext(aws.Context, *connect.UpdatePromptInput, ...request.Option) (*connect.UpdatePromptOutput, error)
	UpdatePromptRequest(*connect.UpdatePromptInput) (*request.Request, *connect.UpdatePromptOutput)

	UpdateQueueHoursOfOperation(*connect.UpdateQueueHoursOfOperationInput) (*connect.UpdateQueueHoursOfOperationOutput, error)
	UpdateQueueHoursOfOperationWithContext(aws.Context, *connect.UpdateQueueHoursOfOperationInput, ...request.Option) (*connect.UpdateQueueHoursOfOperationOutput, error)
	UpdateQueueHoursOfOperationRequest(*connect.UpdateQueueHoursOfOperationInput) (*request.Request, *connect.UpdateQueueHoursOfOperationOutput)

	UpdateQueueMaxContacts(*connect.UpdateQueueMaxContactsInput) (*connect.UpdateQueueMaxContactsOutput, error)
	UpdateQueueMaxContactsWithContext(aws.Context, *connect.UpdateQueueMaxContactsInput, ...request.Option) (*connect.UpdateQueueMaxContactsOutput, error)
	UpdateQueueMaxContactsRequest(*connect.UpdateQueueMaxContactsInput) (*request.Request, *connect.UpdateQueueMaxContactsOutput)

	UpdateQueueName(*connect.UpdateQueueNameInput) (*connect.UpdateQueueNameOutput, error)
	UpdateQueueNameWithContext(aws.Context, *connect.UpdateQueueNameInput, ...request.Option) (*connect.UpdateQueueNameOutput, error)
	UpdateQueueNameRequest(*connect.UpdateQueueNameInput) (*request.Request, *connect.UpdateQueueNameOutput)

	UpdateQueueOutboundCallerConfig(*connect.UpdateQueueOutboundCallerConfigInput) (*connect.UpdateQueueOutboundCallerConfigOutput, error)
	UpdateQueueOutboundCallerConfigWithContext(aws.Context, *connect.UpdateQueueOutboundCallerConfigInput, ...request.Option) (*connect.UpdateQueueOutboundCallerConfigOutput, error)
	UpdateQueueOutboundCallerConfigRequest(*connect.UpdateQueueOutboundCallerConfigInput) (*request.Request, *connect.UpdateQueueOutboundCallerConfigOutput)

	UpdateQueueStatus(*connect.UpdateQueueStatusInput) (*connect.UpdateQueueStatusOutput, error)
	UpdateQueueStatusWithContext(aws.Context, *connect.UpdateQueueStatusInput, ...request.Option) (*connect.UpdateQueueStatusOutput, error)
	UpdateQueueStatusRequest(*connect.UpdateQueueStatusInput) (*request.Request, *connect.UpdateQueueStatusOutput)

	UpdateQuickConnectConfig(*connect.UpdateQuickConnectConfigInput) (*connect.UpdateQuickConnectConfigOutput, error)
	UpdateQuickConnectConfigWithContext(aws.Context, *connect.UpdateQuickConnectConfigInput, ...request.Option) (*connect.UpdateQuickConnectConfigOutput, error)
	UpdateQuickConnectConfigRequest(*connect.UpdateQuickConnectConfigInput) (*request.Request, *connect.UpdateQuickConnectConfigOutput)

	UpdateQuickConnectName(*connect.UpdateQuickConnectNameInput) (*connect.UpdateQuickConnectNameOutput, error)
	UpdateQuickConnectNameWithContext(aws.Context, *connect.UpdateQuickConnectNameInput, ...request.Option) (*connect.UpdateQuickConnectNameOutput, error)
	UpdateQuickConnectNameRequest(*connect.UpdateQuickConnectNameInput) (*request.Request, *connect.UpdateQuickConnectNameOutput)

	UpdateRoutingProfileAgentAvailabilityTimer(*connect.UpdateRoutingProfileAgentAvailabilityTimerInput) (*connect.UpdateRoutingProfileAgentAvailabilityTimerOutput, error)
	UpdateRoutingProfileAgentAvailabilityTimerWithContext(aws.Context, *connect.UpdateRoutingProfileAgentAvailabilityTimerInput, ...request.Option) (*connect.UpdateRoutingProfileAgentAvailabilityTimerOutput, error)
	UpdateRoutingProfileAgentAvailabilityTimerRequest(*connect.UpdateRoutingProfileAgentAvailabilityTimerInput) (*request.Request, *connect.UpdateRoutingProfileAgentAvailabilityTimerOutput)

	UpdateRoutingProfileConcurrency(*connect.UpdateRoutingProfileConcurrencyInput) (*connect.UpdateRoutingProfileConcurrencyOutput, error)
	UpdateRoutingProfileConcurrencyWithContext(aws.Context, *connect.UpdateRoutingProfileConcurrencyInput, ...request.Option) (*connect.UpdateRoutingProfileConcurrencyOutput, error)
	UpdateRoutingProfileConcurrencyRequest(*connect.UpdateRoutingProfileConcurrencyInput) (*request.Request, *connect.UpdateRoutingProfileConcurrencyOutput)

	UpdateRoutingProfileDefaultOutboundQueue(*connect.UpdateRoutingProfileDefaultOutboundQueueInput) (*connect.UpdateRoutingProfileDefaultOutboundQueueOutput, error)
	UpdateRoutingProfileDefaultOutboundQueueWithContext(aws.Context, *connect.UpdateRoutingProfileDefaultOutboundQueueInput, ...request.Option) (*connect.UpdateRoutingProfileDefaultOutboundQueueOutput, error)
	UpdateRoutingProfileDefaultOutboundQueueRequest(*connect.UpdateRoutingProfileDefaultOutboundQueueInput) (*request.Request, *connect.UpdateRoutingProfileDefaultOutboundQueueOutput)

	UpdateRoutingProfileName(*connect.UpdateRoutingProfileNameInput) (*connect.UpdateRoutingProfileNameOutput, error)
	UpdateRoutingProfileNameWithContext(aws.Context, *connect.UpdateRoutingProfileNameInput, ...request.Option) (*connect.UpdateRoutingProfileNameOutput, error)
	UpdateRoutingProfileNameRequest(*connect.UpdateRoutingProfileNameInput) (*request.Request, *connect.UpdateRoutingProfileNameOutput)

	UpdateRoutingProfileQueues(*connect.UpdateRoutingProfileQueuesInput) (*connect.UpdateRoutingProfileQueuesOutput, error)
	UpdateRoutingProfileQueuesWithContext(aws.Context, *connect.UpdateRoutingProfileQueuesInput, ...request.Option) (*connect.UpdateRoutingProfileQueuesOutput, error)
	UpdateRoutingProfileQueuesRequest(*connect.UpdateRoutingProfileQueuesInput) (*request.Request, *connect.UpdateRoutingProfileQueuesOutput)

	UpdateRule(*connect.UpdateRuleInput) (*connect.UpdateRuleOutput, error)
	UpdateRuleWithContext(aws.Context, *connect.UpdateRuleInput, ...request.Option) (*connect.UpdateRuleOutput, error)
	UpdateRuleRequest(*connect.UpdateRuleInput) (*request.Request, *connect.UpdateRuleOutput)

	UpdateSecurityProfile(*connect.UpdateSecurityProfileInput) (*connect.UpdateSecurityProfileOutput, error)
	UpdateSecurityProfileWithContext(aws.Context, *connect.UpdateSecurityProfileInput, ...request.Option) (*connect.UpdateSecurityProfileOutput, error)
	UpdateSecurityProfileRequest(*connect.UpdateSecurityProfileInput) (*request.Request, *connect.UpdateSecurityProfileOutput)

	UpdateTaskTemplate(*connect.UpdateTaskTemplateInput) (*connect.UpdateTaskTemplateOutput, error)
	UpdateTaskTemplateWithContext(aws.Context, *connect.UpdateTaskTemplateInput, ...request.Option) (*connect.UpdateTaskTemplateOutput, error)
	UpdateTaskTemplateRequest(*connect.UpdateTaskTemplateInput) (*request.Request, *connect.UpdateTaskTemplateOutput)

	UpdateTrafficDistribution(*connect.UpdateTrafficDistributionInput) (*connect.UpdateTrafficDistributionOutput, error)
	UpdateTrafficDistributionWithContext(aws.Context, *connect.UpdateTrafficDistributionInput, ...request.Option) (*connect.UpdateTrafficDistributionOutput, error)
	UpdateTrafficDistributionRequest(*connect.UpdateTrafficDistributionInput) (*request.Request, *connect.UpdateTrafficDistributionOutput)

	UpdateUserHierarchy(*connect.UpdateUserHierarchyInput) (*connect.UpdateUserHierarchyOutput, error)
	UpdateUserHierarchyWithContext(aws.Context, *connect.UpdateUserHierarchyInput, ...request.Option) (*connect.UpdateUserHierarchyOutput, error)
	UpdateUserHierarchyRequest(*connect.UpdateUserHierarchyInput) (*request.Request, *connect.UpdateUserHierarchyOutput)

	UpdateUserHierarchyGroupName(*connect.UpdateUserHierarchyGroupNameInput) (*connect.UpdateUserHierarchyGroupNameOutput, error)
	UpdateUserHierarchyGroupNameWithContext(aws.Context, *connect.UpdateUserHierarchyGroupNameInput, ...request.Option) (*connect.UpdateUserHierarchyGroupNameOutput, error)
	UpdateUserHierarchyGroupNameRequest(*connect.UpdateUserHierarchyGroupNameInput) (*request.Request, *connect.UpdateUserHierarchyGroupNameOutput)

	UpdateUserHierarchyStructure(*connect.UpdateUserHierarchyStructureInput) (*connect.UpdateUserHierarchyStructureOutput, error)
	UpdateUserHierarchyStructureWithContext(aws.Context, *connect.UpdateUserHierarchyStructureInput, ...request.Option) (*connect.UpdateUserHierarchyStructureOutput, error)
	UpdateUserHierarchyStructureRequest(*connect.UpdateUserHierarchyStructureInput) (*request.Request, *connect.UpdateUserHierarchyStructureOutput)

	UpdateUserIdentityInfo(*connect.UpdateUserIdentityInfoInput) (*connect.UpdateUserIdentityInfoOutput, error)
	UpdateUserIdentityInfoWithContext(aws.Context, *connect.UpdateUserIdentityInfoInput, ...request.Option) (*connect.UpdateUserIdentityInfoOutput, error)
	UpdateUserIdentityInfoRequest(*connect.UpdateUserIdentityInfoInput) (*request.Request, *connect.UpdateUserIdentityInfoOutput)

	UpdateUserPhoneConfig(*connect.UpdateUserPhoneConfigInput) (*connect.UpdateUserPhoneConfigOutput, error)
	UpdateUserPhoneConfigWithContext(aws.Context, *connect.UpdateUserPhoneConfigInput, ...request.Option) (*connect.UpdateUserPhoneConfigOutput, error)
	UpdateUserPhoneConfigRequest(*connect.UpdateUserPhoneConfigInput) (*request.Request, *connect.UpdateUserPhoneConfigOutput)

	UpdateUserRoutingProfile(*connect.UpdateUserRoutingProfileInput) (*connect.UpdateUserRoutingProfileOutput, error)
	UpdateUserRoutingProfileWithContext(aws.Context, *connect.UpdateUserRoutingProfileInput, ...request.Option) (*connect.UpdateUserRoutingProfileOutput, error)
	UpdateUserRoutingProfileRequest(*connect.UpdateUserRoutingProfileInput) (*request.Request, *connect.UpdateUserRoutingProfileOutput)

	UpdateUserSecurityProfiles(*connect.UpdateUserSecurityProfilesInput) (*connect.UpdateUserSecurityProfilesOutput, error)
	UpdateUserSecurityProfilesWithContext(aws.Context, *connect.UpdateUserSecurityProfilesInput, ...request.Option) (*connect.UpdateUserSecurityProfilesOutput, error)
	UpdateUserSecurityProfilesRequest(*connect.UpdateUserSecurityProfilesInput) (*request.Request, *connect.UpdateUserSecurityProfilesOutput)
}

var _ ConnectAPI = (*connect.Connect)(nil)
