/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver;

import java.io.File;
import java.util.Collection;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class UnresolvedIdeDependencyHandler {
    private final Logger logger = Logging.getLogger(UnresolvedIdeDependencyHandler.class);

    public void log(Collection<UnresolvedDependencyResult> deps) {
        for (UnresolvedDependencyResult dep : deps) {
            this.log(dep);
        }
    }

    public void log(UnresolvedDependencyResult dep) {
        this.logger.warn("Could not resolve: " + dep.getAttempted());
        this.logger.debug("Could not resolve: " + dep.getAttempted(), dep.getFailure());
    }

    public File asFile(UnresolvedDependencyResult dep) {
        return new File("unresolved dependency - " + dep.getAttempted().getDisplayName().replaceAll(":", " "));
    }
}

