/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Namer;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.PolymorphicDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.PolymorphicDomainObjectContainerInternal;
import org.gradle.api.internal.TypedDomainObjectContainerWrapper;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.Transformers;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.ConfigureDelegate;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;

public abstract class AbstractPolymorphicDomainObjectContainer<T>
extends AbstractNamedDomainObjectContainer<T>
implements PolymorphicDomainObjectContainerInternal<T> {
    private final ContainerElementsDynamicObject elementsDynamicObject = new ContainerElementsDynamicObject();

    protected AbstractPolymorphicDomainObjectContainer(Class<T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, instantiator, namer);
    }

    protected abstract <U extends T> U doCreate(String var1, Class<U> var2);

    @Override
    public <U extends T> U create(String name, Class<U> type) {
        return this.create(name, type, null);
    }

    public <U extends T> U maybeCreate(String name, Class<U> type) throws InvalidUserDataException {
        Object item = this.findByName(name);
        if (item != null) {
            return (U)Transformers.cast(type).transform(item);
        }
        return this.create(name, type);
    }

    public <U extends T> U create(String name, Class<U> type, Action<? super U> configuration) {
        this.assertCanAdd(name);
        U object = this.doCreate(name, type);
        this.add(object);
        if (configuration != null) {
            configuration.execute(object);
        }
        return object;
    }

    @Override
    public <U extends T> NamedDomainObjectProvider<U> register(String name, Class<U> type) throws InvalidUserDataException {
        return this.createDomainObjectProvider(name, type, null);
    }

    public <U extends T> NamedDomainObjectProvider<U> register(String name, Class<U> type, Action<? super U> configurationAction) throws InvalidUserDataException {
        return this.createDomainObjectProvider(name, type, configurationAction);
    }

    protected <U extends T> NamedDomainObjectProvider<U> createDomainObjectProvider(String name, Class<U> type, @Nullable Action<? super U> configurationAction) {
        this.assertCanAdd(name);
        NamedDomainObjectProvider provider = (NamedDomainObjectProvider)Cast.uncheckedCast((Object)this.getInstantiator().newInstance(NamedDomainObjectCreatingProvider.class, new Object[]{this, name, type, configurationAction}));
        this.addLater(provider);
        return provider;
    }

    @Override
    protected DynamicObject getElementsAsDynamicObject() {
        return this.elementsDynamicObject;
    }

    @Override
    protected ConfigureDelegate createConfigureDelegate(Closure configureClosure) {
        return new PolymorphicDomainObjectContainerConfigureDelegate(configureClosure, this);
    }

    public <U extends T> NamedDomainObjectContainer<U> containerWithType(Class<U> type) {
        return (NamedDomainObjectContainer)this.getInstantiator().newInstance(TypedDomainObjectContainerWrapper.class, new Object[]{type, this});
    }

    private class ContainerElementsDynamicObject
    extends AbstractDynamicObject {
        private ContainerElementsDynamicObject() {
        }

        @Override
        public String getDisplayName() {
            return AbstractPolymorphicDomainObjectContainer.this.getDisplayName();
        }

        @Override
        public boolean hasProperty(String name) {
            return AbstractPolymorphicDomainObjectContainer.this.findByName(name) != null;
        }

        @Override
        public DynamicInvokeResult tryGetProperty(String name) {
            Object object = AbstractPolymorphicDomainObjectContainer.this.findByName(name);
            return object == null ? DynamicInvokeResult.notFound() : DynamicInvokeResult.found(object);
        }

        public Map<String, T> getProperties() {
            return AbstractPolymorphicDomainObjectContainer.this.getAsMap();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return this.isConfigureMethod(name, arguments);
        }

        @Override
        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            if (this.isConfigureMethod(name, arguments)) {
                Object element = AbstractPolymorphicDomainObjectContainer.this.getByName(name);
                Object lastArgument = arguments[arguments.length - 1];
                if (lastArgument instanceof Closure) {
                    ConfigureUtil.configure((Closure)lastArgument, element);
                }
                return DynamicInvokeResult.found(element);
            }
            return DynamicInvokeResult.notFound();
        }

        private boolean isConfigureMethod(String name, Object ... arguments) {
            return (arguments.length == 1 && arguments[0] instanceof Closure || arguments.length == 1 && arguments[0] instanceof Class || arguments.length == 2 && arguments[0] instanceof Class && arguments[1] instanceof Closure) && this.hasProperty(name);
        }
    }

    public class NamedDomainObjectCreatingProvider<I extends T>
    extends DefaultNamedDomainObjectCollection.AbstractNamedDomainObjectProvider<I> {
        private I object;
        private Throwable cause;
        private ImmutableActionSet<I> onCreate;
        private final Class<I> type;

        public NamedDomainObjectCreatingProvider(String name, @Nullable Class<I> type, Action<? super I> configureAction) {
            super(name);
            this.type = type;
            this.onCreate = ImmutableActionSet.empty().mergeFrom(AbstractPolymorphicDomainObjectContainer.this.getEventRegister().getAddActions());
            if (configureAction != null) {
                this.configure(configureAction);
            }
        }

        @Override
        @Nullable
        public Class<I> getType() {
            return this.type;
        }

        @Override
        public boolean isPresent() {
            return AbstractPolymorphicDomainObjectContainer.this.findDomainObject(this.getName()) != null;
        }

        public void configure(Action<? super I> action) {
            if (this.object != null) {
                action.execute(this.object);
                return;
            }
            this.onCreate = this.onCreate.mergeFrom(AbstractPolymorphicDomainObjectContainer.this.getEventRegister().getAddActions()).add(action);
        }

        public I getOrNull() {
            if (this.cause != null) {
                throw this.createIllegalStateException();
            }
            if (this.object == null) {
                this.object = this.getType().cast(AbstractPolymorphicDomainObjectContainer.this.findByNameWithoutRules(this.getName()));
                if (this.object == null) {
                    try {
                        this.onCreate = this.onCreate.mergeFrom(AbstractPolymorphicDomainObjectContainer.this.getEventRegister().getAddActions());
                        this.object = AbstractPolymorphicDomainObjectContainer.this.doCreate(this.getName(), this.type);
                        AbstractPolymorphicDomainObjectContainer.this.add(this.object, this.onCreate);
                    }
                    catch (RuntimeException ex) {
                        this.cause = ex;
                        throw this.createIllegalStateException();
                    }
                    finally {
                        this.onCreate = ImmutableActionSet.empty();
                    }
                }
            }
            return this.object;
        }

        private IllegalStateException createIllegalStateException() {
            return new IllegalStateException(String.format("Could not create domain object '%s' (%s)", this.getName(), this.getType().getSimpleName()), this.cause);
        }
    }
}

