/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u001c\u001a\u00020\u0005J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00042\u0006\u0010\u001f\u001a\u00020\u0011J\u0012\u0010 \u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020!0\u0004H\u0002J\f\u0010\"\u001a\u00020\u0016*\u00020\u001aH\u0002J\"\u0010#\u001a\u00020\u0016*\u00020\u001a2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u0010H\u0002J\f\u0010'\u001a\u00020\u0016*\u00020\u001aH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\fj\b\u0012\u0004\u0012\u00020\u0005`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000e\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fj\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0013\u001a*\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00100\u000fj\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0010`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/ir/util/DependenciesCollector;", "", "()V", "dependencyModules", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getDependencyModules", "()Ljava/util/Collection;", "isEmpty", "", "()Z", "modulesForDependencyDescriptors", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "packageFragmentsForDependencyDescriptors", "Ljava/util/LinkedHashMap;", "", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "Lkotlin/collections/LinkedHashMap;", "topLevelDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "addTopLevelDescriptor", "", "descriptor", "collectTopLevelDescriptorsForUnboundSymbols", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "getPackageFragments", "moduleDescriptor", "getTopLevelDeclaration", "getTopLevelDescriptors", "packageFragmentDescriptor", "addTopLevelDeclarations", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "markOverriddenFunctionsForUnboundFunctionsReferenced", "markOverriddenFunctionsReferenced", "function", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "visitedFunctions", "markSuperClassesForUnboundClassesReferenced", "ir.tree"})
public final class DependenciesCollector {
    private final LinkedHashSet<ModuleDescriptor> modulesForDependencyDescriptors = new LinkedHashSet();
    private final LinkedHashMap<ModuleDescriptor, Set<PackageFragmentDescriptor>> packageFragmentsForDependencyDescriptors = new LinkedHashMap();
    private final LinkedHashMap<PackageFragmentDescriptor, Set<DeclarationDescriptor>> topLevelDescriptors = new LinkedHashMap();

    @NotNull
    public final Collection<ModuleDescriptor> getDependencyModules() {
        return this.modulesForDependencyDescriptors;
    }

    @NotNull
    public final Collection<PackageFragmentDescriptor> getPackageFragments(@NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        Set<PackageFragmentDescriptor> set = this.packageFragmentsForDependencyDescriptors.get(moduleDescriptor);
        return set != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
    }

    @NotNull
    public final Collection<DeclarationDescriptor> getTopLevelDescriptors(@NotNull PackageFragmentDescriptor packageFragmentDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)packageFragmentDescriptor, (String)"packageFragmentDescriptor");
        Set<DeclarationDescriptor> set = this.topLevelDescriptors.get(packageFragmentDescriptor);
        return set != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
    }

    public final boolean isEmpty() {
        return this.topLevelDescriptors.isEmpty();
    }

    public final void collectTopLevelDescriptorsForUnboundSymbols(@NotNull SymbolTable symbolTable) {
        Intrinsics.checkParameterIsNotNull((Object)symbolTable, (String)"symbolTable");
        boolean bl = symbolTable.getUnboundTypeParameters().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unbound type parameters: " + symbolTable.getUnboundTypeParameters();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = symbolTable.getUnboundValueParameters().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unbound value parameters: " + symbolTable.getUnboundValueParameters();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = symbolTable.getUnboundVariables().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unbound variables: " + symbolTable.getUnboundVariables();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.markOverriddenFunctionsForUnboundFunctionsReferenced(symbolTable);
        this.markSuperClassesForUnboundClassesReferenced(symbolTable);
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundClasses());
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundConstructors());
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundEnumEntries());
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundFields());
        this.addTopLevelDeclarations((Collection<? extends IrSymbol>)symbolTable.getUnboundSimpleFunctions());
    }

    private final void markOverriddenFunctionsForUnboundFunctionsReferenced(@NotNull SymbolTable $receiver) {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)$receiver.getUnboundSimpleFunctions();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        IrSimpleFunctionSymbol[] irSimpleFunctionSymbolArray = thisCollection$iv.toArray(new IrSimpleFunctionSymbol[0]);
        if (irSimpleFunctionSymbolArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (IrSimpleFunctionSymbol unboundFunction : irSimpleFunctionSymbolArray) {
            this.markOverriddenFunctionsReferenced($receiver, (FunctionDescriptor)unboundFunction.getDescriptor(), new HashSet());
        }
    }

    private final void markOverriddenFunctionsReferenced(@NotNull SymbolTable $receiver, FunctionDescriptor function2, Set<FunctionDescriptor> visitedFunctions) {
        for (FunctionDescriptor functionDescriptor : function2.getOverriddenDescriptors()) {
            if (visitedFunctions.contains(functionDescriptor)) continue;
            FunctionDescriptor functionDescriptor2 = functionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"overridden");
            visitedFunctions.add(functionDescriptor2);
            FunctionDescriptor functionDescriptor3 = functionDescriptor.getOriginal();
            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"overridden.original");
            $receiver.referenceFunction(functionDescriptor3);
            this.markOverriddenFunctionsReferenced($receiver, functionDescriptor, visitedFunctions);
        }
    }

    private final void markSuperClassesForUnboundClassesReferenced(@NotNull SymbolTable $receiver) {
        Collection $receiver$iv;
        Collection collection = $receiver$iv = (Collection)$receiver.getUnboundClasses();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        IrClassSymbol[] irClassSymbolArray = thisCollection$iv.toArray(new IrClassSymbol[0]);
        if (irClassSymbolArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (IrClassSymbol unboundClass : irClassSymbolArray) {
            for (ClassifierDescriptor superClassifier : DescriptorUtilsKt.getAllSuperClassifiers(unboundClass.getDescriptor())) {
                if (!(superClassifier instanceof ClassDescriptor)) continue;
                $receiver.referenceClass((ClassDescriptor)superClassifier);
            }
        }
    }

    private final void addTopLevelDeclarations(@NotNull Collection<? extends IrSymbol> $receiver) {
        Iterable $receiver$iv = $receiver;
        for (Object element$iv : $receiver$iv) {
            DeclarationDescriptor declarationDescriptor;
            IrSymbol it = (IrSymbol)element$iv;
            if (this.getTopLevelDeclaration(it.getDescriptor()) == null) continue;
            DeclarationDescriptor it2 = declarationDescriptor;
            this.addTopLevelDescriptor(it2);
        }
    }

    private final DeclarationDescriptor getTopLevelDeclaration(DeclarationDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        DeclarationDescriptor declarationDescriptor2 = containingDeclaration;
        if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
            declarationDescriptor = descriptor2;
        } else if (declarationDescriptor2 instanceof ClassDescriptor) {
            declarationDescriptor = this.getTopLevelDeclaration(containingDeclaration);
        } else {
            if (!(descriptor2 instanceof PropertyAccessorDescriptor) || ((PropertyAccessorDescriptor)descriptor2).getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED || !(containingDeclaration instanceof ModuleDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)("Package or class expected: " + containingDeclaration + "; for " + descriptor2)));
            }
            declarationDescriptor = null;
        }
        return declarationDescriptor;
    }

    private final void addTopLevelDescriptor(DeclarationDescriptor descriptor2) {
        Object object;
        Object object2;
        Set answer$iv;
        PackageFragmentDescriptor packageFragmentDescriptor = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class);
        if (packageFragmentDescriptor == null) {
            Intrinsics.throwNpe();
        }
        PackageFragmentDescriptor packageFragmentDescriptor2 = packageFragmentDescriptor;
        ModuleDescriptor moduleDescriptor = packageFragmentDescriptor2.getContainingDeclaration();
        this.modulesForDependencyDescriptors.add(moduleDescriptor);
        Map $receiver$iv = this.packageFragmentsForDependencyDescriptors;
        Object value$iv = $receiver$iv.get(moduleDescriptor);
        if (value$iv == null) {
            answer$iv = new LinkedHashSet();
            $receiver$iv.put(moduleDescriptor, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        ((Set)object2).add(packageFragmentDescriptor2);
        $receiver$iv = this.topLevelDescriptors;
        value$iv = $receiver$iv.get(packageFragmentDescriptor2);
        if (value$iv == null) {
            answer$iv = new LinkedHashSet();
            $receiver$iv.put(packageFragmentDescriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((Set)object).add(descriptor2);
    }
}

