package documentdb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// GraphResourcesClient is the client for the GraphResources methods of the Documentdb service.
type GraphResourcesClient struct {
	BaseClient
}

// NewGraphResourcesClient creates an instance of the GraphResourcesClient client.
func NewGraphResourcesClient(subscriptionID string) GraphResourcesClient {
	return NewGraphResourcesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewGraphResourcesClientWithBaseURI creates an instance of the GraphResourcesClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewGraphResourcesClientWithBaseURI(baseURI string, subscriptionID string) GraphResourcesClient {
	return GraphResourcesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateUpdateGraph create or update an Azure Cosmos DB Graph.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// graphName - cosmos DB graph resource name.
// createUpdateGraphParameters - the parameters to provide for the current graph.
func (client GraphResourcesClient) CreateUpdateGraph(ctx context.Context, resourceGroupName string, accountName string, graphName string, createUpdateGraphParameters GraphResourceCreateUpdateParameters) (result GraphResourcesCreateUpdateGraphFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GraphResourcesClient.CreateUpdateGraph")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}},
		{TargetValue: createUpdateGraphParameters,
			Constraints: []validation.Constraint{{Target: "createUpdateGraphParameters.GraphResourceCreateUpdateProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "createUpdateGraphParameters.GraphResourceCreateUpdateProperties.Resource", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "createUpdateGraphParameters.GraphResourceCreateUpdateProperties.Resource.ID", Name: validation.Null, Rule: true, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("documentdb.GraphResourcesClient", "CreateUpdateGraph", err.Error())
	}

	req, err := client.CreateUpdateGraphPreparer(ctx, resourceGroupName, accountName, graphName, createUpdateGraphParameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "CreateUpdateGraph", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateUpdateGraphSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "CreateUpdateGraph", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateUpdateGraphPreparer prepares the CreateUpdateGraph request.
func (client GraphResourcesClient) CreateUpdateGraphPreparer(ctx context.Context, resourceGroupName string, accountName string, graphName string, createUpdateGraphParameters GraphResourceCreateUpdateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"graphName":         autorest.Encode("path", graphName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs/{graphName}", pathParameters),
		autorest.WithJSON(createUpdateGraphParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUpdateGraphSender sends the CreateUpdateGraph request. The method will close the
// http.Response Body if it receives an error.
func (client GraphResourcesClient) CreateUpdateGraphSender(req *http.Request) (future GraphResourcesCreateUpdateGraphFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateUpdateGraphResponder handles the response to the CreateUpdateGraph request. The method always
// closes the http.Response Body.
func (client GraphResourcesClient) CreateUpdateGraphResponder(resp *http.Response) (result GraphResourceGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteGraphResource deletes an existing Azure Cosmos DB Graph Resource.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// graphName - cosmos DB graph resource name.
func (client GraphResourcesClient) DeleteGraphResource(ctx context.Context, resourceGroupName string, accountName string, graphName string) (result GraphResourcesDeleteGraphResourceFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GraphResourcesClient.DeleteGraphResource")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.GraphResourcesClient", "DeleteGraphResource", err.Error())
	}

	req, err := client.DeleteGraphResourcePreparer(ctx, resourceGroupName, accountName, graphName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "DeleteGraphResource", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteGraphResourceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "DeleteGraphResource", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeleteGraphResourcePreparer prepares the DeleteGraphResource request.
func (client GraphResourcesClient) DeleteGraphResourcePreparer(ctx context.Context, resourceGroupName string, accountName string, graphName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"graphName":         autorest.Encode("path", graphName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs/{graphName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteGraphResourceSender sends the DeleteGraphResource request. The method will close the
// http.Response Body if it receives an error.
func (client GraphResourcesClient) DeleteGraphResourceSender(req *http.Request) (future GraphResourcesDeleteGraphResourceFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteGraphResourceResponder handles the response to the DeleteGraphResource request. The method always
// closes the http.Response Body.
func (client GraphResourcesClient) DeleteGraphResourceResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetGraph gets the Graph resource under an existing Azure Cosmos DB database account with the provided name.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
// graphName - cosmos DB graph resource name.
func (client GraphResourcesClient) GetGraph(ctx context.Context, resourceGroupName string, accountName string, graphName string) (result GraphResourceGetResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GraphResourcesClient.GetGraph")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.GraphResourcesClient", "GetGraph", err.Error())
	}

	req, err := client.GetGraphPreparer(ctx, resourceGroupName, accountName, graphName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "GetGraph", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetGraphSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "GetGraph", resp, "Failure sending request")
		return
	}

	result, err = client.GetGraphResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "GetGraph", resp, "Failure responding to request")
		return
	}

	return
}

// GetGraphPreparer prepares the GetGraph request.
func (client GraphResourcesClient) GetGraphPreparer(ctx context.Context, resourceGroupName string, accountName string, graphName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"graphName":         autorest.Encode("path", graphName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs/{graphName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetGraphSender sends the GetGraph request. The method will close the
// http.Response Body if it receives an error.
func (client GraphResourcesClient) GetGraphSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetGraphResponder handles the response to the GetGraph request. The method always
// closes the http.Response Body.
func (client GraphResourcesClient) GetGraphResponder(resp *http.Response) (result GraphResourceGetResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListGraphs lists the graphs under an existing Azure Cosmos DB database account.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// accountName - cosmos DB database account name.
func (client GraphResourcesClient) ListGraphs(ctx context.Context, resourceGroupName string, accountName string) (result GraphResourcesListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GraphResourcesClient.ListGraphs")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[a-z0-9]+(-[a-z0-9]+)*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("documentdb.GraphResourcesClient", "ListGraphs", err.Error())
	}

	req, err := client.ListGraphsPreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "ListGraphs", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListGraphsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "ListGraphs", resp, "Failure sending request")
		return
	}

	result, err = client.ListGraphsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GraphResourcesClient", "ListGraphs", resp, "Failure responding to request")
		return
	}

	return
}

// ListGraphsPreparer prepares the ListGraphs request.
func (client GraphResourcesClient) ListGraphsPreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-15-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListGraphsSender sends the ListGraphs request. The method will close the
// http.Response Body if it receives an error.
func (client GraphResourcesClient) ListGraphsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListGraphsResponder handles the response to the ListGraphs request. The method always
// closes the http.Response Body.
func (client GraphResourcesClient) ListGraphsResponder(resp *http.Response) (result GraphResourcesListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
