/*
 * bindings.h
 *
 * Header for command string definitions (actually defined in commands.c) and
 * functions for dealing with key bindings.
 *
 * This file is part of the ckpass project.
 *
 * Copyright (C) 2009  Heath N. Caldwell <hncaldwell@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef BINDINGS_H
#define BINDINGS_H

/* Command strings. */
extern const char *C_OPEN;
extern const char *C_SAVE;
extern const char *C_ADD_GROUP;
extern const char *C_SELECT;
extern const char *C_EDIT;
extern const char *C_QUIT;
extern const char *C_ADD_ENTRY;
extern const char *C_GROUPS;
extern const char *C_REVEAL;
extern const char *C_PREV;
extern const char *C_NEXT;
extern const char *C_XCLIP;

struct binding {
	int key;
	char *command;
};

void add_binding(struct binding **set, int key, const char *command);
struct binding *new_binding_set();

#endif // BINDINGS_H

