
/*

    cpu.h - Header file for cpu functions
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/


*/

/* prevent multiple inclusion */
#ifndef _MP_CPU


#ifdef __cplusplus
extern "C" {
#endif


/* define header ID */
#define _MP_CPU

/* header definitions starts here */

  /* type of graph: histogram of graph */
#define CPUMON_HIST	0
#define CPUMON_GRAPH	1
  
struct cpu_monitor {
  int handler;			/* graphic area handler */
  int enable;			/* enabled flag */
  int update_dly;		/* update delay in 2/10 sec */
  int cpu_num;			/* what cpu? 0..N for cpuN, -1 for total */
  int vsize;			/* vertical size of graph */
  int mode;			/* 1 for graph, 0 for histogram */
  int smooth;			/* smooth factor for histogram mode */
  unsigned long user, nice, sys, idle;	  /* time slice usage */
  unsigned long prevu, prevn, prevs, previ;   /* previous usage */
  Pixmap p;			/* backing store pixmap */
  int xc,yc,wc,hc;		/* position amd size of graph */
  char user_color[30];		/* color for graph */
  char nice_color[30];
  char sys_color[30];
};

/* reads cpu status from /proc/stat */
void cpu_update(struct cpu_monitor *cpum);

/* set size for cpu graph */
int cpu_size(struct cpu_monitor *cpum);

/* draw cpu graph */
void cpu_draw(struct cpu_monitor *cpum);



#ifdef __cplusplus
}
#endif

#endif /* _MP_CPU */


