
/*

    seti.h - Header file for seti@home progress histogram
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/


*/

/* prevent multiple inclusion */
#ifndef _MP_SETI


#ifdef __cplusplus
extern "C" {
#endif


/* define header ID */
#define _MP_SETI

/* for PATH_MAX */
#ifndef _LIMITS_H
  #include <limits.h>
#endif

/* header definitions starts here */

struct seti_monitor
{
  int handler;			/* graphic area handler */
  int enable;			/* enabled flag */
  int update_dly;		/* update delay in 2/10 sec */
  int perc;			/* completed percent x1000, eg 24.6%=24600 */
  char setiwd[PATH_MAX];	/* path to seti@home state.sah file */
  char seti_color[30];			/* histogram color */
  int xf,yf,wf,hf;			/* gauge position */
};
  


/* reads seti@home status */
void seti_update(struct seti_monitor *setimon);

/* set size for histogram */
int seti_size(struct seti_monitor *setimon);

/* set paths */
int seti_setpath(struct seti_monitor *setimon);

/* draw histogram */
void seti_draw(struct seti_monitor *setimon);


#ifdef __cplusplus
}
#endif

#endif /* _MP_SETI */


