# ctxlogrus
`import "github.com/grpc-ecosystem/go-grpc-middleware/logging/logrus/ctxlogrus"`

* [Overview](#pkg-overview)
* [Imported Packages](#pkg-imports)
* [Index](#pkg-index)
* [Examples](#pkg-examples)

## <a name="pkg-overview">Overview</a>
`ctxlogrus` is a ctxlogger that is backed by logrus

It accepts a user-configured `logrus.Logger` that will be used for logging. The same `logrus.Logger` will
be populated into the `context.Context` passed into gRPC handler code.

You can use `ctx_logrus.Extract` to log into a request-scoped `logrus.Logger` instance in your handler code.

As `ctx_logrus.Extract` will iterate all tags on from `grpc_ctxtags` it is therefore expensive so it is advised that you
extract once at the start of the function from the context and reuse it for the remainder of the function (see examples).

Please see examples and tests for examples of use.

## <a name="pkg-imports">Imported Packages</a>

- [github.com/grpc-ecosystem/go-grpc-middleware/tags](./../../../tags)
- [github.com/sirupsen/logrus](https://godoc.org/github.com/sirupsen/logrus)
- [golang.org/x/net/context](https://godoc.org/golang.org/x/net/context)

## <a name="pkg-index">Index</a>
* [func AddFields(ctx context.Context, fields logrus.Fields)](#AddFields)
* [func Extract(ctx context.Context) \*logrus.Entry](#Extract)
* [func ToContext(ctx context.Context, entry \*logrus.Entry) context.Context](#ToContext)

#### <a name="pkg-examples">Examples</a>
* [Extract (Unary)](#example_Extract_unary)

#### <a name="pkg-files">Package files</a>
[context.go](./context.go) [doc.go](./doc.go) [noop.go](./noop.go) 

## <a name="AddFields">func</a> [AddFields](./context.go#L21)
``` go
func AddFields(ctx context.Context, fields logrus.Fields)
```
AddFields adds logrus fields to the logger.

## <a name="Extract">func</a> [Extract](./context.go#L35)
``` go
func Extract(ctx context.Context) *logrus.Entry
```
Extract takes the call-scoped logrus.Entry from ctx_logrus middleware.

If the ctx_logrus middleware wasn't used, a no-op `logrus.Entry` is returned. This makes it safe to
use regardless.

#### Example:

<details>
<summary>Click to expand code.</summary>

```go
package ctxlogrus_test

import (
    "github.com/grpc-ecosystem/go-grpc-middleware/logging/logrus/ctxlogrus"
    "github.com/grpc-ecosystem/go-grpc-middleware/tags"
    "github.com/sirupsen/logrus"
    "golang.org/x/net/context"
)

var logrusLogger *logrus.Logger

// Simple unary handler that adds custom fields to the requests's context. These will be used for all log statements.
func ExampleExtract_unary() {
    ctx := context.Background()
    // setting tags will be added to the logger as log fields
    grpc_ctxtags.Extract(ctx).Set("custom_tags.string", "something").Set("custom_tags.int", 1337)
    // Extract a single request-scoped logrus.Logger and log messages.
    l := ctxlogrus.Extract(ctx)
    l.Info("some ping")
    l.Info("another ping")
}
```

</details>

## <a name="ToContext">func</a> [ToContext](./context.go#L59)
``` go
func ToContext(ctx context.Context, entry *logrus.Entry) context.Context
```
ToContext adds the logrus.Entry to the context for extraction later.
Returning the new context that has been created.

- - -
Generated by [godoc2ghmd](https://github.com/GandalfUK/godoc2ghmd)