// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dialogflow/cx/v3/response_message.proto

package cx

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents a response message that can be returned by a conversational agent.
//
// Response messages are also used for output audio synthesis. The approach is
// as follows:
//
// * If at least one OutputAudioText response is present, then all
//   OutputAudioText responses are linearly concatenated, and the result is used
//   for output audio synthesis.
// * If the OutputAudioText responses are a mixture of text and SSML, then the
//   concatenated result is treated as SSML; otherwise, the result is treated as
//   either text or SSML as appropriate. The agent designer should ideally use
//   either text or SSML consistently throughout the bot design.
// * Otherwise, all Text responses are linearly concatenated, and the result is
//   used for output audio synthesis.
//
// This approach allows for more sophisticated user experience scenarios, where
// the text displayed to the user may differ from what is heard.
type ResponseMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The rich response message.
	//
	// Types that are assignable to Message:
	//	*ResponseMessage_Text_
	//	*ResponseMessage_Payload
	//	*ResponseMessage_ConversationSuccess_
	//	*ResponseMessage_OutputAudioText_
	//	*ResponseMessage_LiveAgentHandoff_
	//	*ResponseMessage_EndInteraction_
	//	*ResponseMessage_PlayAudio_
	//	*ResponseMessage_MixedAudio_
	//	*ResponseMessage_TelephonyTransferCall_
	Message isResponseMessage_Message `protobuf_oneof:"message"`
}

func (x *ResponseMessage) Reset() {
	*x = ResponseMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage) ProtoMessage() {}

func (x *ResponseMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage.ProtoReflect.Descriptor instead.
func (*ResponseMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0}
}

func (m *ResponseMessage) GetMessage() isResponseMessage_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *ResponseMessage) GetText() *ResponseMessage_Text {
	if x, ok := x.GetMessage().(*ResponseMessage_Text_); ok {
		return x.Text
	}
	return nil
}

func (x *ResponseMessage) GetPayload() *structpb.Struct {
	if x, ok := x.GetMessage().(*ResponseMessage_Payload); ok {
		return x.Payload
	}
	return nil
}

func (x *ResponseMessage) GetConversationSuccess() *ResponseMessage_ConversationSuccess {
	if x, ok := x.GetMessage().(*ResponseMessage_ConversationSuccess_); ok {
		return x.ConversationSuccess
	}
	return nil
}

func (x *ResponseMessage) GetOutputAudioText() *ResponseMessage_OutputAudioText {
	if x, ok := x.GetMessage().(*ResponseMessage_OutputAudioText_); ok {
		return x.OutputAudioText
	}
	return nil
}

func (x *ResponseMessage) GetLiveAgentHandoff() *ResponseMessage_LiveAgentHandoff {
	if x, ok := x.GetMessage().(*ResponseMessage_LiveAgentHandoff_); ok {
		return x.LiveAgentHandoff
	}
	return nil
}

func (x *ResponseMessage) GetEndInteraction() *ResponseMessage_EndInteraction {
	if x, ok := x.GetMessage().(*ResponseMessage_EndInteraction_); ok {
		return x.EndInteraction
	}
	return nil
}

func (x *ResponseMessage) GetPlayAudio() *ResponseMessage_PlayAudio {
	if x, ok := x.GetMessage().(*ResponseMessage_PlayAudio_); ok {
		return x.PlayAudio
	}
	return nil
}

func (x *ResponseMessage) GetMixedAudio() *ResponseMessage_MixedAudio {
	if x, ok := x.GetMessage().(*ResponseMessage_MixedAudio_); ok {
		return x.MixedAudio
	}
	return nil
}

func (x *ResponseMessage) GetTelephonyTransferCall() *ResponseMessage_TelephonyTransferCall {
	if x, ok := x.GetMessage().(*ResponseMessage_TelephonyTransferCall_); ok {
		return x.TelephonyTransferCall
	}
	return nil
}

type isResponseMessage_Message interface {
	isResponseMessage_Message()
}

type ResponseMessage_Text_ struct {
	// Returns a text response.
	Text *ResponseMessage_Text `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type ResponseMessage_Payload struct {
	// Returns a response containing a custom, platform-specific payload.
	Payload *structpb.Struct `protobuf:"bytes,2,opt,name=payload,proto3,oneof"`
}

type ResponseMessage_ConversationSuccess_ struct {
	// Indicates that the conversation succeeded.
	ConversationSuccess *ResponseMessage_ConversationSuccess `protobuf:"bytes,9,opt,name=conversation_success,json=conversationSuccess,proto3,oneof"`
}

type ResponseMessage_OutputAudioText_ struct {
	// A text or ssml response that is preferentially used for TTS output audio
	// synthesis, as described in the comment on the ResponseMessage message.
	OutputAudioText *ResponseMessage_OutputAudioText `protobuf:"bytes,8,opt,name=output_audio_text,json=outputAudioText,proto3,oneof"`
}

type ResponseMessage_LiveAgentHandoff_ struct {
	// Hands off conversation to a human agent.
	LiveAgentHandoff *ResponseMessage_LiveAgentHandoff `protobuf:"bytes,10,opt,name=live_agent_handoff,json=liveAgentHandoff,proto3,oneof"`
}

type ResponseMessage_EndInteraction_ struct {
	// Output only. A signal that indicates the interaction with the Dialogflow agent has
	// ended.
	// This message is generated by Dialogflow only when the conversation
	// reaches `END_SESSION` page. It is not supposed to be defined by the user.
	//
	// It's guaranteed that there is at most one such message in each response.
	EndInteraction *ResponseMessage_EndInteraction `protobuf:"bytes,11,opt,name=end_interaction,json=endInteraction,proto3,oneof"`
}

type ResponseMessage_PlayAudio_ struct {
	// Signal that the client should play an audio clip hosted at a
	// client-specific URI. Dialogflow uses this to construct
	// [mixed_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.mixed_audio]. However, Dialogflow itself
	// does not try to read or process the URI in any way.
	PlayAudio *ResponseMessage_PlayAudio `protobuf:"bytes,12,opt,name=play_audio,json=playAudio,proto3,oneof"`
}

type ResponseMessage_MixedAudio_ struct {
	// Output only. An audio response message composed of both the synthesized Dialogflow
	// agent responses and responses defined via
	// [play_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.play_audio].
	// This message is generated by Dialogflow only and not supposed to be
	// defined by the user.
	MixedAudio *ResponseMessage_MixedAudio `protobuf:"bytes,13,opt,name=mixed_audio,json=mixedAudio,proto3,oneof"`
}

type ResponseMessage_TelephonyTransferCall_ struct {
	// A signal that the client should transfer the phone call connected to
	// this agent to a third-party endpoint.
	TelephonyTransferCall *ResponseMessage_TelephonyTransferCall `protobuf:"bytes,18,opt,name=telephony_transfer_call,json=telephonyTransferCall,proto3,oneof"`
}

func (*ResponseMessage_Text_) isResponseMessage_Message() {}

func (*ResponseMessage_Payload) isResponseMessage_Message() {}

func (*ResponseMessage_ConversationSuccess_) isResponseMessage_Message() {}

func (*ResponseMessage_OutputAudioText_) isResponseMessage_Message() {}

func (*ResponseMessage_LiveAgentHandoff_) isResponseMessage_Message() {}

func (*ResponseMessage_EndInteraction_) isResponseMessage_Message() {}

func (*ResponseMessage_PlayAudio_) isResponseMessage_Message() {}

func (*ResponseMessage_MixedAudio_) isResponseMessage_Message() {}

func (*ResponseMessage_TelephonyTransferCall_) isResponseMessage_Message() {}

// The text response message.
type ResponseMessage_Text struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A collection of text responses.
	Text []string `protobuf:"bytes,1,rep,name=text,proto3" json:"text,omitempty"`
	// Output only. Whether the playback of this message can be interrupted by the end
	// user's speech and the client can then starts the next Dialogflow
	// request.
	AllowPlaybackInterruption bool `protobuf:"varint,2,opt,name=allow_playback_interruption,json=allowPlaybackInterruption,proto3" json:"allow_playback_interruption,omitempty"`
}

func (x *ResponseMessage_Text) Reset() {
	*x = ResponseMessage_Text{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_Text) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_Text) ProtoMessage() {}

func (x *ResponseMessage_Text) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_Text.ProtoReflect.Descriptor instead.
func (*ResponseMessage_Text) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ResponseMessage_Text) GetText() []string {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *ResponseMessage_Text) GetAllowPlaybackInterruption() bool {
	if x != nil {
		return x.AllowPlaybackInterruption
	}
	return false
}

// Indicates that the conversation should be handed off to a live agent.
//
// Dialogflow only uses this to determine which conversations were handed off
// to a human agent for measurement purposes. What else to do with this signal
// is up to you and your handoff procedures.
//
// You may set this, for example:
// * In the [entry_fulfillment][google.cloud.dialogflow.cx.v3.Page.entry_fulfillment] of a [Page][google.cloud.dialogflow.cx.v3.Page] if
//   entering the page indicates something went extremely wrong in the
//   conversation.
// * In a webhook response when you determine that the customer issue can only
//   be handled by a human.
type ResponseMessage_LiveAgentHandoff struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom metadata for your handoff procedure. Dialogflow doesn't impose
	// any structure on this.
	Metadata *structpb.Struct `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ResponseMessage_LiveAgentHandoff) Reset() {
	*x = ResponseMessage_LiveAgentHandoff{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_LiveAgentHandoff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_LiveAgentHandoff) ProtoMessage() {}

func (x *ResponseMessage_LiveAgentHandoff) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_LiveAgentHandoff.ProtoReflect.Descriptor instead.
func (*ResponseMessage_LiveAgentHandoff) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ResponseMessage_LiveAgentHandoff) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Indicates that the conversation succeeded, i.e., the bot handled the issue
// that the customer talked to it about.
//
// Dialogflow only uses this to determine which conversations should be
// counted as successful and doesn't process the metadata in this message in
// any way. Note that Dialogflow also considers conversations that get to the
// conversation end page as successful even if they don't return
// [ConversationSuccess][google.cloud.dialogflow.cx.v3.ResponseMessage.ConversationSuccess].
//
// You may set this, for example:
// * In the [entry_fulfillment][google.cloud.dialogflow.cx.v3.Page.entry_fulfillment] of a [Page][google.cloud.dialogflow.cx.v3.Page] if
//   entering the page indicates that the conversation succeeded.
// * In a webhook response when you determine that you handled the customer
//   issue.
type ResponseMessage_ConversationSuccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom metadata. Dialogflow doesn't impose any structure on this.
	Metadata *structpb.Struct `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ResponseMessage_ConversationSuccess) Reset() {
	*x = ResponseMessage_ConversationSuccess{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_ConversationSuccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_ConversationSuccess) ProtoMessage() {}

func (x *ResponseMessage_ConversationSuccess) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_ConversationSuccess.ProtoReflect.Descriptor instead.
func (*ResponseMessage_ConversationSuccess) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 2}
}

func (x *ResponseMessage_ConversationSuccess) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// A text or ssml response that is preferentially used for TTS output audio
// synthesis, as described in the comment on the ResponseMessage message.
type ResponseMessage_OutputAudioText struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source, which is either plain text or SSML.
	//
	// Types that are assignable to Source:
	//	*ResponseMessage_OutputAudioText_Text
	//	*ResponseMessage_OutputAudioText_Ssml
	Source isResponseMessage_OutputAudioText_Source `protobuf_oneof:"source"`
	// Output only. Whether the playback of this message can be interrupted by the end
	// user's speech and the client can then starts the next Dialogflow
	// request.
	AllowPlaybackInterruption bool `protobuf:"varint,3,opt,name=allow_playback_interruption,json=allowPlaybackInterruption,proto3" json:"allow_playback_interruption,omitempty"`
}

func (x *ResponseMessage_OutputAudioText) Reset() {
	*x = ResponseMessage_OutputAudioText{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_OutputAudioText) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_OutputAudioText) ProtoMessage() {}

func (x *ResponseMessage_OutputAudioText) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_OutputAudioText.ProtoReflect.Descriptor instead.
func (*ResponseMessage_OutputAudioText) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 3}
}

func (m *ResponseMessage_OutputAudioText) GetSource() isResponseMessage_OutputAudioText_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ResponseMessage_OutputAudioText) GetText() string {
	if x, ok := x.GetSource().(*ResponseMessage_OutputAudioText_Text); ok {
		return x.Text
	}
	return ""
}

func (x *ResponseMessage_OutputAudioText) GetSsml() string {
	if x, ok := x.GetSource().(*ResponseMessage_OutputAudioText_Ssml); ok {
		return x.Ssml
	}
	return ""
}

func (x *ResponseMessage_OutputAudioText) GetAllowPlaybackInterruption() bool {
	if x != nil {
		return x.AllowPlaybackInterruption
	}
	return false
}

type isResponseMessage_OutputAudioText_Source interface {
	isResponseMessage_OutputAudioText_Source()
}

type ResponseMessage_OutputAudioText_Text struct {
	// The raw text to be synthesized.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type ResponseMessage_OutputAudioText_Ssml struct {
	// The SSML text to be synthesized. For more information, see
	// [SSML](/speech/text-to-speech/docs/ssml).
	Ssml string `protobuf:"bytes,2,opt,name=ssml,proto3,oneof"`
}

func (*ResponseMessage_OutputAudioText_Text) isResponseMessage_OutputAudioText_Source() {}

func (*ResponseMessage_OutputAudioText_Ssml) isResponseMessage_OutputAudioText_Source() {}

// Indicates that interaction with the Dialogflow agent has ended.
// This message is generated by Dialogflow only and not supposed to be
// defined by the user.
type ResponseMessage_EndInteraction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResponseMessage_EndInteraction) Reset() {
	*x = ResponseMessage_EndInteraction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_EndInteraction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_EndInteraction) ProtoMessage() {}

func (x *ResponseMessage_EndInteraction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_EndInteraction.ProtoReflect.Descriptor instead.
func (*ResponseMessage_EndInteraction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 4}
}

// Specifies an audio clip to be played by the client as part of the response.
type ResponseMessage_PlayAudio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URI of the audio clip. Dialogflow does not impose any validation on this
	// value. It is specific to the client that reads it.
	AudioUri string `protobuf:"bytes,1,opt,name=audio_uri,json=audioUri,proto3" json:"audio_uri,omitempty"`
	// Output only. Whether the playback of this message can be interrupted by the end
	// user's speech and the client can then starts the next Dialogflow
	// request.
	AllowPlaybackInterruption bool `protobuf:"varint,2,opt,name=allow_playback_interruption,json=allowPlaybackInterruption,proto3" json:"allow_playback_interruption,omitempty"`
}

func (x *ResponseMessage_PlayAudio) Reset() {
	*x = ResponseMessage_PlayAudio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_PlayAudio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_PlayAudio) ProtoMessage() {}

func (x *ResponseMessage_PlayAudio) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_PlayAudio.ProtoReflect.Descriptor instead.
func (*ResponseMessage_PlayAudio) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 5}
}

func (x *ResponseMessage_PlayAudio) GetAudioUri() string {
	if x != nil {
		return x.AudioUri
	}
	return ""
}

func (x *ResponseMessage_PlayAudio) GetAllowPlaybackInterruption() bool {
	if x != nil {
		return x.AllowPlaybackInterruption
	}
	return false
}

// Represents an audio message that is composed of both segments
// synthesized from the Dialogflow agent prompts and ones hosted externally
// at the specified URIs.
// The external URIs are specified via
// [play_audio][google.cloud.dialogflow.cx.v3.ResponseMessage.play_audio].
// This message is generated by Dialogflow only and not supposed to be
// defined by the user.
type ResponseMessage_MixedAudio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Segments this audio response is composed of.
	Segments []*ResponseMessage_MixedAudio_Segment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
}

func (x *ResponseMessage_MixedAudio) Reset() {
	*x = ResponseMessage_MixedAudio{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_MixedAudio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_MixedAudio) ProtoMessage() {}

func (x *ResponseMessage_MixedAudio) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_MixedAudio.ProtoReflect.Descriptor instead.
func (*ResponseMessage_MixedAudio) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 6}
}

func (x *ResponseMessage_MixedAudio) GetSegments() []*ResponseMessage_MixedAudio_Segment {
	if x != nil {
		return x.Segments
	}
	return nil
}

// Represents the signal that telles the client to transfer the phone call
// connected to the agent to a third-party endpoint.
type ResponseMessage_TelephonyTransferCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Endpoint to transfer the call to.
	//
	// Types that are assignable to Endpoint:
	//	*ResponseMessage_TelephonyTransferCall_PhoneNumber
	Endpoint isResponseMessage_TelephonyTransferCall_Endpoint `protobuf_oneof:"endpoint"`
}

func (x *ResponseMessage_TelephonyTransferCall) Reset() {
	*x = ResponseMessage_TelephonyTransferCall{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_TelephonyTransferCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_TelephonyTransferCall) ProtoMessage() {}

func (x *ResponseMessage_TelephonyTransferCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_TelephonyTransferCall.ProtoReflect.Descriptor instead.
func (*ResponseMessage_TelephonyTransferCall) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 7}
}

func (m *ResponseMessage_TelephonyTransferCall) GetEndpoint() isResponseMessage_TelephonyTransferCall_Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (x *ResponseMessage_TelephonyTransferCall) GetPhoneNumber() string {
	if x, ok := x.GetEndpoint().(*ResponseMessage_TelephonyTransferCall_PhoneNumber); ok {
		return x.PhoneNumber
	}
	return ""
}

type isResponseMessage_TelephonyTransferCall_Endpoint interface {
	isResponseMessage_TelephonyTransferCall_Endpoint()
}

type ResponseMessage_TelephonyTransferCall_PhoneNumber struct {
	// Transfer the call to a phone number
	// in [E.164 format](https://en.wikipedia.org/wiki/E.164).
	PhoneNumber string `protobuf:"bytes,1,opt,name=phone_number,json=phoneNumber,proto3,oneof"`
}

func (*ResponseMessage_TelephonyTransferCall_PhoneNumber) isResponseMessage_TelephonyTransferCall_Endpoint() {
}

// Represents one segment of audio.
type ResponseMessage_MixedAudio_Segment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of the segment.
	//
	// Types that are assignable to Content:
	//	*ResponseMessage_MixedAudio_Segment_Audio
	//	*ResponseMessage_MixedAudio_Segment_Uri
	Content isResponseMessage_MixedAudio_Segment_Content `protobuf_oneof:"content"`
	// Output only. Whether the playback of this segment can be interrupted by the end
	// user's speech and the client should then start the next Dialogflow
	// request.
	AllowPlaybackInterruption bool `protobuf:"varint,3,opt,name=allow_playback_interruption,json=allowPlaybackInterruption,proto3" json:"allow_playback_interruption,omitempty"`
}

func (x *ResponseMessage_MixedAudio_Segment) Reset() {
	*x = ResponseMessage_MixedAudio_Segment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResponseMessage_MixedAudio_Segment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_MixedAudio_Segment) ProtoMessage() {}

func (x *ResponseMessage_MixedAudio_Segment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_MixedAudio_Segment.ProtoReflect.Descriptor instead.
func (*ResponseMessage_MixedAudio_Segment) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP(), []int{0, 6, 0}
}

func (m *ResponseMessage_MixedAudio_Segment) GetContent() isResponseMessage_MixedAudio_Segment_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *ResponseMessage_MixedAudio_Segment) GetAudio() []byte {
	if x, ok := x.GetContent().(*ResponseMessage_MixedAudio_Segment_Audio); ok {
		return x.Audio
	}
	return nil
}

func (x *ResponseMessage_MixedAudio_Segment) GetUri() string {
	if x, ok := x.GetContent().(*ResponseMessage_MixedAudio_Segment_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *ResponseMessage_MixedAudio_Segment) GetAllowPlaybackInterruption() bool {
	if x != nil {
		return x.AllowPlaybackInterruption
	}
	return false
}

type isResponseMessage_MixedAudio_Segment_Content interface {
	isResponseMessage_MixedAudio_Segment_Content()
}

type ResponseMessage_MixedAudio_Segment_Audio struct {
	// Raw audio synthesized from the Dialogflow agent's response using
	// the output config specified in the request.
	Audio []byte `protobuf:"bytes,1,opt,name=audio,proto3,oneof"`
}

type ResponseMessage_MixedAudio_Segment_Uri struct {
	// Client-specific URI that points to an audio clip accessible to the
	// client. Dialogflow does not impose any validation on it.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3,oneof"`
}

func (*ResponseMessage_MixedAudio_Segment_Audio) isResponseMessage_MixedAudio_Segment_Content() {}

func (*ResponseMessage_MixedAudio_Segment_Uri) isResponseMessage_MixedAudio_Segment_Content() {}

var File_google_cloud_dialogflow_cx_v3_response_message_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf1, 0x0d, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x49, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x48, 0x00, 0x52, 0x04, 0x74,
	0x65, 0x78, 0x74, 0x12, 0x33, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52,
	0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x77, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x13, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x6c, 0x0a, 0x11, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x65, 0x78, 0x74, 0x48, 0x00, 0x52, 0x0f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x65, 0x78, 0x74, 0x12,
	0x6f, 0x0a, 0x12, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61,
	0x6e, 0x64, 0x6f, 0x66, 0x66, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x69, 0x76, 0x65,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x48, 0x00, 0x52, 0x10,
	0x6c, 0x69, 0x76, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66,
	0x12, 0x6d, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x45, 0x6e, 0x64, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x0e, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x59, 0x0a, 0x0a, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x48, 0x00, 0x52,
	0x09, 0x70, 0x6c, 0x61, 0x79, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x61, 0x0a, 0x0b, 0x6d, 0x69,
	0x78, 0x65, 0x64, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x4d, 0x69, 0x78, 0x65, 0x64, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x0a, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x7e, 0x0a,
	0x17, 0x74, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54,
	0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x43, 0x61, 0x6c, 0x6c, 0x48, 0x00, 0x52, 0x15, 0x74, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e,
	0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x61, 0x6c, 0x6c, 0x1a, 0x64, 0x0a,
	0x04, 0x54, 0x65, 0x78, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x43,
	0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x50,
	0x6c, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x47, 0x0a, 0x10, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x4a, 0x0a, 0x13,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x8c, 0x01, 0x0a, 0x0f, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x65, 0x78, 0x74, 0x12, 0x14, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x73, 0x73, 0x6d, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x04, 0x73, 0x73, 0x6d, 0x6c, 0x12, 0x43, 0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x61, 0x63,
	0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x10, 0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x72, 0x0a, 0x09, 0x50, 0x6c, 0x61,
	0x79, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x20, 0x0a, 0x09, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x55, 0x72, 0x69, 0x12, 0x43, 0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x61, 0x63,
	0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xf3, 0x01,
	0x0a, 0x0a, 0x4d, 0x69, 0x78, 0x65, 0x64, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x5d, 0x0a, 0x08,
	0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d,
	0x69, 0x78, 0x65, 0x64, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x85, 0x01, 0x0a, 0x07,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x12,
	0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x12, 0x43, 0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x1a, 0x48, 0x0a, 0x15, 0x54, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x23, 0x0a, 0x0c,
	0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x42, 0x0a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x09, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0xc8, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x42, 0x14,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63,
	0x78, 0x2f, 0x76, 0x33, 0x3b, 0x63, 0x78, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa,
	0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0xea,
	0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a,
	0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_dialogflow_cx_v3_response_message_proto_goTypes = []interface{}{
	(*ResponseMessage)(nil),                       // 0: google.cloud.dialogflow.cx.v3.ResponseMessage
	(*ResponseMessage_Text)(nil),                  // 1: google.cloud.dialogflow.cx.v3.ResponseMessage.Text
	(*ResponseMessage_LiveAgentHandoff)(nil),      // 2: google.cloud.dialogflow.cx.v3.ResponseMessage.LiveAgentHandoff
	(*ResponseMessage_ConversationSuccess)(nil),   // 3: google.cloud.dialogflow.cx.v3.ResponseMessage.ConversationSuccess
	(*ResponseMessage_OutputAudioText)(nil),       // 4: google.cloud.dialogflow.cx.v3.ResponseMessage.OutputAudioText
	(*ResponseMessage_EndInteraction)(nil),        // 5: google.cloud.dialogflow.cx.v3.ResponseMessage.EndInteraction
	(*ResponseMessage_PlayAudio)(nil),             // 6: google.cloud.dialogflow.cx.v3.ResponseMessage.PlayAudio
	(*ResponseMessage_MixedAudio)(nil),            // 7: google.cloud.dialogflow.cx.v3.ResponseMessage.MixedAudio
	(*ResponseMessage_TelephonyTransferCall)(nil), // 8: google.cloud.dialogflow.cx.v3.ResponseMessage.TelephonyTransferCall
	(*ResponseMessage_MixedAudio_Segment)(nil),    // 9: google.cloud.dialogflow.cx.v3.ResponseMessage.MixedAudio.Segment
	(*structpb.Struct)(nil),                       // 10: google.protobuf.Struct
}
var file_google_cloud_dialogflow_cx_v3_response_message_proto_depIdxs = []int32{
	1,  // 0: google.cloud.dialogflow.cx.v3.ResponseMessage.text:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.Text
	10, // 1: google.cloud.dialogflow.cx.v3.ResponseMessage.payload:type_name -> google.protobuf.Struct
	3,  // 2: google.cloud.dialogflow.cx.v3.ResponseMessage.conversation_success:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.ConversationSuccess
	4,  // 3: google.cloud.dialogflow.cx.v3.ResponseMessage.output_audio_text:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.OutputAudioText
	2,  // 4: google.cloud.dialogflow.cx.v3.ResponseMessage.live_agent_handoff:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.LiveAgentHandoff
	5,  // 5: google.cloud.dialogflow.cx.v3.ResponseMessage.end_interaction:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.EndInteraction
	6,  // 6: google.cloud.dialogflow.cx.v3.ResponseMessage.play_audio:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.PlayAudio
	7,  // 7: google.cloud.dialogflow.cx.v3.ResponseMessage.mixed_audio:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.MixedAudio
	8,  // 8: google.cloud.dialogflow.cx.v3.ResponseMessage.telephony_transfer_call:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.TelephonyTransferCall
	10, // 9: google.cloud.dialogflow.cx.v3.ResponseMessage.LiveAgentHandoff.metadata:type_name -> google.protobuf.Struct
	10, // 10: google.cloud.dialogflow.cx.v3.ResponseMessage.ConversationSuccess.metadata:type_name -> google.protobuf.Struct
	9,  // 11: google.cloud.dialogflow.cx.v3.ResponseMessage.MixedAudio.segments:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage.MixedAudio.Segment
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_response_message_proto_init() }
func file_google_cloud_dialogflow_cx_v3_response_message_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_response_message_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_Text); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_LiveAgentHandoff); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_ConversationSuccess); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_OutputAudioText); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_EndInteraction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_PlayAudio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_MixedAudio); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_TelephonyTransferCall); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResponseMessage_MixedAudio_Segment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ResponseMessage_Text_)(nil),
		(*ResponseMessage_Payload)(nil),
		(*ResponseMessage_ConversationSuccess_)(nil),
		(*ResponseMessage_OutputAudioText_)(nil),
		(*ResponseMessage_LiveAgentHandoff_)(nil),
		(*ResponseMessage_EndInteraction_)(nil),
		(*ResponseMessage_PlayAudio_)(nil),
		(*ResponseMessage_MixedAudio_)(nil),
		(*ResponseMessage_TelephonyTransferCall_)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ResponseMessage_OutputAudioText_Text)(nil),
		(*ResponseMessage_OutputAudioText_Ssml)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*ResponseMessage_TelephonyTransferCall_PhoneNumber)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*ResponseMessage_MixedAudio_Segment_Audio)(nil),
		(*ResponseMessage_MixedAudio_Segment_Uri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_response_message_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_response_message_proto_depIdxs,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_response_message_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_response_message_proto = out.File
	file_google_cloud_dialogflow_cx_v3_response_message_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_response_message_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_response_message_proto_depIdxs = nil
}
