// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto

package recaptchaenterprise

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum that represents the types of annotations.
type AnnotateAssessmentRequest_Annotation int32

const (
	// Default unspecified type.
	AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED AnnotateAssessmentRequest_Annotation = 0
	// Provides information that the event turned out to be legitimate.
	AnnotateAssessmentRequest_LEGITIMATE AnnotateAssessmentRequest_Annotation = 1
	// Provides information that the event turned out to be fraudulent.
	AnnotateAssessmentRequest_FRAUDULENT AnnotateAssessmentRequest_Annotation = 2
	// Provides information that the event was related to a login event in which
	// the user typed the correct password. Deprecated, prefer indicating
	// CORRECT_PASSWORD through the reasons field instead.
	//
	// Deprecated: Do not use.
	AnnotateAssessmentRequest_PASSWORD_CORRECT AnnotateAssessmentRequest_Annotation = 3
	// Provides information that the event was related to a login event in which
	// the user typed the incorrect password. Deprecated, prefer indicating
	// INCORRECT_PASSWORD through the reasons field instead.
	//
	// Deprecated: Do not use.
	AnnotateAssessmentRequest_PASSWORD_INCORRECT AnnotateAssessmentRequest_Annotation = 4
)

// Enum value maps for AnnotateAssessmentRequest_Annotation.
var (
	AnnotateAssessmentRequest_Annotation_name = map[int32]string{
		0: "ANNOTATION_UNSPECIFIED",
		1: "LEGITIMATE",
		2: "FRAUDULENT",
		3: "PASSWORD_CORRECT",
		4: "PASSWORD_INCORRECT",
	}
	AnnotateAssessmentRequest_Annotation_value = map[string]int32{
		"ANNOTATION_UNSPECIFIED": 0,
		"LEGITIMATE":             1,
		"FRAUDULENT":             2,
		"PASSWORD_CORRECT":       3,
		"PASSWORD_INCORRECT":     4,
	}
)

func (x AnnotateAssessmentRequest_Annotation) Enum() *AnnotateAssessmentRequest_Annotation {
	p := new(AnnotateAssessmentRequest_Annotation)
	*p = x
	return p
}

func (x AnnotateAssessmentRequest_Annotation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotateAssessmentRequest_Annotation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[0].Descriptor()
}

func (AnnotateAssessmentRequest_Annotation) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[0]
}

func (x AnnotateAssessmentRequest_Annotation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotateAssessmentRequest_Annotation.Descriptor instead.
func (AnnotateAssessmentRequest_Annotation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{1, 0}
}

// Enum that represents potential reasons for annotating an assessment.
type AnnotateAssessmentRequest_Reason int32

const (
	// Default unspecified reason.
	AnnotateAssessmentRequest_REASON_UNSPECIFIED AnnotateAssessmentRequest_Reason = 0
	// Indicates a chargeback issued for the transaction with no other details.
	// When possible, specify the type by using CHARGEBACK_FRAUD or
	// CHARGEBACK_DISPUTE instead.
	AnnotateAssessmentRequest_CHARGEBACK AnnotateAssessmentRequest_Reason = 1
	// Indicates a chargeback related to an alleged unauthorized transaction
	// from the cardholder's perspective (for example, the card number was
	// stolen).
	AnnotateAssessmentRequest_CHARGEBACK_FRAUD AnnotateAssessmentRequest_Reason = 8
	// Indicates a chargeback related to the cardholder having provided their
	// card details but allegedly not being satisfied with the purchase
	// (for example, misrepresentation, attempted cancellation).
	AnnotateAssessmentRequest_CHARGEBACK_DISPUTE AnnotateAssessmentRequest_Reason = 9
	// Indicates the transaction associated with the assessment is suspected of
	// being fraudulent based on the payment method, billing details, shipping
	// address or other transaction information.
	AnnotateAssessmentRequest_PAYMENT_HEURISTICS AnnotateAssessmentRequest_Reason = 2
	// Indicates that the user was served a 2FA challenge. An old assessment
	// with `ENUM_VALUES.INITIATED_TWO_FACTOR` reason that has not been
	// overwritten with `PASSED_TWO_FACTOR` is treated as an abandoned 2FA flow.
	// This is equivalent to `FAILED_TWO_FACTOR`.
	AnnotateAssessmentRequest_INITIATED_TWO_FACTOR AnnotateAssessmentRequest_Reason = 7
	// Indicates that the user passed a 2FA challenge.
	AnnotateAssessmentRequest_PASSED_TWO_FACTOR AnnotateAssessmentRequest_Reason = 3
	// Indicates that the user failed a 2FA challenge.
	AnnotateAssessmentRequest_FAILED_TWO_FACTOR AnnotateAssessmentRequest_Reason = 4
	// Indicates the user provided the correct password.
	AnnotateAssessmentRequest_CORRECT_PASSWORD AnnotateAssessmentRequest_Reason = 5
	// Indicates the user provided an incorrect password.
	AnnotateAssessmentRequest_INCORRECT_PASSWORD AnnotateAssessmentRequest_Reason = 6
)

// Enum value maps for AnnotateAssessmentRequest_Reason.
var (
	AnnotateAssessmentRequest_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "CHARGEBACK",
		8: "CHARGEBACK_FRAUD",
		9: "CHARGEBACK_DISPUTE",
		2: "PAYMENT_HEURISTICS",
		7: "INITIATED_TWO_FACTOR",
		3: "PASSED_TWO_FACTOR",
		4: "FAILED_TWO_FACTOR",
		5: "CORRECT_PASSWORD",
		6: "INCORRECT_PASSWORD",
	}
	AnnotateAssessmentRequest_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":   0,
		"CHARGEBACK":           1,
		"CHARGEBACK_FRAUD":     8,
		"CHARGEBACK_DISPUTE":   9,
		"PAYMENT_HEURISTICS":   2,
		"INITIATED_TWO_FACTOR": 7,
		"PASSED_TWO_FACTOR":    3,
		"FAILED_TWO_FACTOR":    4,
		"CORRECT_PASSWORD":     5,
		"INCORRECT_PASSWORD":   6,
	}
)

func (x AnnotateAssessmentRequest_Reason) Enum() *AnnotateAssessmentRequest_Reason {
	p := new(AnnotateAssessmentRequest_Reason)
	*p = x
	return p
}

func (x AnnotateAssessmentRequest_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotateAssessmentRequest_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[1].Descriptor()
}

func (AnnotateAssessmentRequest_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[1]
}

func (x AnnotateAssessmentRequest_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotateAssessmentRequest_Reason.Descriptor instead.
func (AnnotateAssessmentRequest_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{1, 1}
}

// Reasons contributing to the risk analysis verdict.
type Assessment_ClassificationReason int32

const (
	// Default unspecified type.
	Assessment_CLASSIFICATION_REASON_UNSPECIFIED Assessment_ClassificationReason = 0
	// Interactions matched the behavior of an automated agent.
	Assessment_AUTOMATION Assessment_ClassificationReason = 1
	// The event originated from an illegitimate environment.
	Assessment_UNEXPECTED_ENVIRONMENT Assessment_ClassificationReason = 2
	// Traffic volume from the event source is higher than normal.
	Assessment_TOO_MUCH_TRAFFIC Assessment_ClassificationReason = 3
	// Interactions with the site were significantly different than expected
	// patterns.
	Assessment_UNEXPECTED_USAGE_PATTERNS Assessment_ClassificationReason = 4
	// Too little traffic has been received from this site thus far to generate
	// quality risk analysis.
	Assessment_LOW_CONFIDENCE_SCORE Assessment_ClassificationReason = 5
)

// Enum value maps for Assessment_ClassificationReason.
var (
	Assessment_ClassificationReason_name = map[int32]string{
		0: "CLASSIFICATION_REASON_UNSPECIFIED",
		1: "AUTOMATION",
		2: "UNEXPECTED_ENVIRONMENT",
		3: "TOO_MUCH_TRAFFIC",
		4: "UNEXPECTED_USAGE_PATTERNS",
		5: "LOW_CONFIDENCE_SCORE",
	}
	Assessment_ClassificationReason_value = map[string]int32{
		"CLASSIFICATION_REASON_UNSPECIFIED": 0,
		"AUTOMATION":                        1,
		"UNEXPECTED_ENVIRONMENT":            2,
		"TOO_MUCH_TRAFFIC":                  3,
		"UNEXPECTED_USAGE_PATTERNS":         4,
		"LOW_CONFIDENCE_SCORE":              5,
	}
)

func (x Assessment_ClassificationReason) Enum() *Assessment_ClassificationReason {
	p := new(Assessment_ClassificationReason)
	*p = x
	return p
}

func (x Assessment_ClassificationReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Assessment_ClassificationReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[2].Descriptor()
}

func (Assessment_ClassificationReason) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[2]
}

func (x Assessment_ClassificationReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Assessment_ClassificationReason.Descriptor instead.
func (Assessment_ClassificationReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{4, 0}
}

// Enum that represents the types of invalid token reasons.
type TokenProperties_InvalidReason int32

const (
	// Default unspecified type.
	TokenProperties_INVALID_REASON_UNSPECIFIED TokenProperties_InvalidReason = 0
	// If the failure reason was not accounted for.
	TokenProperties_UNKNOWN_INVALID_REASON TokenProperties_InvalidReason = 1
	// The provided user verification token was malformed.
	TokenProperties_MALFORMED TokenProperties_InvalidReason = 2
	// The user verification token had expired.
	TokenProperties_EXPIRED TokenProperties_InvalidReason = 3
	// The user verification had already been seen.
	TokenProperties_DUPE TokenProperties_InvalidReason = 4
	// The user verification token did not match the provided site key.
	// This may be a configuration error (e.g. development keys used in
	// production) or end users trying to use verification tokens from other
	// sites.
	//
	// Deprecated: Do not use.
	TokenProperties_SITE_MISMATCH TokenProperties_InvalidReason = 5
	// The user verification token was not present.  It is a required input.
	TokenProperties_MISSING TokenProperties_InvalidReason = 6
	// A retriable error (such as network failure) occurred on the browser.
	// Could easily be simulated by an attacker.
	TokenProperties_BROWSER_ERROR TokenProperties_InvalidReason = 7
)

// Enum value maps for TokenProperties_InvalidReason.
var (
	TokenProperties_InvalidReason_name = map[int32]string{
		0: "INVALID_REASON_UNSPECIFIED",
		1: "UNKNOWN_INVALID_REASON",
		2: "MALFORMED",
		3: "EXPIRED",
		4: "DUPE",
		5: "SITE_MISMATCH",
		6: "MISSING",
		7: "BROWSER_ERROR",
	}
	TokenProperties_InvalidReason_value = map[string]int32{
		"INVALID_REASON_UNSPECIFIED": 0,
		"UNKNOWN_INVALID_REASON":     1,
		"MALFORMED":                  2,
		"EXPIRED":                    3,
		"DUPE":                       4,
		"SITE_MISMATCH":              5,
		"MISSING":                    6,
		"BROWSER_ERROR":              7,
	}
)

func (x TokenProperties_InvalidReason) Enum() *TokenProperties_InvalidReason {
	p := new(TokenProperties_InvalidReason)
	*p = x
	return p
}

func (x TokenProperties_InvalidReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TokenProperties_InvalidReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[3].Descriptor()
}

func (TokenProperties_InvalidReason) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[3]
}

func (x TokenProperties_InvalidReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TokenProperties_InvalidReason.Descriptor instead.
func (TokenProperties_InvalidReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{6, 0}
}

// Labels returned by Account Defender for this request.
type AccountDefenderAssessment_AccountDefenderLabel int32

const (
	// Default unspecified type.
	AccountDefenderAssessment_ACCOUNT_DEFENDER_LABEL_UNSPECIFIED AccountDefenderAssessment_AccountDefenderLabel = 0
	// The request matches a known good profile for the user.
	AccountDefenderAssessment_PROFILE_MATCH AccountDefenderAssessment_AccountDefenderLabel = 1
	// The request is potentially a suspicious login event and should be further
	// verified either via multi-factor authentication or another system.
	AccountDefenderAssessment_SUSPICIOUS_LOGIN_ACTIVITY AccountDefenderAssessment_AccountDefenderLabel = 2
	// The request matched a profile that previously had suspicious account
	// creation behavior. This could mean this is a fake account.
	AccountDefenderAssessment_SUSPICIOUS_ACCOUNT_CREATION AccountDefenderAssessment_AccountDefenderLabel = 3
	// The account in the request has a high number of related accounts. It does
	// not necessarily imply that the account is bad but could require
	// investigating.
	AccountDefenderAssessment_RELATED_ACCOUNTS_NUMBER_HIGH AccountDefenderAssessment_AccountDefenderLabel = 4
)

// Enum value maps for AccountDefenderAssessment_AccountDefenderLabel.
var (
	AccountDefenderAssessment_AccountDefenderLabel_name = map[int32]string{
		0: "ACCOUNT_DEFENDER_LABEL_UNSPECIFIED",
		1: "PROFILE_MATCH",
		2: "SUSPICIOUS_LOGIN_ACTIVITY",
		3: "SUSPICIOUS_ACCOUNT_CREATION",
		4: "RELATED_ACCOUNTS_NUMBER_HIGH",
	}
	AccountDefenderAssessment_AccountDefenderLabel_value = map[string]int32{
		"ACCOUNT_DEFENDER_LABEL_UNSPECIFIED": 0,
		"PROFILE_MATCH":                      1,
		"SUSPICIOUS_LOGIN_ACTIVITY":          2,
		"SUSPICIOUS_ACCOUNT_CREATION":        3,
		"RELATED_ACCOUNTS_NUMBER_HIGH":       4,
	}
)

func (x AccountDefenderAssessment_AccountDefenderLabel) Enum() *AccountDefenderAssessment_AccountDefenderLabel {
	p := new(AccountDefenderAssessment_AccountDefenderLabel)
	*p = x
	return p
}

func (x AccountDefenderAssessment_AccountDefenderLabel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccountDefenderAssessment_AccountDefenderLabel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[4].Descriptor()
}

func (AccountDefenderAssessment_AccountDefenderLabel) Type() protoreflect.EnumType {
	return &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes[4]
}

func (x AccountDefenderAssessment_AccountDefenderLabel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccountDefenderAssessment_AccountDefenderLabel.Descriptor instead.
func (AccountDefenderAssessment_AccountDefenderLabel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{7, 0}
}

// The create assessment request message.
type CreateAssessmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which the assessment will be created,
	// in the format "projects/{project_number}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The assessment details.
	Assessment *Assessment `protobuf:"bytes,2,opt,name=assessment,proto3" json:"assessment,omitempty"`
}

func (x *CreateAssessmentRequest) Reset() {
	*x = CreateAssessmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAssessmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAssessmentRequest) ProtoMessage() {}

func (x *CreateAssessmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAssessmentRequest.ProtoReflect.Descriptor instead.
func (*CreateAssessmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{0}
}

func (x *CreateAssessmentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAssessmentRequest) GetAssessment() *Assessment {
	if x != nil {
		return x.Assessment
	}
	return nil
}

// The request message to annotate an Assessment.
type AnnotateAssessmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Assessment, in the format
	// "projects/{project_number}/assessments/{assessment_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The annotation that will be assigned to the Event. This field can be left
	// empty to provide reasons that apply to an event without concluding whether
	// the event is legitimate or fraudulent.
	Annotation AnnotateAssessmentRequest_Annotation `protobuf:"varint,2,opt,name=annotation,proto3,enum=google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest_Annotation" json:"annotation,omitempty"`
	// Optional. Optional reasons for the annotation that will be assigned to the Event.
	Reasons []AnnotateAssessmentRequest_Reason `protobuf:"varint,3,rep,packed,name=reasons,proto3,enum=google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest_Reason" json:"reasons,omitempty"`
	// Optional. Optional unique stable hashed user identifier to apply to the assessment.
	// This is an alternative to setting the hashed_account_id in
	// CreateAssessment, for example when the account identifier is not yet known
	// in the initial request. It is recommended that the identifier is hashed
	// using hmac-sha256 with stable secret.
	HashedAccountId []byte `protobuf:"bytes,4,opt,name=hashed_account_id,json=hashedAccountId,proto3" json:"hashed_account_id,omitempty"`
}

func (x *AnnotateAssessmentRequest) Reset() {
	*x = AnnotateAssessmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateAssessmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateAssessmentRequest) ProtoMessage() {}

func (x *AnnotateAssessmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateAssessmentRequest.ProtoReflect.Descriptor instead.
func (*AnnotateAssessmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{1}
}

func (x *AnnotateAssessmentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnnotateAssessmentRequest) GetAnnotation() AnnotateAssessmentRequest_Annotation {
	if x != nil {
		return x.Annotation
	}
	return AnnotateAssessmentRequest_ANNOTATION_UNSPECIFIED
}

func (x *AnnotateAssessmentRequest) GetReasons() []AnnotateAssessmentRequest_Reason {
	if x != nil {
		return x.Reasons
	}
	return nil
}

func (x *AnnotateAssessmentRequest) GetHashedAccountId() []byte {
	if x != nil {
		return x.HashedAccountId
	}
	return nil
}

// Empty response for AnnotateAssessment.
type AnnotateAssessmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AnnotateAssessmentResponse) Reset() {
	*x = AnnotateAssessmentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnnotateAssessmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateAssessmentResponse) ProtoMessage() {}

func (x *AnnotateAssessmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateAssessmentResponse.ProtoReflect.Descriptor instead.
func (*AnnotateAssessmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{2}
}

// Password leak verification info.
type PasswordLeakVerification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Scrypt hash of the username+password that the customer wants to verify
	// against a known password leak.
	HashedUserCredentials []byte `protobuf:"bytes,1,opt,name=hashed_user_credentials,json=hashedUserCredentials,proto3" json:"hashed_user_credentials,omitempty"`
	// Output only. Whether or not the user's credentials are present in a known leak.
	CredentialsLeaked bool `protobuf:"varint,2,opt,name=credentials_leaked,json=credentialsLeaked,proto3" json:"credentials_leaked,omitempty"`
	// Optional. The username part of the user credentials for which we want to trigger a
	// leak check in canonicalized form. This is the same data used to create the
	// hashed_user_credentials on the customer side.
	CanonicalizedUsername string `protobuf:"bytes,3,opt,name=canonicalized_username,json=canonicalizedUsername,proto3" json:"canonicalized_username,omitempty"`
}

func (x *PasswordLeakVerification) Reset() {
	*x = PasswordLeakVerification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PasswordLeakVerification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PasswordLeakVerification) ProtoMessage() {}

func (x *PasswordLeakVerification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PasswordLeakVerification.ProtoReflect.Descriptor instead.
func (*PasswordLeakVerification) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{3}
}

func (x *PasswordLeakVerification) GetHashedUserCredentials() []byte {
	if x != nil {
		return x.HashedUserCredentials
	}
	return nil
}

func (x *PasswordLeakVerification) GetCredentialsLeaked() bool {
	if x != nil {
		return x.CredentialsLeaked
	}
	return false
}

func (x *PasswordLeakVerification) GetCanonicalizedUsername() string {
	if x != nil {
		return x.CanonicalizedUsername
	}
	return ""
}

// A recaptcha assessment resource.
type Assessment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name for the Assessment in the format
	// "projects/{project_number}/assessments/{assessment_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The event being assessed.
	Event *Event `protobuf:"bytes,2,opt,name=event,proto3" json:"event,omitempty"`
	// Output only. Legitimate event score from 0.0 to 1.0.
	// (1.0 means very likely legitimate traffic while 0.0 means very likely
	// non-legitimate traffic).
	Score float32 `protobuf:"fixed32,3,opt,name=score,proto3" json:"score,omitempty"`
	// Output only. Properties of the provided event token.
	TokenProperties *TokenProperties `protobuf:"bytes,4,opt,name=token_properties,json=tokenProperties,proto3" json:"token_properties,omitempty"`
	// Output only. Reasons contributing to the risk analysis verdict.
	Reasons []Assessment_ClassificationReason `protobuf:"varint,5,rep,packed,name=reasons,proto3,enum=google.cloud.recaptchaenterprise.v1beta1.Assessment_ClassificationReason" json:"reasons,omitempty"`
	// Information about the user's credentials used to check for leaks.
	// This feature is part of the Early Access Program (EAP). Exercise caution,
	// and do not deploy integrations based on this feature in a production
	// environment.
	PasswordLeakVerification *PasswordLeakVerification `protobuf:"bytes,7,opt,name=password_leak_verification,json=passwordLeakVerification,proto3" json:"password_leak_verification,omitempty"`
	// Assessment returned by Account Defender when a hashed_account_id is
	// provided.
	AccountDefenderAssessment *AccountDefenderAssessment `protobuf:"bytes,8,opt,name=account_defender_assessment,json=accountDefenderAssessment,proto3" json:"account_defender_assessment,omitempty"`
}

func (x *Assessment) Reset() {
	*x = Assessment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Assessment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Assessment) ProtoMessage() {}

func (x *Assessment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Assessment.ProtoReflect.Descriptor instead.
func (*Assessment) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{4}
}

func (x *Assessment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Assessment) GetEvent() *Event {
	if x != nil {
		return x.Event
	}
	return nil
}

func (x *Assessment) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *Assessment) GetTokenProperties() *TokenProperties {
	if x != nil {
		return x.TokenProperties
	}
	return nil
}

func (x *Assessment) GetReasons() []Assessment_ClassificationReason {
	if x != nil {
		return x.Reasons
	}
	return nil
}

func (x *Assessment) GetPasswordLeakVerification() *PasswordLeakVerification {
	if x != nil {
		return x.PasswordLeakVerification
	}
	return nil
}

func (x *Assessment) GetAccountDefenderAssessment() *AccountDefenderAssessment {
	if x != nil {
		return x.AccountDefenderAssessment
	}
	return nil
}

type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The user response token provided by the reCAPTCHA client-side integration
	// on your site.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Optional. The site key that was used to invoke reCAPTCHA on your site and generate
	// the token.
	SiteKey string `protobuf:"bytes,2,opt,name=site_key,json=siteKey,proto3" json:"site_key,omitempty"`
	// Optional. The user agent present in the request from the user's device related to
	// this event.
	UserAgent string `protobuf:"bytes,3,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	// Optional. The IP address in the request from the user's device related to this event.
	UserIpAddress string `protobuf:"bytes,4,opt,name=user_ip_address,json=userIpAddress,proto3" json:"user_ip_address,omitempty"`
	// Optional. The expected action for this type of event. This should be the same action
	// provided at token generation time on client-side platforms already
	// integrated with recaptcha enterprise.
	ExpectedAction string `protobuf:"bytes,5,opt,name=expected_action,json=expectedAction,proto3" json:"expected_action,omitempty"`
	// Optional. Optional unique stable hashed user identifier for the request. The
	// identifier should ideally be hashed using sha256 with stable secret.
	HashedAccountId []byte `protobuf:"bytes,6,opt,name=hashed_account_id,json=hashedAccountId,proto3" json:"hashed_account_id,omitempty"`
}

func (x *Event) Reset() {
	*x = Event{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{5}
}

func (x *Event) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *Event) GetSiteKey() string {
	if x != nil {
		return x.SiteKey
	}
	return ""
}

func (x *Event) GetUserAgent() string {
	if x != nil {
		return x.UserAgent
	}
	return ""
}

func (x *Event) GetUserIpAddress() string {
	if x != nil {
		return x.UserIpAddress
	}
	return ""
}

func (x *Event) GetExpectedAction() string {
	if x != nil {
		return x.ExpectedAction
	}
	return ""
}

func (x *Event) GetHashedAccountId() []byte {
	if x != nil {
		return x.HashedAccountId
	}
	return nil
}

type TokenProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the provided user response token is valid. When valid = false, the
	// reason could be specified in invalid_reason or it could also be due to
	// a user failing to solve a challenge or a sitekey mismatch (i.e the sitekey
	// used to generate the token was different than the one specified in the
	// assessment).
	Valid bool `protobuf:"varint,1,opt,name=valid,proto3" json:"valid,omitempty"`
	// Reason associated with the response when valid = false.
	InvalidReason TokenProperties_InvalidReason `protobuf:"varint,2,opt,name=invalid_reason,json=invalidReason,proto3,enum=google.cloud.recaptchaenterprise.v1beta1.TokenProperties_InvalidReason" json:"invalid_reason,omitempty"`
	// The timestamp corresponding to the generation of the token.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The hostname of the page on which the token was generated.
	Hostname string `protobuf:"bytes,4,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Action name provided at token generation.
	Action string `protobuf:"bytes,5,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *TokenProperties) Reset() {
	*x = TokenProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TokenProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TokenProperties) ProtoMessage() {}

func (x *TokenProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TokenProperties.ProtoReflect.Descriptor instead.
func (*TokenProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{6}
}

func (x *TokenProperties) GetValid() bool {
	if x != nil {
		return x.Valid
	}
	return false
}

func (x *TokenProperties) GetInvalidReason() TokenProperties_InvalidReason {
	if x != nil {
		return x.InvalidReason
	}
	return TokenProperties_INVALID_REASON_UNSPECIFIED
}

func (x *TokenProperties) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TokenProperties) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *TokenProperties) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

// Account Defender risk assessment.
type AccountDefenderAssessment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Labels for this request.
	Labels []AccountDefenderAssessment_AccountDefenderLabel `protobuf:"varint,1,rep,packed,name=labels,proto3,enum=google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment_AccountDefenderLabel" json:"labels,omitempty"`
}

func (x *AccountDefenderAssessment) Reset() {
	*x = AccountDefenderAssessment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountDefenderAssessment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountDefenderAssessment) ProtoMessage() {}

func (x *AccountDefenderAssessment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountDefenderAssessment.ProtoReflect.Descriptor instead.
func (*AccountDefenderAssessment) Descriptor() ([]byte, []int) {
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP(), []int{7}
}

func (x *AccountDefenderAssessment) GetLabels() []AccountDefenderAssessment_AccountDefenderLabel {
	if x != nil {
		return x.Labels
	}
	return nil
}

var File_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto protoreflect.FileDescriptor

var file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDesc = []byte{
	0x0a, 0x42, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xc1, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x0a, 0x61,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xe6, 0x05, 0x0a, 0x19, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x73, 0x0a, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12,
	0x2f, 0x0a, 0x11, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64,
	0x22, 0x7e, 0x0a, 0x0a, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a,
	0x0a, 0x16, 0x41, 0x4e, 0x4e, 0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4c, 0x45,
	0x47, 0x49, 0x54, 0x49, 0x4d, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x52,
	0x41, 0x55, 0x44, 0x55, 0x4c, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x10, 0x50, 0x41,
	0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x10, 0x03,
	0x1a, 0x02, 0x08, 0x01, 0x12, 0x1a, 0x0a, 0x12, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44,
	0x5f, 0x49, 0x4e, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x10, 0x04, 0x1a, 0x02, 0x08, 0x01,
	0x22, 0xec, 0x01, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52,
	0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43,
	0x4b, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x48, 0x41, 0x52, 0x47, 0x45, 0x42, 0x41, 0x43,
	0x4b, 0x5f, 0x46, 0x52, 0x41, 0x55, 0x44, 0x10, 0x08, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x48, 0x41,
	0x52, 0x47, 0x45, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x44, 0x49, 0x53, 0x50, 0x55, 0x54, 0x45, 0x10,
	0x09, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x41, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x48, 0x45, 0x55,
	0x52, 0x49, 0x53, 0x54, 0x49, 0x43, 0x53, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x49,
	0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x57, 0x4f, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f,
	0x52, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x41, 0x53, 0x53, 0x45, 0x44, 0x5f, 0x54, 0x57,
	0x4f, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x5f, 0x54, 0x57, 0x4f, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x10,
	0x04, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x52, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x50, 0x41, 0x53,
	0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x4e, 0x43, 0x4f, 0x52,
	0x52, 0x45, 0x43, 0x54, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x06, 0x22,
	0x1c, 0x0a, 0x1a, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73,
	0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc7, 0x01,
	0x0a, 0x18, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x4c, 0x65, 0x61, 0x6b, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x17, 0x68, 0x61,
	0x73, 0x68, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x15, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x5f, 0x6c, 0x65, 0x61, 0x6b, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x4c, 0x65, 0x61, 0x6b, 0x65, 0x64, 0x12, 0x3a, 0x0a, 0x16, 0x63,
	0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x15, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x55,
	0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x81, 0x07, 0x0a, 0x0a, 0x41, 0x73, 0x73, 0x65,
	0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x45, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52,
	0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x12, 0x69, 0x0a, 0x10, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x68, 0x0a, 0x07,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x1a, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70,
	0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x4c,
	0x65, 0x61, 0x6b, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x18, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x4c, 0x65, 0x61, 0x6b, 0x56, 0x65, 0x72,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x1b, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x61,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x19, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x66,
	0x65, 0x6e, 0x64, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0xb8, 0x01, 0x0a, 0x14, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4c, 0x41, 0x53,
	0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12,
	0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f, 0x45, 0x4e,
	0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x4f, 0x4f, 0x5f, 0x4d, 0x55, 0x43, 0x48, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x10,
	0x03, 0x12, 0x1d, 0x0a, 0x19, 0x55, 0x4e, 0x45, 0x58, 0x50, 0x45, 0x43, 0x54, 0x45, 0x44, 0x5f,
	0x55, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x41, 0x54, 0x54, 0x45, 0x52, 0x4e, 0x53, 0x10, 0x04,
	0x12, 0x18, 0x0a, 0x14, 0x4c, 0x4f, 0x57, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x44, 0x45, 0x4e,
	0x43, 0x45, 0x5f, 0x53, 0x43, 0x4f, 0x52, 0x45, 0x10, 0x05, 0x3a, 0x5f, 0xea, 0x41, 0x5c, 0x0a,
	0x2d, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b,
	0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xf2, 0x01, 0x0a, 0x05,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1e, 0x0a, 0x08, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x73, 0x69, 0x74, 0x65, 0x4b, 0x65, 0x79,
	0x12, 0x22, 0x0a, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x75, 0x73, 0x65, 0x72, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x5f,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x75, 0x73, 0x65, 0x72, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x2f, 0x0a, 0x11, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x68, 0x61, 0x73, 0x68, 0x65, 0x64, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64,
	0x22, 0xb3, 0x03, 0x0a, 0x0f, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x12, 0x6e, 0x0a, 0x0e, 0x69, 0x6e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x49, 0x6e,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x0d, 0x69, 0x6e, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x0d,
	0x49, 0x6e, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1e, 0x0a,
	0x1a, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a,
	0x16, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44,
	0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x41, 0x4c,
	0x46, 0x4f, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x50, 0x49,
	0x52, 0x45, 0x44, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x55, 0x50, 0x45, 0x10, 0x04, 0x12,
	0x15, 0x0a, 0x0d, 0x53, 0x49, 0x54, 0x45, 0x5f, 0x4d, 0x49, 0x53, 0x4d, 0x41, 0x54, 0x43, 0x48,
	0x10, 0x05, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4e,
	0x47, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x42, 0x52, 0x4f, 0x57, 0x53, 0x45, 0x52, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x07, 0x22, 0xc3, 0x02, 0x0a, 0x19, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x70, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0xb3, 0x01, 0x0a, 0x14, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12,
	0x26, 0x0a, 0x22, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x46, 0x45, 0x4e,
	0x44, 0x45, 0x52, 0x5f, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x52, 0x4f, 0x46, 0x49,
	0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x55,
	0x53, 0x50, 0x49, 0x43, 0x49, 0x4f, 0x55, 0x53, 0x5f, 0x4c, 0x4f, 0x47, 0x49, 0x4e, 0x5f, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x49, 0x54, 0x59, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x55, 0x53,
	0x50, 0x49, 0x43, 0x49, 0x4f, 0x55, 0x53, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45,
	0x4c, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x53, 0x5f, 0x4e,
	0x55, 0x4d, 0x42, 0x45, 0x52, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x04, 0x32, 0xcd, 0x04, 0x0a,
	0x21, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x56, 0x31, 0x42, 0x65, 0x74,
	0x61, 0x31, 0x12, 0xdd, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74,
	0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x28, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x3a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0xda, 0x41,
	0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0xef, 0x01, 0x0a, 0x12, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41,
	0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x41, 0x73, 0x73,
	0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x65,
	0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x31, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x0f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x56, 0xca, 0x41, 0x22, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xac, 0x02, 0x0a,
	0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x65, 0x63, 0x61,
	0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x18, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63,
	0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x5b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x72, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x72, 0x65, 0x63,
	0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0xa2, 0x02, 0x04, 0x47, 0x43, 0x52, 0x45, 0xaa, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61,
	0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74,
	0x61, 0x31, 0xca, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x52, 0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x2b,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x52,
	0x65, 0x63, 0x61, 0x70, 0x74, 0x63, 0x68, 0x61, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescOnce sync.Once
	file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescData = file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDesc
)

func file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescGZIP() []byte {
	file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescOnce.Do(func() {
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescData)
	})
	return file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDescData
}

var file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_goTypes = []interface{}{
	(AnnotateAssessmentRequest_Annotation)(0),           // 0: google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation
	(AnnotateAssessmentRequest_Reason)(0),               // 1: google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason
	(Assessment_ClassificationReason)(0),                // 2: google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason
	(TokenProperties_InvalidReason)(0),                  // 3: google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason
	(AccountDefenderAssessment_AccountDefenderLabel)(0), // 4: google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment.AccountDefenderLabel
	(*CreateAssessmentRequest)(nil),                     // 5: google.cloud.recaptchaenterprise.v1beta1.CreateAssessmentRequest
	(*AnnotateAssessmentRequest)(nil),                   // 6: google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest
	(*AnnotateAssessmentResponse)(nil),                  // 7: google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentResponse
	(*PasswordLeakVerification)(nil),                    // 8: google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification
	(*Assessment)(nil),                                  // 9: google.cloud.recaptchaenterprise.v1beta1.Assessment
	(*Event)(nil),                                       // 10: google.cloud.recaptchaenterprise.v1beta1.Event
	(*TokenProperties)(nil),                             // 11: google.cloud.recaptchaenterprise.v1beta1.TokenProperties
	(*AccountDefenderAssessment)(nil),                   // 12: google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment
	(*timestamppb.Timestamp)(nil),                       // 13: google.protobuf.Timestamp
}
var file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_depIdxs = []int32{
	9,  // 0: google.cloud.recaptchaenterprise.v1beta1.CreateAssessmentRequest.assessment:type_name -> google.cloud.recaptchaenterprise.v1beta1.Assessment
	0,  // 1: google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.annotation:type_name -> google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Annotation
	1,  // 2: google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.reasons:type_name -> google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest.Reason
	10, // 3: google.cloud.recaptchaenterprise.v1beta1.Assessment.event:type_name -> google.cloud.recaptchaenterprise.v1beta1.Event
	11, // 4: google.cloud.recaptchaenterprise.v1beta1.Assessment.token_properties:type_name -> google.cloud.recaptchaenterprise.v1beta1.TokenProperties
	2,  // 5: google.cloud.recaptchaenterprise.v1beta1.Assessment.reasons:type_name -> google.cloud.recaptchaenterprise.v1beta1.Assessment.ClassificationReason
	8,  // 6: google.cloud.recaptchaenterprise.v1beta1.Assessment.password_leak_verification:type_name -> google.cloud.recaptchaenterprise.v1beta1.PasswordLeakVerification
	12, // 7: google.cloud.recaptchaenterprise.v1beta1.Assessment.account_defender_assessment:type_name -> google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment
	3,  // 8: google.cloud.recaptchaenterprise.v1beta1.TokenProperties.invalid_reason:type_name -> google.cloud.recaptchaenterprise.v1beta1.TokenProperties.InvalidReason
	13, // 9: google.cloud.recaptchaenterprise.v1beta1.TokenProperties.create_time:type_name -> google.protobuf.Timestamp
	4,  // 10: google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment.labels:type_name -> google.cloud.recaptchaenterprise.v1beta1.AccountDefenderAssessment.AccountDefenderLabel
	5,  // 11: google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1.CreateAssessment:input_type -> google.cloud.recaptchaenterprise.v1beta1.CreateAssessmentRequest
	6,  // 12: google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1.AnnotateAssessment:input_type -> google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentRequest
	9,  // 13: google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1.CreateAssessment:output_type -> google.cloud.recaptchaenterprise.v1beta1.Assessment
	7,  // 14: google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1.AnnotateAssessment:output_type -> google.cloud.recaptchaenterprise.v1beta1.AnnotateAssessmentResponse
	13, // [13:15] is the sub-list for method output_type
	11, // [11:13] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_init() }
func file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_init() {
	if File_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAssessmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateAssessmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnnotateAssessmentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PasswordLeakVerification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Assessment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Event); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TokenProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountDefenderAssessment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_goTypes,
		DependencyIndexes: file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_depIdxs,
		EnumInfos:         file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_enumTypes,
		MessageInfos:      file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_msgTypes,
	}.Build()
	File_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto = out.File
	file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_rawDesc = nil
	file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_goTypes = nil
	file_google_cloud_recaptchaenterprise_v1beta1_recaptchaenterprise_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RecaptchaEnterpriseServiceV1Beta1Client is the client API for RecaptchaEnterpriseServiceV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecaptchaEnterpriseServiceV1Beta1Client interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fradulent.
	AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error)
}

type recaptchaEnterpriseServiceV1Beta1Client struct {
	cc grpc.ClientConnInterface
}

func NewRecaptchaEnterpriseServiceV1Beta1Client(cc grpc.ClientConnInterface) RecaptchaEnterpriseServiceV1Beta1Client {
	return &recaptchaEnterpriseServiceV1Beta1Client{cc}
}

func (c *recaptchaEnterpriseServiceV1Beta1Client) CreateAssessment(ctx context.Context, in *CreateAssessmentRequest, opts ...grpc.CallOption) (*Assessment, error) {
	out := new(Assessment)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/CreateAssessment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recaptchaEnterpriseServiceV1Beta1Client) AnnotateAssessment(ctx context.Context, in *AnnotateAssessmentRequest, opts ...grpc.CallOption) (*AnnotateAssessmentResponse, error) {
	out := new(AnnotateAssessmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/AnnotateAssessment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecaptchaEnterpriseServiceV1Beta1Server is the server API for RecaptchaEnterpriseServiceV1Beta1 service.
type RecaptchaEnterpriseServiceV1Beta1Server interface {
	// Creates an Assessment of the likelihood an event is legitimate.
	CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error)
	// Annotates a previously created Assessment to provide additional information
	// on whether the event turned out to be authentic or fradulent.
	AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error)
}

// UnimplementedRecaptchaEnterpriseServiceV1Beta1Server can be embedded to have forward compatible implementations.
type UnimplementedRecaptchaEnterpriseServiceV1Beta1Server struct {
}

func (*UnimplementedRecaptchaEnterpriseServiceV1Beta1Server) CreateAssessment(context.Context, *CreateAssessmentRequest) (*Assessment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAssessment not implemented")
}
func (*UnimplementedRecaptchaEnterpriseServiceV1Beta1Server) AnnotateAssessment(context.Context, *AnnotateAssessmentRequest) (*AnnotateAssessmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnnotateAssessment not implemented")
}

func RegisterRecaptchaEnterpriseServiceV1Beta1Server(s *grpc.Server, srv RecaptchaEnterpriseServiceV1Beta1Server) {
	s.RegisterService(&_RecaptchaEnterpriseServiceV1Beta1_serviceDesc, srv)
}

func _RecaptchaEnterpriseServiceV1Beta1_CreateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceV1Beta1Server).CreateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/CreateAssessment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceV1Beta1Server).CreateAssessment(ctx, req.(*CreateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RecaptchaEnterpriseServiceV1Beta1_AnnotateAssessment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateAssessmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecaptchaEnterpriseServiceV1Beta1Server).AnnotateAssessment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1/AnnotateAssessment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecaptchaEnterpriseServiceV1Beta1Server).AnnotateAssessment(ctx, req.(*AnnotateAssessmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RecaptchaEnterpriseServiceV1Beta1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recaptchaenterprise.v1beta1.RecaptchaEnterpriseServiceV1Beta1",
	HandlerType: (*RecaptchaEnterpriseServiceV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAssessment",
			Handler:    _RecaptchaEnterpriseServiceV1Beta1_CreateAssessment_Handler,
		},
		{
			MethodName: "AnnotateAssessment",
			Handler:    _RecaptchaEnterpriseServiceV1Beta1_AnnotateAssessment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recaptchaenterprise/v1beta1/recaptchaenterprise.proto",
}
