#!/usr/bin/python

from __future__ import print_function

import json
import argparse
import sys

pic_devid_lookup = {
    'PIC18F6410': 0x06E0,
    'PIC18F2525': 0x0CC0,
    'PIC18F2520': 0x1100,
    'PIC18F2523': 0x1100,
    'PIC18LF45K50': 0x5C80,
    'PIC18F46Q10': 0x7120,
    'PIC18F8527': 0x1360,
    'PIC18F8525': 0x0AC0,
    'PIC18F8520': 0x0B00,
    'PIC18F242': 0x0480,
    'PIC16LF1458': 0x3026,
    'PIC16LF1459': 0x3027,
    'PIC16LF1454': 0x3024,
    'PIC16LF1455': 0x3025,
    'PIC18F248': 0x0800,
    'PIC18F2450': 0x2420,
    'PIC16LF1517': 0x17A0,
    'PIC16LF1516': 0x1780,
    'PIC18F2455': 0x1260,
    'PIC16LF1513': 0x1740,
    'PIC16LF1512': 0x1720,
    'PIC16F716': 0x1140,
    'PIC16LF1519': 0x17E0,
    'PIC16LF1518': 0x17C0,
    'PIC18F96J94': 0x62E0,
    'PIC18F2620': 0x0C80,
    'PIC16F15313': 0x30BE,
    'PIC18LF26K40': 0x6A60,
    'PIC18LF26K42': 0x6DA0,
    'PIC18F86J65': 0x1F40,
    'PIC18F67K22': 0x5180,
    'PIC18F86J60': 0x1820,
    'PIC16F18875': 0x306D,
    'PIC16F18876': 0x3071,
    'PIC16F18877': 0x3075,
    'PIC16LF1779': 0x3093,
    'PIC16LF1778': 0x3092,
    'PIC18LF45J10': 0x1C60,
    'PIC16LF1773': 0x308C,
    'PIC16F1527': 0x15A0,
    'PIC16F1526': 0x1580,
    'PIC16LF1777': 0x3091,
    'PIC16LF1776': 0x308D,
    'PIC18F84J90': 0x38A0,
    'PIC18LF27K42': 0x6D80,
    'PIC18LF27K40': 0x6A40,
    'PIC18F65K90': 0x5240,
    'PIC16F1703': 0x3061,
    'PIC16F88': 0x0760,
    'PIC16F1707': 0x3060,
    'PIC16F1705': 0x3055,
    'PIC16F1704': 0x3043,
    'PIC16F1709': 0x3054,
    'PIC16F1708': 0x3042,
    'PIC16LF1789': 0x302C,
    'PIC16F87': 0x0720,
    'PIC18F44J11': 0x4DE0,
    'PIC16F18456': 0x30D9,
    'PIC16F18455': 0x30D7,
    'PIC18LF47J53': 0x5AE0,
    'PIC18F27K42': 0x6C40,
    'PIC16F19186': 0x30BC,
    'PIC16F19185': 0x30BA,
    'PIC16F627A': 0x1040,
    'PIC18F57K42': 0x6B80,
    'PIC17C756A': 0x0220,
    'PIC18F67K90': 0x5100,
    'PIC18F4685': 0x2760,
    'PIC18F45J50': 0x4C80,
    'PIC18F4682': 0x2740,
    'PIC18F4680': 0x0E80,
    'PIC18F6310': 0x0BE0,
    'PIC18F23K20': 0x20E0,
    'PIC18F83J90': 0x3880,
    'PIC16LF15375': 0x30B3,
    'PIC16LF15376': 0x30B5,
    'PIC18C252': 0x0220,
    'PIC18F23K22': 0x5740,
    'PIC16LF18313': 0x3068,
    'PIC16HV753': 0x3031,
    'PIC16HV616': 0x1260,
    'PIC16HV610': 0x22A0,
    'PIC18F46K50': 0x5D00,
    'PIC18F24Q10': 0x71C0,
    'PIC16F914': 0x13C0,
    'PIC16F76': 0x0640,
    'PIC16F77': 0x0660,
    'PIC12F752': 0x1500,
    'PIC16F18426': 0x30D2,
    'PIC16F72': 0x00A0,
    'PIC16F18424': 0x30CA,
    'PIC12F617': 0x1360,
    'PIC12F615': 0x2180,
    'PIC16F767': 0x0EA0,
    'PIC16F1933': 0x2300,
    'PIC16F1934': 0x2340,
    'PIC16F689': 0x1340,
    'PIC16F1936': 0x2360,
    'PIC16F1937': 0x2380,
    'PIC16F1938': 0x23A0,
    'PIC16F1939': 0x23C0,
    'PIC16F687': 0x1320,
    'PIC18F66K90': 0x5200,
    'PIC16LF726': 0x1920,
    'PIC16LF727': 0x1900,
    'PIC16LF724': 0x1940,
    'PIC18F87K90': 0x5140,
    'PIC16LF722': 0x1980,
    'PIC16LF1554': 0x2F00,
    'PIC16LF720': 0x1C40,
    'PIC16LF721': 0x1C60,
    'PIC16LF1559': 0x2F20,
    'PIC18F8410': 0x06C0,
    'PIC18F2320': 0x0500,
    'PIC18F66K80': 0x60E0,
    'PIC18F6627': 0x13C0,
    'PIC16F610': 0x2260,
    'PIC16F616': 0x1240,
    'PIC12F1571': 0x3051,
    'PIC12F1572': 0x3050,
    'PIC18F6520': 0x0B20,
    'PIC18F6525': 0x0AE0,
    'PIC18F6527': 0x1340,
    'PIC18F43K22': 0x5700,
    'PIC18F43K20': 0x20C0,
    'PIC18F2458': 0x2A60,
    'PIC18F6585': 0x0A60,
    'PIC12HV615': 0x21A0,
    'PIC18LF45K40': 0x6A20,
    'PIC18F442': 0x04A0,
    'PIC18LF65K80': 0x6220,
    'PIC18F448': 0x0820,
    'PIC18F44K22': 0x5600,
    'PIC16LF1824T39A': 0x2740,
    'PIC18F6628': 0x49C0,
    'PIC18F4539': 0x0420,
    'PIC16F15325': 0x30C6,
    'PIC16F15324': 0x30C2,
    'PIC16F15323': 0x30C0,
    'PIC18F6622': 0x1380,
    'PIC18F6621': 0x0AA0,
    'PIC18F6620': 0x0660,
    'PIC18F67J10': 0x15A0,
    'PIC18F67J11': 0x4480,
    'PIC18F86J15': 0x1740,
    'PIC18F1230': 0x1E00,
    'PIC18F2580': 0x1AC0,
    'PIC18F1330-ICD': 0x1FE0,
    'PIC18F86J11': 0x44E0,
    'PIC18F86J10': 0x1720,
    'PIC18F2585': 0x0EE0,
    'PIC18F86J16': 0x4500,
    'PIC18F45K50': 0x5C00,
    'PIC18F44J50': 0x4C60,
    'PIC16F1512': 0x1700,
    'PIC16F818': 0x04C0,
    'PIC16F1516': 0x1680,
    'PIC16F1517': 0x16A0,
    'PIC18LF24K50': 0x5CE0,
    'PIC18LF14K22': 0x4F60,
    'PIC16F1518': 0x16C0,
    'PIC16F1519': 0x16E0,
    'PIC18F24J11': 0x4D80,
    'PIC18F24J10': 0x1D00,
    'PIC18C601': 0x0120,
    'PIC18LF43K22': 0x5720,
    'PIC18F4331': 0x08A0,
    'PIC18F4620': 0x0C00,
    'PIC12LF1612': 0x3059,
    'PIC18F4585': 0x0EA0,
    'PIC18F4580': 0x1A80,
    'PIC18F46J50': 0x4CA0,
    'PIC16F18855': 0x306C,
    'PIC18F25J11': 0x4DA0,
    'PIC18LF25J11': 0x4E60,
    'PIC12F1612': 0x3058,
    'PIC18F25J50': 0x4C20,
    'PIC18LF23K22': 0x5760,
    'PIC18F46K80': 0x6100,
    'PIC18C858': 0x00E0,
    'PIC16LF15344': 0x30C5,
    'PIC16LF15345': 0x30C9,
    'PIC18LF24K40': 0x6AA0,
    'PIC16LF18346': 0x30A7,
    'PIC16LF18345': 0x3041,
    'PIC16LF18344': 0x303D,
    'PIC18F66J93': 0x5040,
    'PIC18F66J90': 0x5000,
    'PIC18F64J90': 0x3820,
    'PIC18F26K22': 0x5440,
    'PIC18F66J99': 0x63C0,
    'PIC18F26K20': 0x2020,
    'PIC16LF19195': 0x3086,
    'PIC16F819': 0x04E0,
    'PIC16LF1614': 0x307A,
    'PIC16LF1615': 0x307E,
    'PIC16LF1613': 0x304D,
    'PIC16F1513': 0x1640,
    'PIC16LF1618': 0x307B,
    'PIC12LF1501': 0x2D80,
    'PIC18F66K40': 0x6AE0,
    'PIC18F24K50': 0x5C60,
    'PIC18F66J60': 0x1800,
    'PIC10LF320': 0x29E0,
    'PIC10LF322': 0x29C0,
    'PIC18F66J65': 0x1F00,
    'PIC18F2321': 0x2120,
    'PIC18F2431': 0x08C0,
    'PIC16F1847': 0x1480,
    'PIC18LF45K42': 0x6D60,
    'PIC18F2439': 0x0480,
    'PIC18LF66K80': 0x61C0,
    'PIC18LF13K50': 0x4700,
    'PIC16LF1508': 0x2DE0,
    'PIC16LF1509': 0x2E00,
    'PIC16LF1503': 0x2DA0,
    'PIC16LF1507': 0x2DC0,
    'PIC16F723': 0x1860,
    'PIC16F722': 0x1880,
    'PIC16F721': 0x1C20,
    'PIC16F720': 0x1C00,
    'PIC16F727': 0x1800,
    'PIC16F726': 0x1820,
    'PIC16F724': 0x1840,
    'PIC12LF1572': 0x3052,
    'PIC12LF1571': 0x3053,
    'PIC18F86K90': 0x5260,
    'PIC18LF14K50': 0x4720,
    'PIC18LF56K42': 0x6CE0,
    'PIC18F86J50': 0x41E0,
    'PIC18F67J50': 0x4180,
    'PIC18LF26K50': 0x5D60,
    'PIC18F25K22': 0x5540,
    'PIC18F2515': 0x0CE0,
    'PIC18F25K20': 0x2060,
    'PIC16C782': 0x0D60,
    'PIC18F8620': 0x0640,
    'PIC16C781': 0x0D40,
    'PIC16LF1768': 0x3086,
    'PIC16LF1769': 0x3087,
    'PIC18F8628': 0x49E0,
    'PIC16LF1764': 0x3082,
    'PIC16LF1765': 0x3083,
    'PIC18F56K42': 0x6BA0,
    'PIC18F8585': 0x0A40,
    'PIC18F2539': 0x0400,
    'PIC16F874A': 0x0E60,
    'PIC18F65K80': 0x6140,
    'PIC16F1776': 0x308B,
    'PIC16F1777': 0x308E,
    'PIC16F1773': 0x308A,
    'PIC18F46J11': 0x4E20,
    'PIC18F46J13': 0x59A0,
    'PIC18LF27J53': 0x5A60,
    'PIC16F1778': 0x308F,
    'PIC16F1779': 0x3090,
    'PIC18F87J50': 0x4220,
    'PIC16F15375': 0x30B2,
    'PIC16F15376': 0x30B4,
    'PIC18F26Q10': 0x7180,
    'PIC16F19195': 0x3084,
    'PIC16F19196': 0x3085,
    'PIC16F19197': 0x30A2,
    'PIC18LF57K42': 0x6CC0,
    'PIC18F86K22': 0x5320,
    'PIC16F1789': 0x302A,
    'PIC16F1788': 0x302B,
    'PIC16F1783': 0x2A20,
    'PIC16F1782': 0x2A00,
    'PIC18F44K20': 0x2080,
    'PIC16F1787': 0x2A80,
    'PIC16F1786': 0x2A60,
    'PIC18F25J10': 0x1C00,
    'PIC16F1784': 0x2A40,
    'PIC16F873': 0x0960,
    'PIC16LF1719': 0x305D,
    'PIC16LF1718': 0x305E,
    'PIC16F628A': 0x1060,
    'PIC16F872': 0x08E0,
    'PIC16LF1713': 0x304B,
    'PIC16LF1717': 0x305F,
    'PIC16LF1716': 0x304A,
    'PIC18F24K22': 0x5640,
    'PIC18F458': 0x0860,
    'PIC18F66J55': 0x4160,
    'PIC18F13K22': 0x4F40,
    'PIC18F8493': 0x0E20,
    'PIC18F8490': 0x0680,
    'PIC18F6722': 0x1400,
    'PIC18F6723': 0x4A00,
    'PIC18F6720': 0x0620,
    'PIC16F18346': 0x30A5,
    'PIC16F18344': 0x303B,
    'PIC16F18345': 0x303F,
    'PIC18F8310': 0x0BC0,
    'PIC18F26J13': 0x5920,
    'PIC12F609': 0x2240,
    'PIC18F26J11': 0x4DC0,
    'PIC18F83J11': 0x3980,
    'PIC18F46J53': 0x58A0,
    'PIC10F320': 0x29A0,
    'PIC10F322': 0x2980,
    'PIC16LF722A': 0x1B60,
    'PIC18F95J94': 0x6300,
    'PIC16F677': 0x1440,
    'PIC16F676': 0x10E0,
    'PIC16LF19176': 0x309D,
    'PIC16LF15313': 0x30BF,
    'PIC16LF19175': 0x309B,
    'PIC18LF24J50': 0x4CC0,
    'PIC16LF18875': 0x306F,
    'PIC16LF18877': 0x3077,
    'PIC16LF18876': 0x3073,
    'PIC18F86J94': 0x6360,
    'PIC18F86J90': 0x5080,
    'PIC18F86J93': 0x50C0,
    'PIC18F1330': 0x1E20,
    'PIC18LF26J53': 0x5A20,
    'PIC18LF26J50': 0x4D00,
    'PIC18F86J99': 0x6340,
    'PIC18F47K42': 0x6BE0,
    'PIC16F785': 0x1200,
    'PIC18LF25J10': 0x1C40,
    'PIC18F27K40': 0x6960,
    'PIC16F1829LIN': 0x27E0,
    'PIC18LF26K80': 0x6200,
    'PIC18F4525': 0x0C40,
    'PIC16LF1823': 0x2820,
    'PIC16LF1825': 0x2860,
    'PIC16LF1824': 0x2840,
    'PIC16LF1827': 0x28A0,
    'PIC16LF1826': 0x2880,
    'PIC16LF1829': 0x28E0,
    'PIC16LF1828': 0x28C0,
    'PIC16LF1946': 0x2580,
    'PIC16LF1947': 0x25A0,
    'PIC16F777': 0x0DE0,
    'PIC16LF1939': 0x24C0,
    'PIC16LF1527': 0x15E0,
    'PIC18LF47K40': 0x69E0,
    'PIC18F87J10': 0x1760,
    'PIC18F87J11': 0x4520,
    'PIC12LF1840': 0x1BC0,
    'PIC12F1822': 0x2700,
    'PIC18LF46J11': 0x4EE0,
    'PIC18LF25K50': 0x5CA0,
    'PIC18LF46J13': 0x5BA0,
    'PIC18F85K22': 0x5360,
    'PIC16C771': 0x0B00,
    'PIC16F871': 0x0D20,
    'PIC18F45K42': 0x6C20,
    'PIC18F45K40': 0x6940,
    'PIC18F4431': 0x0880,
    'PIC16F1503': 0x2CE0,
    'PIC16F1507': 0x2D00,
    'PIC16F1509': 0x2D40,
    'PIC16F1508': 0x2D20,
    'PIC18F26K83': 0x6EC0,
    'PIC18F64J11': 0x3920,
    'PIC18F4610': 0x0C20,
    'PIC18F46K20': 0x2000,
    'PIC18F46K22': 0x5400,
    'PIC18LF25K22': 0x5560,
    'PIC18F4221': 0x2140,
    'PIC18F4220': 0x05A0,
    'PIC18F87J60': 0x1F60,
    'PIC16F15385': 0x30B6,
    'PIC18F96J99': 0x62C0,
    'PIC16F15386': 0x30B8,
    'PIC18F26J53': 0x5820,
    'PIC18F26J50': 0x4C40,
    'PIC18F6390': 0x0BA0,
    'PIC12LF1840T39A': 0x1BC0,
    'PIC18F25K80': 0x6180,
    'PIC16LF1902': 0x2C20,
    'PIC18F25K83': 0x6EE0,
    'PIC18F84J11': 0x39A0,
    'PIC18F66K22': 0x52C0,
    'PIC18LF24K42': 0x6DE0,
    'PIC18LF46K22': 0x5420,
    'PIC16LF15356': 0x30B1,
    'PIC16LF15355': 0x30AF,
    'PIC16LF15354': 0x30AD,
    'PIC18LF24J10': 0x1D40,
    'PIC18LF24J11': 0x4E40,
    'PIC18F14K50-ICD': 0x47A0,
    'PIC18F65J50': 0x4100,
    'PIC16LF18444': 0x30CF,
    'PIC16LF18445': 0x30D1,
    'PIC16LF18446': 0x30D5,
    'PIC12LF1840T48A': 0x1BC0,
    'PIC18F24J50': 0x4C00,
    'PIC12F635': 0x0FA0,
    'PIC18F66J94': 0x63E0,
    'PIC16F19176': 0x309C,
    'PIC16F19175': 0x309A,
    'PIC18F66J16': 0x4460,
    'PIC18F66J15': 0x1580,
    'PIC18F66J11': 0x4440,
    'PIC18F66J10': 0x1560,
    'PIC18F2420': 0x1140,
    'PIC18F2423': 0x1140,
    'PIC16F747': 0x0BE0,
    'PIC16F84A': 0x0560,
    'PIC18LF45J11': 0x4EC0,
    'PIC18LF25K40': 0x6A80,
    'PIC18LF55K42': 0x6D00,
    'PIC18LF24K22': 0x5660,
    'PIC18LF25K42': 0x6DC0,
    'PIC16LF1579': 0x3007,
    'PIC16LF1578': 0x3006,
    'PIC18F26K80': 0x6120,
    'PIC16LF1575': 0x3005,
    'PIC16LF1574': 0x3004,
    'PIC16LF1906': 0x2C60,
    'PIC16LF1907': 0x2C40,
    'PIC16LF1904': 0x2C80,
    'PIC16F737': 0x0BA0,
    'PIC16F639': 0x10A0,
    'PIC16LF1903': 0x2C00,
    'PIC18F13K50': 0x4740,
    'PIC16F636': 0x10A0,
    'PIC16F631': 0x1420,
    'PIC16F630': 0x10C0,
    'PIC18F67J60': 0x1F20,
    'PIC18F24K40': 0x69C0,
    'PIC18F65K22': 0x5300,
    'PIC16LF19197': 0x30A3,
    'PIC18LF46J50': 0x4D60,
    'PIC16F1823': 0x2720,
    'PIC16LF19196': 0x3087,
    'PIC16F1826': 0x2780,
    'PIC16F1827': 0x27A0,
    'PIC16F1824': 0x2740,
    'PIC16F1825': 0x2760,
    'PIC16F1828': 0x27C0,
    'PIC16F1829': 0x27E0,
    'PIC18LF44J50': 0x4D20,
    'PIC18F25K50': 0x5C20,
    'PIC18F8723': 0x4A20,
    'PIC18LF46J53': 0x5AA0,
    'PIC18F65J94': 0x6400,
    'PIC16F18856': 0x3070,
    'PIC18LF26J13': 0x5B20,
    'PIC18F97J60': 0x1FA0,
    'PIC16F18857': 0x3074,
    'PIC16F1765': 0x3081,
    'PIC16F1764': 0x3080,
    'PIC17C752': 0x02A0,
    'PIC16LF19155': 0x3097,
    'PIC16F18854': 0x306A,
    'PIC17C756': 0x0020,
    'PIC16LF723A': 0x1B40,
    'PIC12F683': 0x0460,
    'PIC16F1769': 0x3085,
    'PIC16F1768': 0x3084,
    'PIC18F8393': 0x1A20,
    'PIC16F15345': 0x30C8,
    'PIC16F15344': 0x30C4,
    'PIC18F65J10': 0x1520,
    'PIC18F65J11': 0x3960,
    'PIC18F65J15': 0x1540,
    'PIC16LF1619': 0x307F,
    'PIC18F45K80': 0x6160,
    'PIC16F913': 0x13E0,
    'PIC16F722A': 0x1B20,
    'PIC18LF45J50': 0x4D40,
    'PIC18F2680': 0x0EC0,
    'PIC18LF44K22': 0x5620,
    'PIC16LF1708': 0x3044,
    'PIC16LF1709': 0x3056,
    'PIC18F8680': 0x0A00,
    'PIC18F96J65': 0x1F80,
    'PIC18F4423': 0x10C0,
    'PIC16LF1703': 0x3063,
    'PIC16LF1704': 0x3045,
    'PIC16LF1705': 0x3057,
    'PIC16LF1707': 0x3062,
    'PIC16F1619': 0x307D,
    'PIC16F74': 0x0620,
    'PIC18F63J11': 0x3900,
    'PIC16F1613': 0x304C,
    'PIC18F4420': 0x10C0,
    'PIC16F1615': 0x307C,
    'PIC16F916': 0x13A0,
    'PIC18F85J94': 0x6380,
    'PIC18LF44J10': 0x1D60,
    'PIC16F917': 0x1380,
    'PIC18F85J90': 0x38E0,
    'PIC16F877A': 0x0E20,
    'PIC12F675': 0x0FC0,
    'PIC12HV609': 0x2280,
    'PIC18F27J53': 0x5860,
    'PIC16F18425': 0x30CC,
    'PIC16F73': 0x0600,
    'PIC18LF44J11': 0x4EA0,
    'PIC18C658': 0x00A0,
    'PIC18F47J13': 0x59E0,
    'PIC18F8390': 0x0B80,
    'PIC16LF15323': 0x30C1,
    'PIC16LF15324': 0x30C3,
    'PIC16LF15325': 0x30C7,
    'PIC16LF707': 0x1AE0,
    'PIC18F26K40': 0x6980,
    'PIC18F26K42': 0x6C60,
    'PIC18LF66K40': 0x6B40,
    'PIC16F946': 0x1460,
    'PIC16F18323': 0x3067,
    'PIC16F18324': 0x303A,
    'PIC16F18325': 0x303E,
    'PIC16F18326': 0x30A4,
    'PIC18F2610': 0x0CA0,
    'PIC18LF46K80': 0x61E0,
    'PIC18F2510': 0x1120,
    'PIC16F1717': 0x305C,
    'PIC16LF1847': 0x14A0,
    'PIC18F67K40': 0x6AC0,
    'PIC18F1320': 0x07C0,
    'PIC16F1947': 0x2520,
    'PIC16F1946': 0x2500,
    'PIC16F1713': 0x3049,
    'PIC16F882': 0x2000,
    'PIC16F883': 0x2020,
    'PIC18F252': 0x0400,
    'PIC16F886': 0x2060,
    'PIC16F887': 0x2080,
    'PIC16F884': 0x2040,
    'PIC18F258': 0x0840,
    'PIC16LF1526': 0x15C0,
    'PIC16LF1938': 0x24A0,
    'PIC16LF1937': 0x2480,
    'PIC16LF1936': 0x2460,
    'PIC16F707': 0x1AC0,
    'PIC16LF1934': 0x2440,
    'PIC16LF1933': 0x2400,
    'PIC18F4450': 0x2400,
    'PIC18LF26K83': 0x6F00,
    'PIC18F6393': 0x1A00,
    'PIC18F14K50': 0x4760,
    'PIC18F4455': 0x1220,
    'PIC18F67J94': 0x63A0,
    'PIC18F4458': 0x2A20,
    'PIC16F1618': 0x3079,
    'PIC18F86J72': 0x5040,
    'PIC18F6490': 0x06A0,
    'PIC16F688': 0x1180,
    'PIC18F6493': 0x0E00,
    'PIC18F25Q10': 0x71A0,
    'PIC18F8720': 0x0600,
    'PIC18F8722': 0x1420,
    'PIC16F876A': 0x0E00,
    'PIC16LF19156': 0x3099,
    'PIC18LF27J13': 0x5B60,
    'PIC16F684': 0x1080,
    'PIC18F87J94': 0x6320,
    'PIC18F2682': 0x2700,
    'PIC18F2685': 0x2720,
    'PIC18F87J93': 0x50E0,
    'PIC18F87J90': 0x50A0,
    'PIC16F685': 0x04A0,
    'PIC18LF26K22': 0x5460,
    'PIC18F85J50': 0x41A0,
    'PIC16F1718': 0x305B,
    'PIC16F1719': 0x305A,
    'PIC18F85K90': 0x52A0,
    'PIC16F1716': 0x3048,
    'PIC17C762': 0x01A0,
    'PIC16F1579': 0x3003,
    'PIC17C766': 0x0120,
    'PIC16F18445': 0x30D0,
    'PIC16F18444': 0x30CE,
    'PIC16F18446': 0x30D4,
    'PIC18F55K42': 0x6BC0,
    'PIC18F87J72': 0x5060,
    'PIC18F27J13': 0x5960,
    'PIC18F47J53': 0x58E0,
    'PIC18F45K20': 0x2040,
    'PIC18C452': 0x0200,
    'PIC18F4510': 0x10A0,
    'PIC18LF13K22': 0x4F80,
    'PIC16C717': 0x0AC0,
    'PIC18LF47J13': 0x5BE0,
    'PIC18C242': 0x0320,
    'PIC18F46K42': 0x6C00,
    'PIC18F46K40': 0x6920,
    'PIC16LF18456': 0x30DA,
    'PIC16LF18455': 0x30D8,
    'PIC18C442': 0x0300,
    'PIC18F2331': 0x08E0,
    'PIC12F629': 0x0F80,
    'PIC18F2221': 0x2160,
    'PIC18F2220': 0x0580,
    'PIC18LF65K40': 0x6B60,
    'PIC18LF45K22': 0x5520,
    'PIC16LF1788': 0x302D,
    'PIC16F753': 0x3030,
    'PIC18F2410': 0x1160,
    'PIC16F690': 0x1400,
    'PIC18LF47K42': 0x6D20,
    'PIC18F14K22': 0x4F20,
    'PIC18F45K22': 0x5500,
    'PIC18C801': 0x0100,
    'PIC16LF723': 0x1960,
    'PIC16LF1566': 0x3046,
    'PIC16LF1567': 0x3047,
    'PIC16LF18857': 0x3076,
    'PIC16LF18856': 0x3072,
    'PIC16LF18855': 0x306E,
    'PIC16LF18854': 0x306B,
    'PIC18F4515': 0x0C60,
    'PIC16F628': 0x07C0,
    'PIC18LF25J50': 0x4CE0,
    'PIC18F66J50': 0x4140,
    'PIC16F627': 0x07A0,
    'PIC12LF1552': 0x2BC0,
    'PIC18LF26J11': 0x4E80,
    'PIC18LF25K80': 0x6260,
    'PIC18LF25K83': 0x6F20,
    'PIC18F2480': 0x1AE0,
    'PIC18F25K40': 0x69A0,
    'PIC18F25K42': 0x6C80,
    'PIC18F452': 0x0420,
    'PIC16LF1782': 0x2AA0,
    'PIC16LF1783': 0x2AC0,
    'PIC16F1574': 0x3000,
    'PIC16F1575': 0x3001,
    'PIC16LF1786': 0x2B00,
    'PIC16LF1787': 0x2B20,
    'PIC16F1578': 0x3002,
    'PIC16LF15385': 0x30B7,
    'PIC16LF15386': 0x30B9,
    'PIC16F870': 0x0D00,
    'PIC16F877': 0x09A0,
    'PIC16F876': 0x09E0,
    'PIC16F874': 0x0920,
    'PIC18LF67K40': 0x6B20,
    'PIC18F97J94': 0x62A0,
    'PIC18F2550': 0x1240,
    'PIC18F2553': 0x2A40,
    'PIC18F47K40': 0x6900,
    'PIC18F4523': 0x1080,
    'PIC18F4520': 0x1080,
    'PIC18F24K20': 0x20A0,
    'PIC18F96J60': 0x1840,
    'PIC16F1455': 0x3021,
    'PIC16F1454': 0x3020,
    'PIC18F86J55': 0x4200,
    'PIC16F1459': 0x3023,
    'PIC16F1458': 0x3022,
    'PIC16F15356': 0x30B0,
    'PIC16F15354': 0x30AC,
    'PIC16F15355': 0x30AE,
    'PIC18F4480': 0x1AA0,
    'PIC18F65K40': 0x6B00,
    'PIC18F1220': 0x07E0,
    'PIC12LF1822': 0x2800,
    'PIC12F1840': 0x1B80,
    'PIC18LF45K80': 0x6240,
    'PIC18F4553': 0x2A00,
    'PIC18F24K42': 0x6CA0,
    'PIC18F4550': 0x1200,
    'PIC18F65J90': 0x3860,
    'PIC18F6680': 0x0A20,
    'PIC18F4410': 0x10E0,
    'PIC16HV785': 0x1220,
    'PIC16LF18323': 0x3069,
    'PIC16C770': 0x0AE0,
    'PIC16LF18325': 0x3040,
    'PIC16LF18324': 0x303C,
    'PIC16LF18326': 0x30A6,
    'PIC12HV752': 0x1520,
    'PIC18F45Q10': 0x7140,
    'PIC18F4320': 0x0520,
    'PIC18F4321': 0x2100,
    'PIC18LF46K50': 0x5D40,
    'PIC18F67J90': 0x5020,
    'PIC18F67J93': 0x5060,
    'PIC18F63J90': 0x3800,
    'PIC18F45J10': 0x1C20,
    'PIC18F45J11': 0x4E00,
    'PIC18F85J10': 0x15E0,
    'PIC18F85J11': 0x39E0,
    'PIC18F8621': 0x0A80,
    'PIC16F1614': 0x3078,
    'PIC18LF46K42': 0x6D40,
    'PIC18F87K22': 0x51C0,
    'PIC18LF46K40': 0x6A00,
    'PIC18F8622': 0x13A0,
    'PIC18F4439': 0x04A0,
    'PIC18F26K50': 0x5D20,
    'PIC16F648A': 0x1100,
    'PIC16LF18426': 0x30D3,
    'PIC18F8627': 0x13E0,
    'PIC16LF18424': 0x30CB,
    'PIC16LF18425': 0x30CD,
    'PIC16F873A': 0x0E40,
    'PIC18F44J10': 0x1D20,
    'PIC16LF19186': 0x30BD,
    'PIC16LF19185': 0x30BC,
    'PIC18F85J15': 0x1700,
    'PIC12F1501': 0x2CC0,
    'PIC16F18313': 0x3066,
    'PIC16LF1784': 0x2AE0,
    'PIC16F19155': 0x3096,
    'PIC16F19156': 0x3098,
}

device_lookup = {
    (0x62, 0x00): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x01): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x63, 0x02): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x63, 0x11): {'id_shift': 5, 'fuses': 'pic_fuses'},

    (0x63, 0x12): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x14): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x17): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x20): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x63, 0x21): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x63, 0x22): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x63, 0x23): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x34): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x37): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x41): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x42): {'id_shift': 5, 'fuses': 'pic_fuses'},
    # (0x63, 0x54): {'id_shift': 5, 'fuses': 'pic_fuses', 'name': '"PIC16F818/9"'},
    (0x63, 0x54): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x63, 0x61): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x63, 0x62): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x63, 0x73): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0x81): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x63, 0x82): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x63, 0x91): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x63, 0x92): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x63, 0xA4): {'fuses': 'pic_fuses'},
    (0x63, 0xB3): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0xC4): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x63, 0xC7): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x64, 0x01): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x64, 0x02): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x64, 0x11): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x64, 0x12): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x65, 0x00): {'fuses': 'pic_fuses'},
    (0x65, 0x04): {'fuses': 'pic_fuses'},
    (0x65, 0x05): {'fuses': 'pic_fuses'},
    (0x65, 0x13): {'fuses': 'pic_fuses'},
    (0x65, 0x16): {'fuses': 'pic_fuses'},
    (0x65, 0x23): {'fuses': 'pic_fuses'},
    (0x66, 0x01): {'fuses': 'pic_fuses'},
    (0x66, 0x02): {'fuses': 'pic_fuses'},
    (0x66, 0x03): {'fuses': 'pic_fuses'},
    (0x66, 0x04): {'fuses': 'pic_fuses'},
    (0x66, 0x07): {'fuses': 'pic_fuses'},
    (0x66, 0x13): {'fuses': 'pic_fuses'},
    (0x66, 0x17): {'fuses': 'pic_fuses'},
    (0x66, 0x23): {'fuses': 'pic_fuses'},

    (0x71, 0x00): {'fuses': 'avr2_fuses'},
    (0x71, 0x01): {'fuses': 'avr_fuses'},
    (0x71, 0x0A): {'fuses': 'avr3_fuses'},
    (0x71, 0x20): {'fuses': 'avr2_fuses'},
    (0x71, 0x21): {'fuses': 'avr_fuses'},
    (0x71, 0x22): {'fuses': 'avr2_fuses'},
    (0x71, 0x2A): {'fuses': 'avr3_fuses'},
    (0x71, 0x43): {'fuses': 'avr2_fuses'},
    (0x71, 0x44): {'fuses': 'avr_fuses'},
    (0x71, 0x48): {'fuses': 'avr3_fuses'},
    (0x71, 0x49): {'fuses': 'avr3_fuses'},
    (0x71, 0x61): {'fuses': 'avr_fuses'},
    (0x71, 0x6B): {'fuses': 'avr3_fuses'},
    (0x71, 0x85): {'fuses': 'avr2_fuses'},
    (0x73, 0x10): {'fuses': 'avr2_fuses'},
    (0x73, 0x12): {'fuses': 'avr2_fuses'},

    (0x17, 0x00): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x01): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x18, 0x02): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x18, 0x11): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x12): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x14): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x17): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x20): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x18, 0x21): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x18, 0x22): {'id_shift': 4, 'fuses': 'pic_fuses'},
    (0x18, 0x23): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x34): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x37): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x41): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x42): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x54): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x18, 0x61): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x18, 0x62): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x18, 0x73): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0x81): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x18, 0x82): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x18, 0x91): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x18, 0x92): {'id_shift': 5, 'fuses': 'pic2_fuses'},
    (0x18, 0xA4): {'fuses': 'pic_fuses'},
    (0x18, 0xB3): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0xC4): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x18, 0xC7): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x19, 0x01): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x19, 0x02): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x19, 0x11): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x19, 0x12): {'id_shift': 5, 'fuses': 'pic_fuses'},
    (0x1A, 0x00): {'fuses': 'pic_fuses'},
    (0x1A, 0x04): {'fuses': 'pic_fuses'},
    (0x1A, 0x05): {'fuses': 'pic_fuses'},
    (0x1A, 0x13): {'fuses': 'pic_fuses'},
    (0x1A, 0x16): {'fuses': 'pic_fuses'},
    (0x1A, 0x23): {'fuses': 'pic_fuses'},
    (0x1B, 0x01): {'fuses': 'pic_fuses'},
    (0x1B, 0x02): {'fuses': 'pic_fuses'},
    (0x1B, 0x03): {'fuses': 'pic_fuses'},
    (0x1B, 0x04): {'fuses': 'pic_fuses'},
    (0x1B, 0x07): {'fuses': 'pic_fuses'},
    (0x1B, 0x13): {'fuses': 'pic_fuses'},
    (0x1B, 0x17): {'fuses': 'pic_fuses'},
    (0x1B, 0x23): {'fuses': 'pic_fuses'},

    (0x1D, 0x00): {'fuses': 'avr2_fuses'},
    (0x1D, 0x01): {'fuses': 'avr_fuses'},
    (0x1D, 0x0A): {'fuses': 'avr3_fuses'},
    (0x1D, 0x20): {'fuses': 'avr2_fuses'},
    (0x1D, 0x21): {'fuses': 'avr_fuses'},
    (0x1D, 0x22): {'fuses': 'avr2_fuses'},
    (0x1D, 0x2A): {'fuses': 'avr3_fuses'},
    (0x1D, 0x43): {'fuses': 'avr2_fuses'},
    (0x1D, 0x44): {'fuses': 'avr_fuses'},
    (0x1D, 0x48): {'fuses': 'avr3_fuses'},
    (0x1D, 0x49): {'fuses': 'avr3_fuses'},
    (0x1D, 0x61): {'fuses': 'avr_fuses'},
    (0x1D, 0x6B): {'fuses': 'avr3_fuses'},
    (0x1D, 0x85): {'fuses': 'avr2_fuses'},
    (0x1E, 0x10): {'fuses': 'avr2_fuses'},
    (0x1E, 0x12): {'fuses': 'avr2_fuses'},
}

write_unlock_lookup = {
    0x0000: 0x0002,
    0x0001: 0x0002,
    0x0002: 0x0002,
    0x0003: 0x0002,
    0x0004: 0x0003,
    0x0005: 0x0003,
    0x0006: 0x0003,
    0x0007: 0x0003,
    0x0008: 0x0003,
    0x0009: 0x0003,
    0x000A: 0x0003,
    0x000B: 0x0003,
    0x000C: 0x0003,
    0x000D: 0x0002,
    0x000E: 0x0002,
    0x000F: 0x0003,
    0x0010: 0x0002,
    0x0011: 0x0001,
    0x0012: 0x0001,
    0x0013: 0x0002,
    0x0014: 0x0001,
    0x0015: 0x0003,
    0x0016: 0x0003,
    0x0017: 0x0001,
    0x0018: 0x00A4,
    0x0019: 0x0001,
    0x001A: 0x0001,
    0x001B: 0x0001,
    0x001C: 0x0096,
    0x001D: 0x006D,
    0x001E: 0x0074,
    0x001F: 0x0075,
    0x4E20: 0x0001,
    0x0021: 0x0001,
    0x0022: 0x0001,
    0x0023: 0x0001,
    0x0024: 0x0001,
    0x0025: 0x0001,
    0x0026: 0x0001,
    0x0027: 0x0001,
    0x0028: 0x0001,
    0x0029: 0x0001,
    0x002A: 0x00E0,
    0x002B: 0x00CF,
    0x002C: 0x0074,
    0x002D: 0x0001,
    0x002E: 0x0001,
    0x002F: 0x0001,
    0x0030: 0x0001,
    0x0031: 0x0001,
    0x0032: 0x0001,
    0x0033: 0x0001,
    0x0034: 0x00A6,
    0x0035: 0x007F,
    0x0036: 0x0001,
    0x0037: 0x0001,
    0x0038: 0x0001,
    0x0039: 0x00CF,
    0x003A: 0x0001,
    0x003B: 0x0001,
    0x003C: 0x0001,
    0x003D: 0x0001,
    0x003E: 0x0001,
    0x003F: 0x0148,
    0x0040: 0x01BA,
    0x0041: 0x0001,
    0x0042: 0x0001,
    0x0043: 0x0001,
    0x0044: 0x0001,
    0x0045: 0x0001,
    0x0046: 0x0154,
    0x0047: 0x019B,
    0x0048: 0x01DF,
    0x0049: 0x011E,
    0x004A: 0x01BA,
    0x004B: 0x01E7,
    0x004C: 0x004E,
    0x004D: 0x011B,
    0x004E: 0x0198,
    0x004F: 0x0025,
    0x0050: 0x0013,
    0x0051: 0x00BF,
    0x0052: 0x0001,
    0x0053: 0x0115,
    0x0054: 0x0198,
    0x0055: 0x0118,
    0x0056: 0x011E,
    0x0057: 0x0139,
    0x0058: 0x01E0,
    0x0059: 0x008F,
    0x005A: 0x01D6,
    0x005B: 0x00F1,
    0x005C: 0x0167,
    0x005D: 0x000D,
    0x005E: 0x0001,
    0x005F: 0x0001,
    0x0060: 0x01FF,
    0x0061: 0x00F1,
    0x0062: 0x0100,
    0x0063: 0x00D7,
    0x0064: 0x0005,
    0x0065: 0x0083,
    0x0066: 0x000D,
    0x0067: 0x0001,
    0x0068: 0x0041,
    0x0069: 0x01FF,
    0x006A: 0x0001,
    0x006B: 0x0100,
    0x006C: 0x0090,
    0x006D: 0x000A,
    0x006E: 0x0077,
    0x006F: 0x000A,
    0x0070: 0x0001,
    0x0071: 0x0021,
    0x0072: 0x01FF,
    0x0073: 0x0031,
    0x0074: 0x0100,
    0x0075: 0x0101,
    0x0076: 0x000E,
    0x0077: 0x00D0,
    0x0078: 0x000A,
    0x0079: 0x0001,
    0x007A: 0x0005,
    0x007B: 0x01FF,
    0x0080: 0x00FB,
    0x0081: 0x0001,
    0x0082: 0x0001,
    0x0083: 0x0003,
    0x0084: 0x0135,
    0x0085: 0x0002,
    0x0086: 0x00DD,
    0x0087: 0x0002,
    0x0088: 0x0005,
    0x0089: 0x0001,
    0x008A: 0x0001,
    0x008B: 0x000D,
    0x008C: 0x0005,
    0x008D: 0x00B1,
    0x008E: 0x0002,
    0x008F: 0x0062,
    0x0090: 0x0002,
    0x0091: 0x000A,
    0x0898: 0x01A2,
    0x186A0: 0x01FF,
    0x0020: 0x0001,
    0x00C8: 0x003E,
    0x2710: 0x0001,
    0x0320: 0x0015,
    0x1770: 0x009A,
    0x1388: 0x0034,
    0x0BB8: 0x01D3,
    0x05DC: 0x0001,
    0x03E8: 0x0002,
    0x01F4: 0x000D,
}

def print_entry(ic, fd):
    try:
        chip_id = int(ic['chip_id'], 16)
    except ValueError:
        chip_id = 0

    write_unlock = write_unlock_lookup.get(ic['opts3'], 0x00)

    if (ic['protocol_id'], ic['variant']) in device_lookup:
        extras = device_lookup[(ic['protocol_id'], ic['variant'])]
        for key, value in extras.items():
            ic[key] = value

    if ic['name'].startswith('PIC') and ic['name'].split()[0] in pic_devid_lookup:
        if int(ic['chip_id_bytes_count']) > 0:
            if 'id_shift' not in ic:
                print('Missing "id_shift" for {}'.format(ic['name']))
                return
            chip_id = pic_devid_lookup[ic['name'].split()[0]] >> ic['id_shift']

    print("{", file=fd)
    print('\t.name = "{}",'.format(ic['name'].strip()), file=fd)
    print('\t.protocol_id = 0x{:02X},'.format(ic['protocol_id']), file=fd)
    print('\t.variant = 0x{:02X},'.format(ic['variant']), file=fd)
    print('\t.read_buffer_size = 0x{:04X},'.format(ic['read_buffer_size']), file=fd)
    print('\t.write_buffer_size = 0x{:04X},'.format(ic['write_buffer_size']), file=fd)
    print('\t.code_memory_size = 0x{:04X},'.format(ic['code_memory_size']), file=fd)
    print('\t.data_memory_size = 0x{:04X},'.format(ic['data_memory_size']), file=fd)
    print('\t.data_memory2_size = 0x{:04X},'.format(ic['data_memory2_size']), file=fd)
    print('\t.chip_id = 0x{:04X},'.format(chip_id), file=fd)
    print('\t.chip_id_bytes_count = 0x{:02X},'.format(ic['chip_id_bytes_count']), file=fd)
    print('\t.opts1 = 0x{:04X},'.format(ic['opts1']), file=fd)
    print('\t.opts2 = 0x{:04X},'.format(ic['opts2']), file=fd)
    print('\t.opts3 = 0x{:04X},'.format(ic['opts3']), file=fd)
    print('\t.opts4 = 0x{:04X},'.format(ic['opts4']), file=fd)
    print('\t.package_details = 0x{:08X},'.format(ic['package_details']), file=fd)
    print('\t.write_unlock = 0x{:04X},'.format(write_unlock), file=fd)
    if 'id_shift' in ic:
        print('\t.id_shift = {},'.format(ic['id_shift']), file=fd)
    if 'fuses' in ic:
        print('\t.fuses = {},'.format(ic['fuses']), file=fd)
    print("},", file=fd)

def main():
    chips = set()
    dups = 0

    parser = argparse.ArgumentParser()
    parser.add_argument("--json", dest="json", help="JSON dump of InfoIC(2Plus).dll", required=True)
    parser.add_argument("--output", dest="output", help="Output filename", type=argparse.FileType('w'), default=sys.stdout)

    args = parser.parse_args()

    with open(args.json) as f:
        json_database = json.load(f)

    print('''
/*
 * {} - Device names and characteristics.
 *
 * This file is a part of Minipro.
 *
 * Minipro is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Minipro is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

/* Note, this file really isn't copyrightable. */
'''.format(args.output.name), file=args.output)
    for mf in json_database:
        for ic in mf['ics']:
            if ic['name'] in chips:
                #print("Skipping duplicate IC {}".format(ic['name']), file=sys.stderr)
                dups += 1
            else:
                chips.add(ic["name"])
                print_entry(ic, args.output);
    print("{} duplicates found".format(dups), file=sys.stderr)


if __name__ == "__main__":
    main()
