#include "../mix/net.h"
#include "../mix/mix.h"

#ifdef DARWIN
#include <netdb.h>
#endif

int
isip(char *ip)
{
  int a, b, c, d;

  if (!sscanf(ip, "%d.%d.%d.%d", &a, &b, &c, &d))
    return 0;
  if (a < 1)
    return 0;
  if (a > 255)
    return 0;
  if (b < 0)
    return 0;
  if (b > 255)
    return 0;
  if (c < 0)
    return 0;
  if (c > 255)
    return 0;
  if (d < 0)
    return 0;
  if (d > 255)
    return 0;
  return 1;
}

unsigned long
resolve(char *host)
{
  struct hostent *he;
  struct sa tmp;

  if (isip(host))
    return (inet_addr(host));
  he = gethostbyname(host);
  if (he)
    {
      memcpy(&tmp.add, he->h_addr, he->h_length);
    }
  else
    return (0);
  return (tmp.add);
}

char *
ntoa(unsigned int in)
{
  struct in_addr ad;

  ad.s_addr = in;
  return (inet_ntoa(ad));
}

/* I am RFC1071 compliant... :P */

unsigned short
sum(unsigned short *buf, int nwords)
{
  unsigned long sum;

  for (sum = 0; nwords > 0; nwords--)
    sum += *buf++;
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  return ~sum;
}

/* I am RFC793 compliant... */

void 
tcpsum(char *ippacket, struct lmip *ih, struct lmtcp *tch, int tot_len)
{
  char *pbuf = NEW(char, bufsize - 52);
  struct pseudo
    {
      long src, dst;
      u8 mbz, pro, len;
    };
  struct pseudo *ph = (struct pseudo *) pbuf;

  memset(pbuf, 0, bufsize - 52);
  ph->src = ih->src;
  ph->dst = ih->dst;
  ph->mbz = 0;
  ph->pro = P_TCP;
  ph->len = htons(tot_len - M_IP);
  tch->sum = 0;
  memcpy(pbuf + 12, ippacket + M_IP, tot_len - M_IP);
  tch->sum = sum((u16 *) pbuf, ((tot_len - M_IP) + 12) >> 1);
  MDELETE(pbuf);
}

int
incip(char *ip)
{
  int a, b, c, d;

  sscanf(ip, "%d.%d.%d.%d", &a, &b, &c, &d);

  if (a >= 255)
    return 0;
  if (b >= 255)
    {
      b = 0;
      a++;
    }
  if (c >= 255)
    {
      c = 0;
      b++;
    }
  if (d >= 255)
    {
      d = 0;
      c++;
    }
  else d++;

  sprintf(ip, "%d.%d.%d.%d", a, b, c, d);

  return 1;
}

int
decip(char *ip)
{
  int a, b, c, d;

  sscanf(ip, "%d.%d.%d.%d", &a, &b, &c, &d);

  if (a <= 0)
    return 0;
  if (b <= 0)
    {
      b = 255;
      a++;
    }
  if (c <= 0)
    {
      c = 255;
      b++;
    }
  if (d <= 0)
    {
      d = 255;
      c++;
    }

  d--;

  sprintf(ip, "%d.%d.%d.%d", a, b, c, d);

  return 1;
}

int
rawsock(int protocol)
{
  int one = 1, fd = socket(PF_INET, SOCK_RAW, protocol);
  const int *val = &one;

  if (fd < 0)
    return -1;
  else if (setsockopt(fd, P_IP, MY_HDRINCL, val, sizeof(one)) < 0)
    {
      close(fd);
      return -1;
    }
  return fd;
}

int
psock(void)
{
#ifdef SOCK_PACKET
  return socket(PF_INET, SOCK_PACKET, htons(ETHALL));
#else
  /* D'oh */
  return rawsock(P_RAW);
#endif
}

unsigned int inet_gethostaddr (void)
{
char hn[128];
unsigned int res = 0;
gethostname (hn, 128);
res = resolve(hn);
return res;
}

unsigned int
inet_local(void)
{
  int fd;
  int one = 1, myport = getrandom(0, 65535), pid = 0, i = 0;
  unsigned int myhost = getrandom(0, 65535) + (getrandom(0, 65535) << 8);
  char packet[8192];
  struct sa s;
  struct lmip *ih = (struct lmip *) (packet + M_ETH);
  struct lmtcp *th = (struct lmtcp *) (packet + M_ETH + M_IP);

  signal (SIGCHLD, SIG_IGN);
  if (!(pid = fork()))
    {
      signal (SIGCHLD, SIG_IGN);
#ifndef DARWIN
      setpgid(0, getpgid(0)+1);
#endif
      sleep (1);
      fd = socket(AF_INET, SOCK_STREAM, 0);
      s.fam = AF_INET;
      s.dp = htons(myport);
      s.add = myhost;
      usleep(500000);
      alarm(30);
      (void) connect(fd, (struct sockaddr *) &s, M_SIN);
      close(fd);
      sleep(1);
      exit(0);
      raise(9);
    }

  fd = psock();
  for (i = 0; i < 1024; i++)
    {
      memset(packet, 0, 8192);
      if ((one = read(fd, packet, 8192)) > 0)
	{
	  if ((myhost == ih->dst) && (myport == ntohs(th->dst)))
	    {
	      kill(pid, 9);
	      return ih->src;
	    }
	}
    }

  kill(pid, 9);
  return 0;
}

void
ethdst(struct eth *eh, char *addr)
{
  (void) sscanf(addr, "%02x:%02x:%02x:%02x:%02x:%02x",
	      (int *) &eh->dst[0], (int *) &eh->dst[1], (int *) &eh->dst[2],
	     (int *) &eh->dst[3], (int *) &eh->dst[4], (int *) &eh->dst[5]);
}

void
ethsrc(struct eth *eh, char *addr)
{
  (void) sscanf(addr, "%02x:%02x:%02x:%02x:%02x:%02x",
	      (int *) &eh->src[0], (int *) &eh->src[1], (int *) &eh->src[2],
	     (int *) &eh->src[3], (int *) &eh->src[4], (int *) &eh->src[5]);
}
