//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                  Network Security Analysis Tool                          //
//                pidalloc.cpp - process allocation                         //
//                                                                          //
//   Copyright (C) 1999-2002 by Mixter and 2xs ltd. <mixter@2xs.co.il>      //
//                                                                          //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
//                                                                          //
// This program is distributed in the hope that it will be useful,          //
// but WITHOUT ANY WARRANTY; without even the implied warranty of           //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
// GNU General Public License for more details.                             //
//                                                                          //
// You should have received a copy of the GNU General Public License        //
// along with this program; if not, write to the Free Software              //
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// these nice easy functions are responsible for core
// process stability and need to succeed every time

#include "pidalloc.h"
#pragma implementation "pidalloc"

#ifdef EBUG
extern ofstream dbug;

#endif

#ifdef NSAT_PTHREADS
void*
scan (void *hostv)
#else
void
scan (char *hostv)
#endif
{
  char *host = (char*)hostv;
#ifdef EBUG
  dbug.close();
  char buf[256];

  snprintf(buf, 255, "debug.%d.log", getpid());
  dbug.open(buf, 8);
  dbug << "NewChild " << " scanning " << host << ENTER;
#endif

  SockSet scan;

  scan.con(host);
  pthread_exit(NULL);

#ifdef NSAT_PTHREADS
  return NULL;
#endif
}

void
distrib_alloc(unsigned int addr)
{
 static long int i = 0;
#ifdef EBUG
  dbug << "DScan #" << i << " - " << ntoa(addr) << "\n";
#endif

 Master->SendRequests(1, &addr);

 if((i > 1) && !(i % Master->concount))
  Master->GetResponses();

 i++;
}

int
alloc_scan(char *host)
{
  int i;

  if ((strlen(pi.xname)) && (excluded(resolve(host))))
   {
    if ((!pi.stealth) && (pi.Foreground))
      cout << " [*] skipping excluded host " << host << ENTER;
    return 0;
   }

  if (pi.dist == 2)
   {
    distrib_alloc(resolve(host));
    return 1;
   }

  if (pi.stealth)
    while (!sysidle(pi.idle))
      {
	alloc_purge();
	sleep(pi.idle);
      }

cheap_trick:
  // find a free pid slot
  for (i = 0; i <= pi.maxproc; i++)
    {
      if (pidtable[i] == 0)
	break;
#ifdef EBUG
      dbug << "pidslot " << i << " occupied (" << pidtable[i] << ")...\n";
#endif
    }

  if (i >= pi.maxproc)
    {
#ifdef EBUG
      dbug << "all process slots occupied, purging...\n";
#endif
      sleep(pi.maxlife / 2);
      alloc_purge();
      goto cheap_trick;
    }

  timetable[i] = pi.tstamp;

#ifdef NSAT_PTHREADS
  pthread_t tmpid;
  pthread_attr_t tmpat;

  pthread_attr_init (&tmpat);
  pthread_attr_setdetachstate (&tmpat, PTHREAD_CREATE_DETACHED);
  fprintf(stderr, "THREADING!!!\n");
  pidtable[i] = (0 != pthread_create(&tmpid, &tmpat, scan, host));
#else
  fprintf(stderr, "FORKING!!!\n");
  pidtable[i] = safe_fork();

  if (!pidtable[i])
    {
      rlmax();
      scan(host);
      raise(SIGKILL);
      return (0);
    }
#endif

  return (pidtable[i]);
}

void
alloc_purge(void)
{
  int i;

  for (i = 0; i <= pi.maxproc; i++)
    if (pidtable[i] != 0)	// unf, purge, unf, purge, unf, purge ...

      {
#ifdef EBUG
	dbug << "pid " << pidtable[i] << " active\n";
#endif
	errno = 0;
#ifdef NSAT_PTHREADS
	if((pi.tstamp - timetable[i]) > pi.maxlife)
	{
		pidtable[i] = 0;
	}
#else
	if (kill(pidtable[i], SIGALRM) == -1)
	  pidtable[i] = 0;	// purged (process exited)

	else if ((pi.tstamp - timetable[i]) > pi.maxlife)
	  {
#ifdef EBUG
	    dbug << "pid " << pidtable[i] << " purged: " <<
	      (pi.tstamp - timetable[i]) << "sec \n";
#endif
	    kill(pidtable[i], SIGTERM);
	    usleep(500);
	    kill(pidtable[i], SIGKILL);
	    pidtable[i] = 0;	// purged (process killed)

	  }
#endif
      }

 return;
}

