#! /bin/sh
# Do not edit this file!
# this file is generated by 'generate_test.pl'.

#
# Test idn_checkname().
# NAME is not a valid IDN.
#
#             api: command
#  local_encoding: U-escape
#         command: ./test_api_checkname ..
#          output: idn_checkname() ERROR: label length check failed
#        exitcode: 0

################## setup ##################

unset LC_ALL
unset LC_CTYPE
unset LC_MESSAGES
unset LANG
unset IDN_LOCAL_CODESET
unset IDN_LOG_LEVEL

SRCDIR=`dirname $0`
SYSCONFDIR=${SYSCONFDIR-"/etc"}
IGNORE=false
export IDN_LOCAL_CODESET; IDN_LOCAL_CODESET=U-escape

rm -f idn2.conf
touch idn2.conf
rm -f localmap1
rm -f localmap2
rm -f localmap3
rm -f localmap4
rm -f localset
rm -f expect.txt
rm -f output.txt

################## test ##################

echo 'idn_checkname() ERROR: label length check failed' >> expect.txt
echo 'exitcode=0' >> expect.txt
rm -f input.txt
touch input.txt
cat input.txt | ./test_api_checkname .. > output.txt 2>&1
echo 'exitcode='$? >> output.txt
rm -f input.txt

################## teardown ##################

cmp expect.txt output.txt > /dev/null 2>&1
RESULT=$?
[ X$IGNORE = Xtrue ] && RESULT=77
if [ X$QUIET != Xtrue ]; then
    if [ $RESULT -eq 0 ]; then
        echo "PASS: $0"
    elif [ $RESULT -eq 77 ]; then
        echo "SKIP: $0"
    else
        echo "FAIL: $0"
    fi
fi
[ $RESULT -eq 0 -o $RESULT -eq 77 ] || exit $RESULT
rm -f idn2.conf
rm -f localmap1
rm -f localmap2
rm -f localmap3
rm -f localmap4
rm -f localset
rm -f expect.txt
rm -f output.txt
exit $RESULT
