/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.BitmapGlyphState;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.transformer.BoldBitmapFontGlyphTransformer;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BitmapGlyphTransform {
    private static final int CTRL_SHIFT = CommonMenuItems.SHORTCUT_KEY | 1;
    public static final BitmapGlyphTransform[] TRANSFORMS = new BitmapGlyphTransform[]{new Bold("Bold", CTRL_SHIFT, 66), new Invert("Invert", CTRL_SHIFT, 78), new FlipHorizontal("Flip Horizontal", CTRL_SHIFT, 72), new FlipVertical("Flip Vertical", CTRL_SHIFT, 74), null, new Nudge(-1, 0, "Nudge Left", CTRL_SHIFT, 37), new Nudge(1, 0, "Nudge Right", CTRL_SHIFT, 39), new Nudge(0, -1, "Nudge Up", CTRL_SHIFT, 38), new Nudge(0, 1, "Nudge Down", CTRL_SHIFT, 40)};
    public final String name;
    public final KeyStroke keystroke;

    public BitmapGlyphTransform(String string, int n, int n2) {
        this.name = string;
        this.keystroke = KeyStroke.getKeyStroke(n2, n);
    }

    public abstract void transform(Font<BitmapFontGlyph> var1, BitmapFontGlyph var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Nudge
    extends BitmapGlyphTransform {
        private final int dx;
        private final int dy;

        public Nudge(int n, int n2, String string, int n3, int n4) {
            super(string, n3, n4);
            this.dx = n;
            this.dy = n2;
        }

        @Override
        public void transform(Font<BitmapFontGlyph> font, BitmapFontGlyph bitmapFontGlyph) {
            int n = bitmapFontGlyph.getX() + this.dx;
            int n2 = bitmapFontGlyph.getY() - this.dy;
            bitmapFontGlyph.setXY(n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FlipVertical
    extends BitmapGlyphTransform {
        public FlipVertical(String string, int n, int n2) {
            super(string, n, n2);
        }

        @Override
        public void transform(Font<BitmapFontGlyph> font, BitmapFontGlyph bitmapFontGlyph) {
            this.transform(bitmapFontGlyph.getGlyph());
            int n = font.getLineAscent() - font.getLineDescent();
            bitmapFontGlyph.setXY(bitmapFontGlyph.getGlyphOffset(), n += bitmapFontGlyph.getGlyphHeight() - bitmapFontGlyph.getGlyphAscent());
        }

        private void transform(byte[][] byArray) {
            int n = 0;
            for (int i = byArray.length - 1; n < i; ++n, --i) {
                byte[] byArray2 = byArray[n];
                byArray[n] = byArray[i];
                byArray[i] = byArray2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FlipHorizontal
    extends BitmapGlyphTransform {
        public FlipHorizontal(String string, int n, int n2) {
            super(string, n, n2);
        }

        @Override
        public void transform(Font<BitmapFontGlyph> font, BitmapFontGlyph bitmapFontGlyph) {
            for (byte[] byArray : bitmapFontGlyph.getGlyph()) {
                this.transform(byArray);
            }
            int n = bitmapFontGlyph.getCharacterWidth() - bitmapFontGlyph.getGlyphWidth() - bitmapFontGlyph.getGlyphOffset();
            bitmapFontGlyph.setXY(n, bitmapFontGlyph.getGlyphAscent());
        }

        private void transform(byte[] byArray) {
            int n = 0;
            for (int i = byArray.length - 1; n < i; ++n, --i) {
                byte by = byArray[n];
                byArray[n] = byArray[i];
                byArray[i] = by;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Invert
    extends BitmapGlyphTransform {
        public Invert(String string, int n, int n2) {
            super(string, n, n2);
        }

        @Override
        public void transform(Font<BitmapFontGlyph> font, BitmapFontGlyph bitmapFontGlyph) {
            bitmapFontGlyph.expand(0, -font.getLineAscent(), bitmapFontGlyph.getCharacterWidth(), font.getLineAscent() + font.getLineDescent());
            bitmapFontGlyph.invertRect(0, -font.getLineAscent(), bitmapFontGlyph.getCharacterWidth(), font.getLineAscent() + font.getLineDescent());
            bitmapFontGlyph.contract();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Bold
    extends BitmapGlyphTransform {
        private final BoldBitmapFontGlyphTransformer tx = new BoldBitmapFontGlyphTransformer();

        public Bold(String string, int n, int n2) {
            super(string, n, n2);
        }

        @Override
        public void transform(Font<BitmapFontGlyph> font, BitmapFontGlyph bitmapFontGlyph) {
            new BitmapGlyphState(this.tx.transformGlyph(bitmapFontGlyph)).apply(bitmapFontGlyph);
        }
    }
}

