/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.BitmapGlyphListSelection;
import com.kreative.bitsnpicas.edit.BitmapGlyphState;
import com.kreative.bitsnpicas.edit.BitmapGlyphTransform;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.CreateGlyphsDialog;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphListListener;
import com.kreative.bitsnpicas.edit.GlyphListMenuBar;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.bitsnpicas.edit.MoveGlyphsDialog;
import com.kreative.bitsnpicas.edit.SaveManager;
import com.kreative.bitsnpicas.edit.SwingUtils;
import com.kreative.bitsnpicas.edit.UnifontHexGlyphGenerator;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportFrame;
import com.kreative.bitsnpicas.main.ViewFont;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitmapListMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;

    public BitmapListMenuBar(Frame frame, SaveManager saveManager, BitmapFont bitmapFont, GlyphList<BitmapFontGlyph> glyphList) {
        this.add(new FileMenu(frame, saveManager, bitmapFont, glyphList));
        this.add(new EditMenu(frame, glyphList));
        this.add(new GlyphListMenuBar.ViewMenu(frame, glyphList));
        this.add(new TransformMenu(glyphList));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TransformMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public TransformMenuItem(final BitmapGlyphTransform bitmapGlyphTransform, final GlyphList<BitmapFontGlyph> glyphList) {
            super(bitmapGlyphTransform.name);
            this.setAccelerator(bitmapGlyphTransform.keystroke);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List list = glyphList.getSelection();
                    if (list.isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    IdentityHashMap<BitmapFontGlyph, BitmapFontGlyph> identityHashMap = new IdentityHashMap<BitmapFontGlyph, BitmapFontGlyph>();
                    for (GlyphLocator glyphLocator : list) {
                        Font<BitmapFontGlyph> font = glyphLocator.getGlyphFont();
                        BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)glyphLocator.getGlyph();
                        if (bitmapFontGlyph == null || identityHashMap.containsKey(bitmapFontGlyph)) continue;
                        bitmapGlyphTransform.transform(font, bitmapFontGlyph);
                        identityHashMap.put(bitmapFontGlyph, bitmapFontGlyph);
                    }
                    glyphList.glyphContentChanged();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TransformMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public TransformMenu(GlyphList<BitmapFontGlyph> glyphList) {
            super("Transform");
            for (BitmapGlyphTransform bitmapGlyphTransform : BitmapGlyphTransform.TRANSFORMS) {
                if (bitmapGlyphTransform == null) {
                    this.addSeparator();
                    continue;
                }
                this.add(new TransformMenuItem(bitmapGlyphTransform, glyphList));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GenerateTimestampGlyphMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public GenerateTimestampGlyphMenuItem(final GlyphList<BitmapFontGlyph> glyphList) {
            super("Generate Timestamp Glyph");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BitmapFontGlyph[] bitmapFontGlyphArray;
                    List list = glyphList.getSelection();
                    if (list.isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    Font font = glyphList.getGlyphFont();
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    int n = gregorianCalendar.get(1);
                    int n2 = gregorianCalendar.get(2) + 1;
                    int n3 = gregorianCalendar.get(5);
                    BitmapFontGlyph[] bitmapFontGlyphArray2 = bitmapFontGlyphArray = new BitmapFontGlyph[]{(BitmapFontGlyph)font.getNamedGlyph("timestamp.ch" + n / 1000 % 10), (BitmapFontGlyph)font.getNamedGlyph("timestamp.cl" + n / 100 % 10), (BitmapFontGlyph)font.getNamedGlyph("timestamp.yh" + n / 10 % 10), (BitmapFontGlyph)font.getNamedGlyph("timestamp.yl" + n / 1 % 10), (BitmapFontGlyph)font.getNamedGlyph("timestamp.mh" + n2 / 10 % 10), (BitmapFontGlyph)font.getNamedGlyph("timestamp.ml" + n2 / 1 % 10), (BitmapFontGlyph)font.getNamedGlyph("timestamp.dh" + n3 / 10 % 10), (BitmapFontGlyph)font.getNamedGlyph("timestamp.dl" + n3 / 1 % 10), (BitmapFontGlyph)font.getNamedGlyph("timestamp")};
                    int n4 = bitmapFontGlyphArray2.length;
                    for (int i = 0; i < n4; ++i) {
                        BitmapFontGlyph bitmapFontGlyph = bitmapFontGlyphArray2[i];
                        if (bitmapFontGlyph == null) continue;
                        for (GlyphLocator<BitmapFontGlyph> glyphLocator : list) {
                            glyphLocator.setGlyph(BitmapFontGlyph.compose(bitmapFontGlyphArray));
                        }
                        glyphList.glyphContentChanged();
                        return;
                    }
                    for (BitmapFontGlyph bitmapFontGlyph : bitmapFontGlyphArray2 = new BitmapFontGlyph[]{(BitmapFontGlyph)font.getCharacter(1113920 + n / 1000 % 10), (BitmapFontGlyph)font.getCharacter(1113936 + n / 100 % 10), (BitmapFontGlyph)font.getCharacter(1113952 + n / 10 % 10), (BitmapFontGlyph)font.getCharacter(1113968 + n / 1 % 10), (BitmapFontGlyph)font.getCharacter(1113984 + n2 / 10 % 10), (BitmapFontGlyph)font.getCharacter(1114000 + n2 / 1 % 10), (BitmapFontGlyph)font.getCharacter(1114016 + n3 / 10 % 10), (BitmapFontGlyph)font.getCharacter(1114032 + n3 / 1 % 10), (BitmapFontGlyph)font.getCharacter(1114048)}) {
                        if (bitmapFontGlyph == null) continue;
                        for (GlyphLocator<BitmapFontGlyph> glyphLocator : list) {
                            glyphLocator.setGlyph(BitmapFontGlyph.compose(bitmapFontGlyphArray2));
                        }
                        glyphList.glyphContentChanged();
                        return;
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GenerateUnifontHexGlyphMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public GenerateUnifontHexGlyphMenuItem(final GlyphList<BitmapFontGlyph> glyphList) {
            super("Generate Unifont Hex Glyph");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List list = glyphList.getSelection();
                    if (list.isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    for (GlyphLocator<BitmapFontGlyph> glyphLocator : list) {
                        if (!glyphLocator.isCodePoint()) continue;
                        glyphLocator.setGlyph(UnifontHexGlyphGenerator.createGlyph(glyphLocator.getCodePoint()));
                    }
                    glyphList.glyphContentChanged();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MoveMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public MoveMenuItem(final Frame frame, final GlyphList<BitmapFontGlyph> glyphList, final boolean bl) {
            super(bl ? "Copy Glyphs..." : "Move Glyphs...");
            this.setAccelerator(KeyStroke.getKeyStroke(bl ? 67 : 88, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (glyphList.getSelection().isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    new MoveGlyphsDialog<BitmapFontGlyph, BitmapGlyphState>(frame, bl, glyphList){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public BitmapGlyphState serializeGlyph(BitmapFontGlyph bitmapFontGlyph) {
                            return new BitmapGlyphState(bitmapFontGlyph);
                        }

                        @Override
                        public BitmapFontGlyph deserializeGlyph(BitmapGlyphState bitmapGlyphState) {
                            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
                            bitmapGlyphState.apply(bitmapFontGlyph);
                            return bitmapFontGlyph;
                        }
                    }.setVisible(true);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CreateMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public CreateMenuItem(final Frame frame, final GlyphList<BitmapFontGlyph> glyphList) {
            super("Create Glyphs...");
            this.setAccelerator(KeyStroke.getKeyStroke(75, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new CreateGlyphsDialog<BitmapFontGlyph>(frame, glyphList){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public BitmapFontGlyph createGlyph() {
                            return new BitmapFontGlyph();
                        }
                    }.setVisible(true);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ClearMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ClearMenuItem(final GlyphList<BitmapFontGlyph> glyphList) {
            super("Clear");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (glyphList.getSelection().isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    glyphList.deleteSelection();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PasteMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public PasteMenuItem(final GlyphList<BitmapFontGlyph> glyphList, final boolean bl) {
            super(bl ? "Paste Into" : "Paste");
            this.setAccelerator(KeyStroke.getKeyStroke(86, CommonMenuItems.SHORTCUT_KEY | (bl ? 1 : 0)));
            this.addActionListener(new ActionListener(){

                /*
                 * WARNING - void declaration
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    List list = glyphList.getSelection();
                    if (list.isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    try {
                        String string;
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        if (clipboard.isDataFlavorAvailable(BitmapGlyphListSelection.flavor)) {
                            BitmapGlyphState[] bitmapGlyphStateArray = (BitmapGlyphState[])clipboard.getData(BitmapGlyphListSelection.flavor);
                            if (bitmapGlyphStateArray.length > 0) {
                                int n = list.size();
                                for (int i = 0; i < n; ++i) {
                                    void object;
                                    BitmapFontGlyph i2 = new BitmapFontGlyph();
                                    bitmapGlyphStateArray[i % bitmapGlyphStateArray.length].apply(i2);
                                    if (bl) {
                                        BitmapFontGlyph glyphLocator = BitmapFontGlyph.compose((BitmapFontGlyph)list.get(i).getGlyph(), i2);
                                    }
                                    list.get(i).setGlyph(object);
                                }
                                if (list.size() < bitmapGlyphStateArray.length) {
                                    int n2;
                                    void var7_23;
                                    HashSet<Integer> hashSet = new HashSet<Integer>();
                                    for (GlyphLocator glyphLocator : list) {
                                        hashSet.add(glyphLocator.getGlyphIndex());
                                    }
                                    GlyphLocator<BitmapFontGlyph> glyphLocator = list.get(list.size() - 1);
                                    int n3 = list.size();
                                    while (var7_23 < bitmapGlyphStateArray.length && (glyphLocator = glyphLocator.getNext()) != null && (n2 = glyphLocator.getGlyphIndex()) > 0) {
                                        hashSet.add(n2);
                                        BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
                                        bitmapGlyphStateArray[var7_23].apply(bitmapFontGlyph);
                                        if (bl) {
                                            bitmapFontGlyph = BitmapFontGlyph.compose((BitmapFontGlyph)glyphLocator.getGlyph(), bitmapFontGlyph);
                                        }
                                        glyphLocator.setGlyph(bitmapFontGlyph);
                                        ++var7_23;
                                    }
                                    glyphList.setSelectedIndices(hashSet, true);
                                }
                                glyphList.glyphContentChanged();
                                return;
                            }
                        } else if (clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
                            Image image = (Image)clipboard.getData(DataFlavor.imageFlavor);
                            BufferedImage bufferedImage = SwingUtils.toBufferedImage(image);
                            if (bufferedImage != null) {
                                for (GlyphLocator<BitmapFontGlyph> glyphLocator : list) {
                                    BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
                                    bitmapFontGlyph.setToImage(0, -glyphLocator.getGlyphFont().getLineAscent(), bufferedImage);
                                    bitmapFontGlyph.setCharacterWidth(bufferedImage.getWidth());
                                    if (bl) {
                                        bitmapFontGlyph = BitmapFontGlyph.compose((BitmapFontGlyph)glyphLocator.getGlyph(), bitmapFontGlyph);
                                    }
                                    glyphLocator.setGlyph(bitmapFontGlyph);
                                }
                                glyphList.glyphContentChanged();
                                return;
                            }
                        } else if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor) && (string = (String)clipboard.getData(DataFlavor.stringFlavor)) != null) {
                            Object object;
                            int n;
                            Font font = glyphList.getGlyphFont();
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            int n4 = font.getLineAscent() + font.getLineDescent();
                            int n5 = 0;
                            int n6 = string.length();
                            for (int i = 0; i < n6; i += Character.charCount(n)) {
                                n = string.codePointAt(i);
                                object = (BitmapFontGlyph)font.getCharacter(n);
                                if (object == null) continue;
                                arrayList.add(object);
                                if ((n5 += ((BitmapFontGlyph)object).getCharacterWidth()) < 1024) continue;
                                Toolkit.getDefaultToolkit().beep();
                                return;
                            }
                            BufferedImage bufferedImage = new BufferedImage(n5, n4, 2);
                            object = bufferedImage.createGraphics();
                            ((Graphics)object).setColor(Color.black);
                            double d = 0.0;
                            double d2 = font.getLineAscent();
                            for (BitmapFontGlyph bitmapFontGlyph : arrayList) {
                                d += bitmapFontGlyph.paint((Graphics)object, d, d2, 1.0);
                            }
                            ((Graphics)object).dispose();
                            for (GlyphLocator glyphLocator : list) {
                                BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
                                bitmapFontGlyph.setToImage(0, -glyphLocator.getGlyphFont().getLineAscent(), bufferedImage);
                                bitmapFontGlyph.setCharacterWidth(bufferedImage.getWidth());
                                if (bl) {
                                    bitmapFontGlyph = BitmapFontGlyph.compose((BitmapFontGlyph)glyphLocator.getGlyph(), bitmapFontGlyph);
                                }
                                glyphLocator.setGlyph(bitmapFontGlyph);
                            }
                            glyphList.glyphContentChanged();
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        unsupportedFlavorException.printStackTrace();
                    }
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CopyMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public CopyMenuItem(final GlyphList<BitmapFontGlyph> glyphList) {
            super("Copy");
            this.setAccelerator(KeyStroke.getKeyStroke(67, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List<GlyphLocator<BitmapFontGlyph>> list = glyphList.getSelection();
                    if (list.isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    BitmapGlyphListSelection bitmapGlyphListSelection = new BitmapGlyphListSelection(list);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(bitmapGlyphListSelection, bitmapGlyphListSelection);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CutMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public CutMenuItem(final GlyphList<BitmapFontGlyph> glyphList) {
            super("Cut");
            this.setAccelerator(KeyStroke.getKeyStroke(88, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List<GlyphLocator<BitmapFontGlyph>> list = glyphList.getSelection();
                    if (list.isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    BitmapGlyphListSelection bitmapGlyphListSelection = new BitmapGlyphListSelection(list);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(bitmapGlyphListSelection, bitmapGlyphListSelection);
                    glyphList.deleteSelection();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EditMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public EditMenu(Frame frame, GlyphList<BitmapFontGlyph> glyphList) {
            super("Edit");
            this.add(new CutMenuItem(glyphList));
            this.add(new CopyMenuItem(glyphList));
            this.add(new PasteMenuItem(glyphList, false));
            this.add(new PasteMenuItem(glyphList, true));
            this.add(new ClearMenuItem(glyphList));
            this.addSeparator();
            this.add(new GlyphListMenuBar.SelectAllMenuItem(glyphList));
            this.add(new GlyphListMenuBar.SelectNoneMenuItem(glyphList));
            this.add(new GlyphListMenuBar.SetSelectionMenuItem(frame, glyphList));
            this.addSeparator();
            this.add(new CreateMenuItem(frame, glyphList));
            this.add(new MoveMenuItem(frame, glyphList, false));
            this.add(new MoveMenuItem(frame, glyphList, true));
            this.add(new GlyphListMenuBar.EditMenuItem(glyphList));
            this.add(new GlyphListMenuBar.DeleteMenuItem(glyphList));
            this.addSeparator();
            this.add(new GenerateUnifontHexGlyphMenuItem(glyphList));
            this.add(new GenerateTimestampGlyphMenuItem(glyphList));
            this.addSeparator();
            this.add(new CommonMenuItems.FontMapMenuItem());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PreviewMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public PreviewMenuItem(final BitmapFont bitmapFont, final GlyphList<BitmapFontGlyph> glyphList) {
            super("Preview");
            this.setAccelerator(KeyStroke.getKeyStroke(80, CommonMenuItems.SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    final ViewFont viewFont = new ViewFont(bitmapFont);
                    final GlyphListListener<BitmapFontGlyph> glyphListListener = new GlyphListListener<BitmapFontGlyph>(){

                        @Override
                        public void selectionChanged(GlyphList<BitmapFontGlyph> glyphList, Font<BitmapFontGlyph> font) {
                        }

                        @Override
                        public void selectionOpened(GlyphList<BitmapFontGlyph> glyphList, Font<BitmapFontGlyph> font) {
                        }

                        @Override
                        public void metricsChanged(GlyphList<BitmapFontGlyph> glyphList, Font<BitmapFontGlyph> font) {
                            viewFont.fontChanged();
                        }

                        @Override
                        public void glyphsChanged(GlyphList<BitmapFontGlyph> glyphList, Font<BitmapFontGlyph> font) {
                            viewFont.fontChanged();
                        }
                    };
                    viewFont.setVisible(true);
                    viewFont.addWindowListener(new WindowAdapter(){

                        public void windowClosed(WindowEvent windowEvent) {
                            glyphList.removeGlyphListListener(glyphListListener);
                        }
                    });
                    glyphList.addGlyphListListener(glyphListListener);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ImportMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private String lastDirectory = null;

        public ImportMenuItem(final Frame frame, final GlyphList<BitmapFontGlyph> glyphList) {
            super("Import Image...");
            this.setAccelerator(KeyStroke.getKeyStroke(73, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    List list = glyphList.getSelection();
                    if (list.isEmpty()) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    FileDialog fileDialog = new FileDialog(frame, "Import Image", 0);
                    if (ImportMenuItem.this.lastDirectory != null) {
                        fileDialog.setDirectory(ImportMenuItem.this.lastDirectory);
                    }
                    fileDialog.setVisible(true);
                    String string = fileDialog.getDirectory();
                    String string2 = fileDialog.getFile();
                    fileDialog.dispose();
                    if (string == null || string2 == null) {
                        return;
                    }
                    File file = new File(ImportMenuItem.this.lastDirectory = string, string2);
                    try {
                        BufferedImage bufferedImage = ImageIO.read(file);
                        if (bufferedImage != null) {
                            for (GlyphLocator<BitmapFontGlyph> glyphLocator : list) {
                                BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph();
                                bitmapFontGlyph.setToImage(0, -glyphLocator.getGlyphFont().getLineAscent(), bufferedImage);
                                bitmapFontGlyph.setCharacterWidth(bufferedImage.getWidth());
                                glyphLocator.setGlyph(bitmapFontGlyph);
                            }
                            glyphList.glyphContentChanged();
                        } else {
                            JOptionPane.showMessageDialog(null, "The selected file was not recognized as an image file.", "Import Image", 0);
                        }
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(null, "An error occurred while reading the selected file.", "Import Image", 0);
                    }
                }
            });
        }
    }

    public static final class ExportMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ExportMenuItem(final BitmapFont bitmapFont) {
            super("Export...");
            this.setAccelerator(KeyStroke.getKeyStroke(69, CommonMenuItems.SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new BitmapExportFrame(bitmapFont).setVisible(true);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public FileMenu(Frame frame, SaveManager saveManager, BitmapFont bitmapFont, GlyphList<BitmapFontGlyph> glyphList) {
            super("File");
            this.add(new CommonMenuItems.NewMenu());
            this.add(new CommonMenuItems.OpenMenuItem());
            this.add(new CommonMenuItems.CloseMenuItem(frame));
            this.addSeparator();
            this.add(new CommonMenuItems.SaveMenuItem(saveManager));
            this.add(new CommonMenuItems.SaveAsMenuItem(saveManager));
            this.add(new ExportMenuItem(bitmapFont));
            this.addSeparator();
            this.add(new ImportMenuItem(frame, glyphList));
            this.addSeparator();
            this.add(new CommonMenuItems.FontInfoMenuItem(bitmapFont, saveManager));
            this.add(new PreviewMenuItem(bitmapFont, glyphList));
            if (!CommonMenuItems.IS_MAC_OS) {
                this.addSeparator();
                this.add(new CommonMenuItems.ExitMenuItem());
            }
        }
    }
}

