/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.edit.GlyphEditMenuBar;
import com.kreative.bitsnpicas.edit.GlyphEditPanel;
import com.kreative.bitsnpicas.edit.GlyphList;
import com.kreative.bitsnpicas.edit.GlyphLocator;
import com.kreative.bitsnpicas.edit.SaveManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphEditFrame<G extends FontGlyph>
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final GlyphEditPanel<G> panel;
    private final GlyphEditMenuBar<G> mb;

    public GlyphEditFrame(Class<G> clazz, Font<G> font, GlyphLocator<G> glyphLocator, GlyphList<G> glyphList, SaveManager saveManager) {
        this.panel = new GlyphEditPanel<G>(glyphLocator, glyphList);
        this.mb = new GlyphEditMenuBar<G>(this, saveManager, font, this.panel, clazz);
        this.setTitle(glyphLocator.toString());
        this.setJMenuBar(this.mb);
        this.setContentPane(this.panel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        GlyphEditFrame.addActions(this, this.panel, clazz);
        this.panel.getGlyphComponent().requestFocusInWindow();
    }

    public static <G extends FontGlyph> void addActions(final JFrame jFrame, final GlyphEditPanel<G> glyphEditPanel, final Class<G> clazz) {
        InputMap inputMap = jFrame.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "previousGlyph");
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "nextGlyph");
        inputMap.put(KeyStroke.getKeyStroke(33, 1), "previousDefinedGlyph");
        inputMap.put(KeyStroke.getKeyStroke(34, 1), "nextDefinedGlyph");
        ActionMap actionMap = jFrame.getRootPane().getActionMap();
        actionMap.put("previousGlyph", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                glyphEditPanel.setGlyph(glyphEditPanel.getGlyphLocator().getPrevious(), clazz);
                jFrame.setTitle(glyphEditPanel.getGlyphLocator().toString());
            }
        });
        actionMap.put("nextGlyph", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                glyphEditPanel.setGlyph(glyphEditPanel.getGlyphLocator().getNext(), clazz);
                jFrame.setTitle(glyphEditPanel.getGlyphLocator().toString());
            }
        });
        actionMap.put("previousDefinedGlyph", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                glyphEditPanel.setGlyph(glyphEditPanel.getGlyphLocator().getPreviousDefined(), null);
                jFrame.setTitle(glyphEditPanel.getGlyphLocator().toString());
            }
        });
        actionMap.put("nextDefinedGlyph", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                glyphEditPanel.setGlyph(glyphEditPanel.getGlyphLocator().getNextDefined(), null);
                jFrame.setTitle(glyphEditPanel.getGlyphLocator().toString());
            }
        });
    }
}

