/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSFBitmapFontExporter
implements BitmapFontExporter {
    private int version;
    private GlyphList lowEncoding;
    private GlyphList highEncoding;
    private boolean useLowEncoding;
    private boolean useHighEncoding;
    private boolean useAllGlyphs;
    private boolean unicodeTable;
    private boolean gzip;

    public PSFBitmapFontExporter() {
        this.version = 2;
        this.lowEncoding = null;
        this.highEncoding = null;
        this.useLowEncoding = true;
        this.useHighEncoding = false;
        this.useAllGlyphs = true;
        this.unicodeTable = true;
        this.gzip = false;
    }

    public PSFBitmapFontExporter(boolean bl) {
        this.version = 2;
        this.lowEncoding = null;
        this.highEncoding = null;
        this.useLowEncoding = true;
        this.useHighEncoding = false;
        this.useAllGlyphs = true;
        this.unicodeTable = true;
        this.gzip = bl;
    }

    public PSFBitmapFontExporter(int n, GlyphList glyphList, GlyphList glyphList2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.version = n;
        this.lowEncoding = glyphList;
        this.highEncoding = glyphList2;
        this.useLowEncoding = bl;
        this.useHighEncoding = bl2;
        this.useAllGlyphs = bl3;
        this.unicodeTable = bl4;
        this.gzip = false;
    }

    public PSFBitmapFontExporter(int n, GlyphList glyphList, GlyphList glyphList2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.version = n;
        this.lowEncoding = glyphList;
        this.highEncoding = glyphList2;
        this.useLowEncoding = bl;
        this.useHighEncoding = bl2;
        this.useAllGlyphs = bl3;
        this.unicodeTable = bl4;
        this.gzip = bl5;
    }

    @Override
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontToStream(bitmapFont, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        if (this.gzip) {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
            this.exportFontImpl(bitmapFont, new DataOutputStream(gZIPOutputStream));
            gZIPOutputStream.finish();
        } else {
            this.exportFontImpl(bitmapFont, new DataOutputStream(outputStream));
        }
    }

    @Override
    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFontToStream(bitmapFont, (OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    private void exportFontImpl(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        boolean bl;
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (this.useLowEncoding || this.version < 2) {
            for (n = 0; n < 256; ++n) {
                arrayList.add(this.lowEncoding != null ? this.lowEncoding.get(n & 0xFF) : n);
            }
        }
        if (this.useHighEncoding) {
            for (n = 256; n < 512; ++n) {
                arrayList.add(this.highEncoding != null ? this.highEncoding.get(n & 0xFF) : n);
            }
        }
        if (this.useAllGlyphs && this.version >= 2) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.addAll(bitmapFont.characters(false).keySet());
            treeSet.removeAll(arrayList);
            arrayList.addAll(treeSet);
        }
        int n2 = bitmapFont.getLineAscent();
        int n3 = n2 + bitmapFont.getLineDescent() + bitmapFont.getLineGap();
        int n4 = this.version < 2 ? 8 : this.getMaxWidth(bitmapFont, arrayList);
        boolean bl2 = bl = arrayList.size() > 256;
        if (this.version < 2) {
            dataOutputStream.writeShort(13828);
            dataOutputStream.writeByte((bl ? 1 : 0) | (this.unicodeTable ? 2 : 0));
            dataOutputStream.writeByte(n3);
        } else {
            dataOutputStream.writeInt(1924483718);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(Integer.reverseBytes(32));
            dataOutputStream.writeInt(Integer.reverseBytes(this.unicodeTable ? 1 : 0));
            dataOutputStream.writeInt(Integer.reverseBytes(arrayList.size()));
            dataOutputStream.writeInt(Integer.reverseBytes(n3 * ((n4 + 7) / 8)));
            dataOutputStream.writeInt(Integer.reverseBytes(n3));
            dataOutputStream.writeInt(Integer.reverseBytes(n4));
        }
        for (int n5 : arrayList) {
            this.writeGlyph(dataOutputStream, n4, n3, n2, (BitmapFontGlyph)bitmapFont.getCharacter(n5));
        }
        if (this.unicodeTable) {
            for (int n5 : arrayList) {
                if (n5 >= 0) {
                    String[] stringArray = new String[]{String.valueOf(Character.toChars(n5))};
                    this.writeUnicodeEntry(dataOutputStream, this.version, stringArray);
                    continue;
                }
                this.writeUnicodeEntry(dataOutputStream, this.version, null);
            }
        }
    }

    private int getMaxWidth(BitmapFont bitmapFont, ArrayList<Integer> arrayList) {
        int n = 0;
        for (int n2 : arrayList) {
            int n3;
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n2);
            if (bitmapFontGlyph == null || (n3 = bitmapFontGlyph.getCharacterWidth()) <= n) continue;
            n = n3;
        }
        return n;
    }

    private void writeGlyph(DataOutputStream dataOutputStream, int n, int n2, int n3, BitmapFontGlyph bitmapFontGlyph) throws IOException {
        if (bitmapFontGlyph == null) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; j += 8) {
                    dataOutputStream.writeByte(0);
                }
            }
        } else {
            byte[][] byArray = bitmapFontGlyph.getGlyph();
            int n4 = bitmapFontGlyph.getGlyphAscent() - n3;
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                if (n4 >= 0 && n4 < byArray.length) {
                    n6 = -bitmapFontGlyph.getGlyphOffset();
                    int n7 = 0;
                    while (n7 < n) {
                        int n8 = 0;
                        int n9 = 128;
                        while (n9 != 0 && n7 < n) {
                            if (n6 >= 0 && n6 < byArray[n4].length && byArray[n4][n6] < 0) {
                                n8 |= n9;
                            }
                            n9 >>= 1;
                            ++n7;
                            ++n6;
                        }
                        dataOutputStream.writeByte(n8);
                    }
                } else {
                    for (n6 = 0; n6 < n; n6 += 8) {
                        dataOutputStream.writeByte(0);
                    }
                }
                ++n5;
                ++n4;
            }
        }
    }

    private void writeUnicodeEntry(DataOutputStream dataOutputStream, int n, String[] stringArray) throws IOException {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string.length() != 1) continue;
                if (n < 2) {
                    dataOutputStream.write(string.getBytes("UTF-16LE"));
                    continue;
                }
                dataOutputStream.write(string.getBytes("UTF-8"));
            }
            for (String string : stringArray) {
                if (string.length() <= 1) continue;
                if (n < 2) {
                    dataOutputStream.writeChar(Character.reverseBytes('\ufffe'));
                    dataOutputStream.write(string.getBytes("UTF-16LE"));
                    continue;
                }
                dataOutputStream.writeByte(254);
                dataOutputStream.write(string.getBytes("UTF-8"));
            }
        }
        if (n < 2) {
            dataOutputStream.writeChar(65535);
        } else {
            dataOutputStream.writeByte(255);
        }
    }
}

