/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TOSBitmapFontExporter
implements BitmapFontExporter {
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFont(bitmapFont, new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        this.exportFont(bitmapFont, new DataOutputStream(outputStream));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFont(bitmapFont, new DataOutputStream(fileOutputStream));
        fileOutputStream.close();
    }

    private void exportFont(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2 = 0;
        int n3 = bitmapFont.getLineAscent();
        int n4 = bitmapFont.getLineDescent();
        int n5 = n3 + n4;
        int n6 = 0;
        for (n = 0; n < 0x110000; ++n) {
            if (!bitmapFont.containsCharacter(n)) continue;
            int n7 = ((BitmapFontGlyph)bitmapFont.getCharacter(n)).getCharacterWidth();
            if (n7 > n2) {
                n2 = n7;
            }
            n6 = n + 1;
        }
        dataOutputStream.writeInt(1884745879);
        dataOutputStream.writeShort(Short.reverseBytes((short)n2));
        dataOutputStream.writeShort(Short.reverseBytes((short)n5));
        for (n = 0; n < n6; ++n) {
            int n8;
            if (bitmapFont.containsCharacter(n)) {
                BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n);
                n8 = n3 - bitmapFontGlyph.getGlyphAscent();
                int n9 = bitmapFontGlyph.getGlyphOffset();
                byte[][] byArray = bitmapFontGlyph.getGlyph();
                for (int i = 0; i < n5; ++i) {
                    int n10;
                    int n11 = i - n8;
                    if (n11 >= 0 && n11 < byArray.length) {
                        for (n10 = 0; n10 < n2; n10 += 8) {
                            int n12 = 0;
                            for (int j = 0; j < 8; ++j) {
                                int n13 = n10 + j - n9;
                                n12 = (byte)(n12 << 1);
                                if (n13 < 0 || n13 >= byArray[n11].length || byArray[n11][n13] >= 0) continue;
                                n12 = (byte)(n12 | 1);
                            }
                            dataOutputStream.writeByte(n12);
                        }
                        continue;
                    }
                    for (n10 = 0; n10 < n2; n10 += 8) {
                        dataOutputStream.writeByte(0);
                    }
                }
                continue;
            }
            for (int i = 0; i < n5; ++i) {
                for (n8 = 0; n8 < n2; n8 += 8) {
                    dataOutputStream.writeByte(0);
                }
            }
        }
    }
}

