/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.u8m.U8MFile;
import com.kreative.bitsnpicas.u8m.U8MGlyph;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class U8MBitmapFontExporter
implements BitmapFontExporter {
    private Integer loadAddress;
    private GlyphList nativeEncoding;

    public U8MBitmapFontExporter() {
        this.loadAddress = null;
        this.nativeEncoding = null;
    }

    public U8MBitmapFontExporter(Integer n) {
        this.loadAddress = n;
        this.nativeEncoding = null;
    }

    public U8MBitmapFontExporter(GlyphList glyphList) {
        this.loadAddress = null;
        this.nativeEncoding = glyphList;
    }

    public U8MBitmapFontExporter(Integer n, GlyphList glyphList) {
        this.loadAddress = n;
        this.nativeEncoding = glyphList;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontToStream(bitmapFont, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        int n;
        File file = File.createTempFile("u8m", ".u8m");
        this.exportFontToFile(bitmapFont, file);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[65536];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        file.delete();
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        int n;
        int n2;
        U8MFile u8MFile = new U8MFile();
        u8MFile.familyName = bitmapFont.getName(1);
        u8MFile.familyID = (int)(((long)u8MFile.familyName.hashCode() & 0xFFFFFFFFL) % 65535L + 1L);
        u8MFile.style = bitmapFont.getMacStyle();
        u8MFile.pointSize = bitmapFont.getEmAscent() + bitmapFont.getEmDescent();
        u8MFile.lineAscent = bitmapFont.getLineAscent();
        u8MFile.lineDescent = bitmapFont.getLineDescent();
        u8MFile.lineGap = bitmapFont.getLineGap();
        u8MFile.lineHeight = u8MFile.lineAscent + u8MFile.lineDescent + u8MFile.lineGap;
        u8MFile.createMap();
        u8MFile.createGlyph();
        for (n2 = 0; n2 < 0x110000; ++n2) {
            if (!bitmapFont.containsCharacter(n2)) continue;
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n2);
            n = n2 == 0 ? 0 : u8MFile.createGlyph();
            U8MGlyph u8MGlyph = (U8MGlyph)u8MFile.glyphs.get(n);
            u8MGlyph.advanceWidth = bitmapFontGlyph.getCharacterWidth();
            u8MGlyph.yOffset = -bitmapFontGlyph.getGlyphAscent();
            u8MGlyph.xOffset = bitmapFontGlyph.getGlyphOffset();
            u8MGlyph.from2DArray(bitmapFontGlyph.getGlyph());
            if (n2 == 0) continue;
            u8MFile.setUnicodeGlyphIndex(n2, n);
        }
        if (this.nativeEncoding != null) {
            for (n2 = 0; n2 < 256; ++n2) {
                int n3 = this.nativeEncoding.get(n2);
                if (n3 <= 0 || (n = u8MFile.getUnicodeGlyphIndex(n3)) <= 0) continue;
                u8MFile.setNativeGlyphIndex(n2, n);
            }
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rwd");
        randomAccessFile.setLength(0L);
        if (this.loadAddress != null) {
            randomAccessFile.writeShort(Short.reverseBytes(this.loadAddress.shortValue()));
            u8MFile.write(randomAccessFile, 0, 2L);
        } else {
            u8MFile.write(randomAccessFile, 0, 0L);
        }
        randomAccessFile.close();
    }
}

