/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos;

import com.kreative.bitsnpicas.geos.CBMConstants;
import com.kreative.bitsnpicas.geos.PETSCII;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.GregorianCalendar;

public class CBMDirectoryBlock
implements CBMConstants {
    public static final String COMMENT_PRG = "PRG formatted GEOS file";
    public static final String COMMENT_SEQ = "SEQ formatted GEOS file";
    public int cbmFileType;
    public int startingTrack;
    public int startingSector;
    public byte[] fileName;
    public int sideTrack;
    public int sideSector;
    public int recordLength;
    public int infoTrack;
    public int infoSector;
    public int fileStructure;
    public int geosFileType;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int sectorSize;
    public byte[] comment;

    public CBMDirectoryBlock() {
        this.clear();
    }

    public void clear() {
        this.cbmFileType = 128;
        this.startingTrack = 0;
        this.startingSector = 0;
        this.fileName = new byte[0];
        this.sideTrack = 0;
        this.sideSector = 0;
        this.recordLength = 0;
        this.infoTrack = 0;
        this.infoSector = 0;
        this.fileStructure = 0;
        this.geosFileType = 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.year = gregorianCalendar.get(1);
        this.month = gregorianCalendar.get(2) + 1;
        this.day = gregorianCalendar.get(5);
        this.hour = gregorianCalendar.get(11);
        this.minute = gregorianCalendar.get(12);
        this.sectorSize = 0;
        this.comment = new byte[0];
    }

    public String getFileTypeString() {
        int n = this.cbmFileType & 0xF;
        switch (n) {
            case 0: {
                return "DEL";
            }
            case 1: {
                return "SEQ";
            }
            case 2: {
                return "PRG";
            }
            case 3: {
                return "USR";
            }
            case 4: {
                return "REL";
            }
        }
        return "[" + Integer.toHexString(n).toUpperCase() + "]";
    }

    public boolean setFileTypeString(String string) {
        char[] cArray = string.trim().toCharArray();
        if (cArray.length > 0) {
            switch (cArray[0]) {
                case 'D': 
                case 'd': {
                    this.cbmFileType &= 0xFFFFFFF0;
                    this.cbmFileType |= 0;
                    return true;
                }
                case 'S': 
                case 's': {
                    this.cbmFileType &= 0xFFFFFFF0;
                    this.cbmFileType |= 1;
                    return true;
                }
                case 'P': 
                case 'p': {
                    this.cbmFileType &= 0xFFFFFFF0;
                    this.cbmFileType |= 2;
                    return true;
                }
                case 'U': 
                case 'u': {
                    this.cbmFileType &= 0xFFFFFFF0;
                    this.cbmFileType |= 3;
                    return true;
                }
                case 'R': 
                case 'r': {
                    this.cbmFileType &= 0xFFFFFFF0;
                    this.cbmFileType |= 4;
                    return true;
                }
            }
        }
        return false;
    }

    public String getFileName(boolean bl, boolean bl2) {
        if (bl2 && this.geosFileType != 0) {
            try {
                return new String(this.fileName, "US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        return PETSCII.toString(this.fileName, bl);
    }

    public void setFileName(String string, boolean bl, boolean bl2) {
        if (bl2 && this.geosFileType != 0) {
            try {
                this.fileName = string.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        } else {
            this.fileName = PETSCII.fromString(string, bl);
        }
    }

    public GregorianCalendar getDate() {
        if (this.year == 1900 && this.month == 0 && this.day == 0 && this.hour == 0 && this.minute == 0) {
            return null;
        }
        return new GregorianCalendar(this.year, this.month - 1, this.day, this.hour, this.minute);
    }

    public void setDate(GregorianCalendar gregorianCalendar) {
        if (gregorianCalendar == null) {
            this.year = 1900;
            this.month = 0;
            this.day = 0;
            this.hour = 0;
            this.minute = 0;
        } else {
            this.year = gregorianCalendar.get(1);
            this.month = gregorianCalendar.get(2) + 1;
            this.day = gregorianCalendar.get(5);
            this.hour = gregorianCalendar.get(11);
            this.minute = gregorianCalendar.get(12);
        }
    }

    public String getCommentString() {
        try {
            return new String(this.comment, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public void setCommentString(String string) {
        try {
            this.comment = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sectorSize);
        while (stringBuffer.codePointCount(0, stringBuffer.length()) < 5) {
            stringBuffer.append(' ');
        }
        stringBuffer.append('\"');
        stringBuffer.append(this.getFileName(bl, bl2));
        stringBuffer.append('\"');
        while (stringBuffer.codePointCount(0, stringBuffer.length()) < 23) {
            stringBuffer.append(' ');
        }
        if ((this.cbmFileType & 0x80) == 0) {
            stringBuffer.append('*');
        } else if ((this.cbmFileType & 0x40) != 0) {
            stringBuffer.append('>');
        } else {
            stringBuffer.append(' ');
        }
        stringBuffer.append(this.getFileTypeString());
        stringBuffer.append(' ');
        stringBuffer.append(this.toString(this.year, 4));
        stringBuffer.append('-');
        stringBuffer.append(this.toString(this.month, 2));
        stringBuffer.append('-');
        stringBuffer.append(this.toString(this.day, 2));
        stringBuffer.append(' ');
        stringBuffer.append(this.toString(this.hour, 2));
        stringBuffer.append(':');
        stringBuffer.append(this.toString(this.minute, 2));
        return stringBuffer.toString();
    }

    private String toString(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string.substring(string.length() - n2);
    }

    public void read(DataInput dataInput) throws IOException {
        this.cbmFileType = dataInput.readUnsignedByte();
        this.startingTrack = dataInput.readByte();
        this.startingSector = dataInput.readByte();
        this.fileName = CBMDirectoryBlock.read(dataInput, 16, (byte)-96);
        byte by = dataInput.readByte();
        this.infoTrack = by;
        this.sideTrack = by;
        byte by2 = dataInput.readByte();
        this.infoSector = by2;
        this.sideSector = by2;
        this.recordLength = this.fileStructure = dataInput.readUnsignedByte();
        this.geosFileType = dataInput.readUnsignedByte();
        this.year = dataInput.readUnsignedByte() + 1900;
        this.month = dataInput.readUnsignedByte();
        this.day = dataInput.readUnsignedByte();
        this.hour = dataInput.readUnsignedByte();
        this.minute = dataInput.readUnsignedByte();
        this.sectorSize = Short.reverseBytes(dataInput.readShort()) & 0xFFFF;
        this.comment = CBMDirectoryBlock.read(dataInput, 224, (byte)0);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.cbmFileType);
        dataOutput.writeByte(this.startingTrack);
        dataOutput.writeByte(this.startingSector);
        CBMDirectoryBlock.write(dataOutput, this.fileName, 16, (byte)-96);
        if (this.geosFileType == 0) {
            dataOutput.writeByte(this.sideTrack);
            dataOutput.writeByte(this.sideSector);
            dataOutput.writeByte(this.recordLength);
        } else {
            dataOutput.writeByte(this.infoTrack);
            dataOutput.writeByte(this.infoSector);
            dataOutput.writeByte(this.fileStructure);
        }
        dataOutput.writeByte(this.geosFileType);
        dataOutput.writeByte(this.year - 1900);
        dataOutput.writeByte(this.month);
        dataOutput.writeByte(this.day);
        dataOutput.writeByte(this.hour);
        dataOutput.writeByte(this.minute);
        dataOutput.writeShort(Short.reverseBytes((short)this.sectorSize));
        CBMDirectoryBlock.write(dataOutput, this.comment, 224, (byte)0);
    }

    private static byte[] read(DataInput dataInput, int n, byte by) throws IOException {
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        while (n > 0 && byArray[n - 1] == by) {
            --n;
        }
        byte[] byArray2 = new byte[n];
        while (n > 0) {
            byArray2[--n] = byArray[n];
        }
        return byArray2;
    }

    private static void write(DataOutput dataOutput, byte[] byArray, int n, byte by) throws IOException {
        int n2;
        for (n2 = 0; n2 < byArray.length && n2 < n; ++n2) {
            dataOutput.writeByte(byArray[n2]);
        }
        for (n2 = byArray.length; n2 < n; ++n2) {
            dataOutput.writeByte(by);
        }
    }
}

