/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.geos.mover;

import com.kreative.bitsnpicas.geos.GEOSFontFile;
import com.kreative.bitsnpicas.geos.GEOSFontPointSize;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEOSFontPointSizeTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon ICON = new ImageIcon(GEOSFontPointSizeTableModel.class.getResource("FontIcon.png"));
    private GEOSFontFile gff;
    private List<Item> items;

    public GEOSFontPointSizeTableModel(GEOSFontFile gEOSFontFile) {
        this.gff = gEOSFontFile;
        this.refresh();
    }

    public GEOSFontFile getFontFile() {
        return this.gff;
    }

    public int getPointSize(int n) {
        return this.items.get((int)n).pointSize;
    }

    public void refresh() {
        this.items = new ArrayList<Item>();
        for (int n : this.gff.getFontPointSizes()) {
            Item item = new Item();
            item.pointSize = n;
            item.sectorCount = this.gff.getFontPointSizeSectorCount(n);
            item.typeString = this.gff.getFontPointSizeTypeString(n);
            this.items.add(item);
        }
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "Point Size";
            }
            case 2: {
                return "Sectors";
            }
            case 3: {
                return "Type";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.items.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return ICON;
            }
            case 1: {
                return this.items.get((int)n).pointSize;
            }
            case 2: {
                return this.items.get((int)n).sectorCount;
            }
            case 3: {
                return this.items.get((int)n).typeString;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 1) {
            int n3 = this.items.get((int)n).pointSize;
            return n3 != 48 || !this.gff.isMega();
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1) {
            try {
                int n3 = this.items.get((int)n).pointSize;
                if (n3 == 48 && this.gff.isMega()) {
                    return;
                }
                int n4 = Integer.parseInt(object.toString());
                if (n4 != n3 && n4 > 0 && n4 < 64) {
                    GEOSFontPointSize gEOSFontPointSize = this.gff.getFontPointSize(n3);
                    if (gEOSFontPointSize == null) {
                        return;
                    }
                    this.gff.removeFontPointSize(n4);
                    this.gff.removeFontPointSize(n3);
                    this.gff.setFontPointSize(n4, gEOSFontPointSize);
                    this.refresh();
                }
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
    }

    private static final class Item {
        public int pointSize;
        public int sectorCount;
        public String typeString;

        private Item() {
        }
    }
}

