/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.importer;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.bitsnpicas.BitmapFontImporter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class HexBitmapFontImporter
implements BitmapFontImporter {
    public BitmapFont[] importFont(byte[] byArray) throws IOException {
        Scanner scanner = new Scanner((InputStream)new ByteArrayInputStream(byArray), "UTF-8");
        BitmapFont bitmapFont = HexBitmapFontImporter.importFont(scanner);
        scanner.close();
        if (bitmapFont.isEmpty()) {
            return new BitmapFont[0];
        }
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        BitmapFont bitmapFont = HexBitmapFontImporter.importFont(scanner);
        if (bitmapFont.isEmpty()) {
            return new BitmapFont[0];
        }
        return new BitmapFont[]{bitmapFont};
    }

    public BitmapFont[] importFont(File file) throws IOException {
        Scanner scanner = new Scanner((InputStream)new FileInputStream(file), "UTF-8");
        BitmapFont bitmapFont = HexBitmapFontImporter.importFont(scanner);
        scanner.close();
        if (bitmapFont.isEmpty()) {
            return new BitmapFont[0];
        }
        return new BitmapFont[]{bitmapFont};
    }

    private static BitmapFont importFont(Scanner scanner) {
        BitmapFont bitmapFont = new BitmapFont(10, 2, 14, 2, 8, 10, 0);
        block2: while (scanner.hasNextLine()) {
            int n;
            String[] stringArray = scanner.nextLine().split(":");
            if (stringArray.length != 2) continue;
            try {
                n = Integer.parseInt(stringArray[0].trim(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            char[] cArray = stringArray[1].trim().toCharArray();
            int n2 = cArray.length / 16;
            if (n2 < 1) continue;
            byte[][] byArray = new byte[16][n2 * 4];
            int n3 = 0;
            for (int i = 0; i < 16; ++i) {
                int n4 = 0;
                for (int j = 0; j < n2; ++j) {
                    int n5;
                    if ((n5 = Character.getNumericValue(cArray[n3++])) < 0 || n5 > 15) continue block2;
                    byArray[i][n4++] = (n5 & 8) != 0 ? -1 : 0;
                    byArray[i][n4++] = (n5 & 4) != 0 ? -1 : 0;
                    byArray[i][n4++] = (n5 & 2) != 0 ? -1 : 0;
                    byArray[i][n4++] = (n5 & 1) != 0 ? -1 : 0;
                }
            }
            BitmapFontGlyph bitmapFontGlyph = new BitmapFontGlyph(byArray, 0, n2 * 4, 14);
            bitmapFont.putCharacter(n, bitmapFontGlyph);
        }
        return bitmapFont;
    }
}

