/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.bitsnpicas.mover.FONDResource;
import com.kreative.rsrc.MacResource;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBundle
implements Cloneable,
Comparable<ResourceBundle> {
    public final ImageIcon icon;
    public final String moverType;
    public final String name;
    public final int id;
    public final FONDResource fond;
    public final Set<MacResource> resources;

    public ResourceBundle(ImageIcon imageIcon, String string, String string2, int n) {
        this.icon = imageIcon;
        this.moverType = string;
        this.name = string2;
        this.id = n;
        this.fond = null;
        this.resources = new HashSet<MacResource>();
    }

    public ResourceBundle(ImageIcon imageIcon, String string, FONDResource fONDResource) {
        this.icon = imageIcon;
        this.moverType = string;
        this.name = fONDResource.toString();
        this.id = fONDResource.id;
        this.fond = fONDResource;
        this.resources = new HashSet<MacResource>();
    }

    public int length() {
        int n = this.fond != null ? this.fond.length() : 0;
        for (MacResource macResource : this.resources) {
            n += macResource.data.length;
        }
        return n;
    }

    public ResourceBundle clone() {
        ResourceBundle resourceBundle;
        if (this.fond != null) {
            FONDResource fONDResource = new FONDResource(this.fond, this.fond.entries);
            resourceBundle = new ResourceBundle(this.icon, this.moverType, fONDResource);
        } else {
            resourceBundle = new ResourceBundle(this.icon, this.moverType, this.name, this.id);
        }
        for (MacResource macResource : this.resources) {
            MacResource macResource2 = new MacResource(macResource.type, macResource.id, macResource.getAttributes(), macResource.name, macResource.data);
            resourceBundle.resources.add(macResource2);
        }
        return resourceBundle;
    }

    @Override
    public int compareTo(ResourceBundle resourceBundle) {
        return ResourceBundle.compare(this, resourceBundle);
    }

    public static int compare(ResourceBundle resourceBundle, ResourceBundle resourceBundle2) {
        List<String> list = ResourceBundle.tokenize(resourceBundle.name.trim());
        List<String> list2 = ResourceBundle.tokenize(resourceBundle2.name.trim());
        for (int i = 0; i < list.size() && i < list2.size(); ++i) {
            try {
                double d = Double.parseDouble(list.get(i));
                double d2 = Double.parseDouble(list2.get(i));
                int n = Double.compare(d, d2);
                if (n == 0) continue;
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                int n = list.get(i).compareToIgnoreCase(list2.get(i));
                if (n == 0) continue;
                return n;
            }
        }
        return list.size() - list2.size();
    }

    private static List<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            int n2;
            int n3 = Character.isDigit(c) ? 1 : (n2 = Character.isLetter(c) ? 2 : 3);
            if (n2 != n) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
                n = n2;
            }
            stringBuffer.append(c);
            c = stringCharacterIterator.next();
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }
}

