/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.CmapSubtable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CmapSubtableFormat10
extends CmapSubtable {
    public int languageID = 0;
    public int firstChar = 0;
    public int[] glyphIndex = new int[0];

    public int format() {
        return 10;
    }

    public int getGlyphIndex(int n) {
        if (n >= this.firstChar && n < this.firstChar + this.glyphIndex.length) {
            return this.glyphIndex[n - this.firstChar];
        }
        return 0;
    }

    protected void compile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(10);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeInt(20 + this.glyphIndex.length * 2);
        dataOutputStream.writeInt(this.languageID);
        dataOutputStream.writeInt(this.firstChar);
        dataOutputStream.writeInt(this.glyphIndex.length);
        for (int i = 0; i < this.glyphIndex.length; ++i) {
            dataOutputStream.writeShort(this.glyphIndex[i]);
        }
    }

    protected void decompile(DataInputStream dataInputStream, int n) throws IOException {
        dataInputStream.readUnsignedShort();
        dataInputStream.readUnsignedShort();
        dataInputStream.readInt();
        this.languageID = dataInputStream.readInt();
        this.firstChar = dataInputStream.readInt();
        this.glyphIndex = new int[dataInputStream.readInt()];
        for (int i = 0; i < this.glyphIndex.length; ++i) {
            this.glyphIndex[i] = dataInputStream.readUnsignedShort();
        }
    }
}

