/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import java.io.UnsupportedEncodingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameTableEntry
implements Comparable<NameTableEntry> {
    public static final int NAME_ID_COPYRIGHT_NOTICE = 0;
    public static final int NAME_ID_FONT_FAMILY = 1;
    public static final int NAME_ID_FONT_SUBFAMILY = 2;
    public static final int NAME_ID_UNIQUE_SUBFAMILY_ID = 3;
    public static final int NAME_ID_FULL_NAME = 4;
    public static final int NAME_ID_VERSION = 5;
    public static final int NAME_ID_POSTSCRIPT_NAME = 6;
    public static final int NAME_ID_TRADEMARK_NOTICE = 7;
    public static final int NAME_ID_MANUFACTURER_NAME = 8;
    public static final int NAME_ID_DESIGNER = 9;
    public static final int NAME_ID_DESCRIPTION = 10;
    public static final int NAME_ID_FONT_VENDOR_URL = 11;
    public static final int NAME_ID_FONT_DESIGNER_URL = 12;
    public static final int NAME_ID_LICENSE_DESCRIPTION = 13;
    public static final int NAME_ID_LICENSE_INFORMATION_URL = 14;
    public static final int NAME_ID_PREFERRED_FAMILY = 16;
    public static final int NAME_ID_PREFERRED_SUBFAMILY = 17;
    public static final int NAME_ID_COMPATIBLE_FULL = 18;
    public static final int NAME_ID_SAMPLE_TEXT = 19;
    public int index;
    public int platformID;
    public int platformSpecificID;
    public int languageID;
    public int nameID;
    public byte[] nameData;
    public int padding;

    public static NameTableEntry forUnicode(int n, String string) {
        NameTableEntry nameTableEntry = new NameTableEntry();
        nameTableEntry.platformID = 0;
        nameTableEntry.platformSpecificID = 3;
        nameTableEntry.languageID = 0;
        nameTableEntry.nameID = n;
        nameTableEntry.setNameString(string);
        return nameTableEntry;
    }

    public static NameTableEntry forMacintosh(int n, String string) {
        NameTableEntry nameTableEntry = new NameTableEntry();
        nameTableEntry.platformID = 1;
        nameTableEntry.platformSpecificID = 0;
        nameTableEntry.languageID = 0;
        nameTableEntry.nameID = n;
        nameTableEntry.setNameString(string);
        return nameTableEntry;
    }

    public static NameTableEntry forWindows(int n, String string) {
        NameTableEntry nameTableEntry = new NameTableEntry();
        nameTableEntry.platformID = 3;
        nameTableEntry.platformSpecificID = 1;
        nameTableEntry.languageID = 1033;
        nameTableEntry.nameID = n;
        nameTableEntry.setNameString(string);
        return nameTableEntry;
    }

    @Override
    public int compareTo(NameTableEntry nameTableEntry) {
        if (this.index != nameTableEntry.index) {
            return this.index - nameTableEntry.index;
        }
        if (this.platformID != nameTableEntry.platformID) {
            return this.platformID - nameTableEntry.platformID;
        }
        if (this.platformSpecificID != nameTableEntry.platformSpecificID) {
            return this.platformSpecificID - nameTableEntry.platformSpecificID;
        }
        if (this.languageID != nameTableEntry.languageID) {
            return this.languageID - nameTableEntry.languageID;
        }
        if (this.nameID != nameTableEntry.nameID) {
            return this.nameID - nameTableEntry.nameID;
        }
        return 0;
    }

    public String getNameString() {
        try {
            switch (this.platformID) {
                case 0: {
                    return new String(this.nameData, "UTF-16BE");
                }
                case 1: {
                    switch (this.platformSpecificID) {
                        case 0: {
                            try {
                                return new String(this.nameData, "MacRoman");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                return new String(this.nameData, "US-ASCII");
                            }
                        }
                    }
                    throw new IllegalStateException("I have no idea how to decode this.");
                }
                case 2: {
                    return new String(this.nameData, "UTF-16BE");
                }
                case 3: 
                case 10: {
                    switch (this.platformSpecificID) {
                        case 1: {
                            return new String(this.nameData, "UTF-16BE");
                        }
                        case 10: {
                            return new String(this.nameData, "UTF-32BE");
                        }
                    }
                    throw new IllegalStateException("I have no idea how to decode this.");
                }
            }
            throw new IllegalStateException("I have no idea how to decode this.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Java is stupid.");
        }
    }

    public void setNameString(String string) {
        try {
            switch (this.platformID) {
                case 0: {
                    this.nameData = string.getBytes("UTF-16BE");
                    return;
                }
                case 1: {
                    switch (this.platformSpecificID) {
                        case 0: {
                            try {
                                this.nameData = string.getBytes("MacRoman");
                                return;
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                this.nameData = string.getBytes("US-ASCII");
                                return;
                            }
                        }
                    }
                    throw new IllegalStateException("I have no idea how to encode this.");
                }
                case 2: {
                    this.nameData = string.getBytes("UTF-16BE");
                    return;
                }
                case 3: 
                case 10: {
                    switch (this.platformSpecificID) {
                        case 1: {
                            this.nameData = string.getBytes("UTF-16BE");
                            return;
                        }
                        case 10: {
                            this.nameData = string.getBytes("UTF-32BE");
                            return;
                        }
                    }
                    throw new IllegalStateException("I have no idea how to encode this.");
                }
            }
            throw new IllegalStateException("I have no idea how to encode this.");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Java is stupid.");
        }
    }
}

