/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SbixEntry {
    public static final int IMAGE_TYPE_JPEG = 1785751328;
    public static final int IMAGE_TYPE_PDF = 1885627936;
    public static final int IMAGE_TYPE_PNG = 1886283552;
    public static final int IMAGE_TYPE_TIFF = 1953064550;
    public static final int IMAGE_TYPE_DUPE = 1685418085;
    public static final int IMAGE_TYPE_MASK = 1835103083;
    public int offsetX = 0;
    public int offsetY = 0;
    public int imageType = 0;
    public byte[] imageData = new byte[0];

    public String getImageTypeString() {
        return new String(new char[]{(char)(this.imageType >> 24 & 0xFF), (char)(this.imageType >> 16 & 0xFF), (char)(this.imageType >> 8 & 0xFF), (char)(this.imageType >> 0 & 0xFF)});
    }

    public void setImageTypeString(String string) {
        char[] cArray = string.toCharArray();
        this.imageType = (cArray.length > 0 && cArray[0] >= ' ' && cArray[0] < '\u007f' ? cArray[0] : 32) << 24 | (cArray.length > 1 && cArray[1] >= ' ' && cArray[1] < '\u007f' ? cArray[1] : 32) << 16 | (cArray.length > 2 && cArray[2] >= ' ' && cArray[2] < '\u007f' ? cArray[2] : 32) << 8 | (cArray.length > 3 && cArray[3] >= ' ' && cArray[3] < '\u007f' ? cArray[3] : 32) << 0;
    }

    private void compile(DataOutputStream dataOutputStream) throws IOException {
        if (this.imageData != null && this.imageData.length > 0) {
            dataOutputStream.writeShort(this.offsetX);
            dataOutputStream.writeShort(this.offsetY);
            dataOutputStream.writeInt(this.imageType);
            dataOutputStream.write(this.imageData);
        }
    }

    public byte[] compile() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.compile(dataOutputStream);
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        dataOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void decompile(DataInputStream dataInputStream, int n) throws IOException {
        if (n == 0) {
            this.offsetX = 0;
            this.offsetY = 0;
            this.imageType = 0;
            this.imageData = new byte[0];
        } else {
            this.offsetX = dataInputStream.readShort();
            this.offsetY = dataInputStream.readShort();
            this.imageType = dataInputStream.readInt();
            this.imageData = new byte[n - 8];
            dataInputStream.readFully(this.imageData);
        }
    }

    public void decompile(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.decompile(dataInputStream, byArray.length);
        dataInputStream.close();
        byteArrayInputStream.close();
    }
}

