/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.ListBasedTable;
import com.kreative.bitsnpicas.truetype.MaxpTable;
import com.kreative.bitsnpicas.truetype.SbixSubtable;
import com.kreative.bitsnpicas.truetype.TrueTypeTable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SbixTable
extends ListBasedTable<SbixSubtable> {
    public static final int VERSION_DEFAULT = 1;
    public static final int FLAGS_DEFAULT = 1;
    public static final int FLAGS_DRAW_OUTLINES = 2;
    public int version = 1;
    public int flags = 1;

    @Override
    public String tableName() {
        return "sbix";
    }

    @Override
    public String[] dependencyNames() {
        return new String[]{"maxp"};
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n = ((MaxpTable)trueTypeTableArray[0]).numGlyphs;
        dataOutputStream.writeShort(this.version);
        dataOutputStream.writeShort(this.flags);
        dataOutputStream.writeInt(this.size());
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n2 = 8 + this.size() * 4;
        for (Object object : this) {
            dataOutputStream.writeInt(n2);
            byte[] byArray = ((SbixSubtable)object).compile(n);
            arrayList.add(byArray);
            n2 += byArray.length;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (byte[])iterator.next();
            dataOutputStream.write((byte[])object);
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n, TrueTypeTable[] trueTypeTableArray) throws IOException {
        int n2;
        int n3 = ((MaxpTable)trueTypeTableArray[0]).numGlyphs;
        this.version = dataInputStream.readUnsignedShort();
        this.flags = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readInt();
        int[] nArray = new int[n4 + 1];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = dataInputStream.readInt();
        }
        nArray[n4] = n;
        this.clear();
        for (n2 = 0; n2 < n4; ++n2) {
            dataInputStream.reset();
            dataInputStream.skipBytes(nArray[n2]);
            byte[] byArray = new byte[nArray[n2 + 1] - nArray[n2]];
            dataInputStream.readFully(byArray);
            SbixSubtable sbixSubtable = new SbixSubtable();
            sbixSubtable.decompile(byArray, n3);
            this.add(sbixSubtable);
        }
    }
}

