{
"#pragma parameter SPOT_WIDTH \"CRTCaligari Spot Width\" 0.9 0.1 1.5 0.05\n"
"#pragma parameter SPOT_HEIGHT \"CRTCaligari Spot Height\" 0.65 0.1 1.5 0.05\n"
"#pragma parameter COLOR_BOOST \"CRTCaligari Color Boost\" 1.45 1.0 2.0 0.05\n"
"#pragma parameter InputGamma \"CRTCaligari Input Gamma\" 2.4 0.0 5.0 0.1\n"
"#pragma parameter OutputGamma \"CRTCaligari Output Gamma\" 2.2 0.0 5.0 0.1\n"
"\n"
"#ifdef PARAMETER_UNIFORM\n"
"uniform float SPOT_WIDTH;\n"
"uniform float SPOT_HEIGHT;\n"
"uniform float COLOR_BOOST;\n"
"uniform float InputGamma;\n"
"uniform float OutputGamma;\n"
"#else\n"
"// 0.5 = the spot stays inside the original pixel\n"
"// 1.0 = the spot bleeds up to the center of next pixel\n"
"#define SPOT_WIDTH  0.9\n"
"#define SPOT_HEIGHT 0.65\n"
"// Used to counteract the desaturation effect of weighting.\n"
"#define COLOR_BOOST 1.45\n"
"// Constants used with gamma correction.\n"
"#define InputGamma 2.4\n"
"#define OutputGamma 2.2\n"
"#endif\n"
"\n"
"/* COMPATIBILITY \n"
"   - HLSL compilers\n"
"   - Cg   compilers\n"
"*/\n"
"\n"
"/*\n"
"    Phosphor shader - Copyright (C) 2011 caligari.\n"
"\n"
"    Ported by Hyllian.\n"
"\n"
"   This program is free software; you can redistribute it and/or\n"
"   modify it under the terms of the GNU General Public License\n"
"   as published by the Free Software Foundation; either version 2\n"
"   of the License, or (at your option) any later version.\n"
"\n"
"   This program is distributed in the hope that it will be useful,\n"
"   but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
"   GNU General Public License for more details.\n"
"\n"
"   You should have received a copy of the GNU General Public License\n"
"   along with this program; if not, write to the Free Software\n"
"   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n"
"\n"
"*/\n"
"\n"
"struct tex_coords\n"
"{\n"
"   float2 texCoord : TEXCOORD0;\n"
"   float2 onex;\n"
"   float2 oney;\n"
"};\n"
"\n"
"struct input\n"
"{\n"
"  float2 video_size;\n"
"  float2 texture_size;\n"
"  float2 output_size;\n"
"  float  frame_count;\n"
"  float  frame_direction;\n"
"  float frame_rotation;\n"
"};\n"
"\n"
"/* Default Vertex shader */\n"
"void main_vertex\n"
"(\n"
"   float4 position : POSITION,\n"
"   out float4 oPosition : POSITION,\n"
"   uniform float4x4 modelViewProj,\n"
"\n"
"   float4 color : COLOR,\n"
"   out float4 oColor : COLOR,\n"
"\n"
"   float2 tex : TEXCOORD,\n"
"\n"
"   uniform input IN,\n"
"   out tex_coords coords : TEXCOORD1\n"
" )\n"
"{\n"
"   oPosition = mul(modelViewProj, position);\n"
"   oColor = color;\n"
"\n"
"   coords.texCoord = tex + float2(0.0, 0.0);\n"
"   coords.onex = float2(1.0 / IN.texture_size.x, 0.0);\n"
"   coords.oney = float2(0.0, 1.0 / IN.texture_size.y);\n"
"}\n"
"\n"
"#define GAMMA_IN(color)     pow(color, float4(InputGamma, InputGamma, InputGamma, InputGamma))\n"
"#define GAMMA_OUT(color)    pow(color, float4(1.0 / OutputGamma, 1.0 / OutputGamma, 1.0 / OutputGamma, 1.0 / OutputGamma))\n"
"\n"
"#define TEX2D(coords)	GAMMA_IN( tex2D(s_p, coords) )\n"
"\n"
"// Macro for weights computing\n"
"#define WEIGHT(w) \\\n"
"   if(w>1.0) w=1.0; \\\n"
"w = 1.0 - w * w; \\\n"
"w = w * w;\n"
"\n"
"\n"
"float4 main_fragment(in tex_coords co : TEXCOORD1, uniform input IN, uniform sampler2D s_p : TEXUNIT0) : COLOR\n"
"{\n"
"   float2 coords = ( co.texCoord * IN.texture_size );\n"
"   float2 pixel_center = floor( coords ) + float2(0.5, 0.5);\n"
"   float2 texture_coords = pixel_center / IN.texture_size;\n"
"\n"
"   float4 color = TEX2D( texture_coords );\n"
"\n"
"   float dx = coords.x - pixel_center.x;\n"
"\n"
"   float h_weight_00 = dx / SPOT_WIDTH;\n"
"   WEIGHT(h_weight_00);\n"
"\n"
"   color *= float4( h_weight_00, h_weight_00, h_weight_00, h_weight_00  );\n"
"\n"
"   // get closest horizontal neighbour to blend\n"
"   float2 coords01;\n"
"   if (dx>0.0) {\n"
"      coords01 = co.onex;\n"
"      dx = 1.0 - dx;\n"
"   } else {\n"
"      coords01 = -co.onex;\n"
"      dx = 1.0 + dx;\n"
"   }\n"
"   float4 colorNB = TEX2D( texture_coords + coords01 );\n"
"\n"
"   float h_weight_01 = dx / SPOT_WIDTH;\n"
"   WEIGHT( h_weight_01 );\n"
"\n"
"   color = color + colorNB * float4( h_weight_01, h_weight_01, h_weight_01, h_weight_01 );\n"
"\n"
"   //////////////////////////////////////////////////////\n"
"   // Vertical Blending\n"
"   float dy = coords.y - pixel_center.y;\n"
"   float v_weight_00 = dy / SPOT_HEIGHT;\n"
"   WEIGHT(v_weight_00);\n"
"   color *= float4( v_weight_00, v_weight_00, v_weight_00, v_weight_00 );\n"
"\n"
"   // get closest vertical neighbour to blend\n"
"   float2 coords10;\n"
"   if (dy>0.0) {\n"
"      coords10 = co.oney;\n"
"      dy = 1.0 - dy;\n"
"   } else {\n"
"      coords10 = -co.oney;\n"
"      dy = 1.0 + dy;\n"
"   }\n"
"   colorNB = TEX2D( texture_coords + coords10 );\n"
"\n"
"   float v_weight_10 = dy / SPOT_HEIGHT;\n"
"   WEIGHT( v_weight_10 );\n"
"\n"
"   color = color + colorNB * float4( v_weight_10 * h_weight_00, v_weight_10 * h_weight_00, v_weight_10 * h_weight_00, v_weight_10 * h_weight_00 );\n"
"\n"
"   colorNB = TEX2D(  texture_coords + coords01 + coords10 );\n"
"\n"
"   color = color + colorNB * float4( v_weight_10 * h_weight_01, v_weight_10 * h_weight_01, v_weight_10 * h_weight_01, v_weight_10 * h_weight_01 );\n"
"\n"
"   color *= float4( COLOR_BOOST, COLOR_BOOST, COLOR_BOOST, COLOR_BOOST );\n"
"\n"
"\n"
"   return clamp( GAMMA_OUT(color), 0.0, 1.0 );\n"
"}\n"
"\n"
"\n"
"\n"
},
