{
"/*\n"
"    CRT-interlaced\n"
"\n"
"    Copyright (C) 2010-2012 cgwg, Themaister and DOLLS\n"
"\n"
"    This program is free software; you can redistribute it and/or modify it\n"
"    under the terms of the GNU General Public License as published by the Free\n"
"    Software Foundation; either version 2 of the License, or (at your option)\n"
"    any later version.\n"
"\n"
"    (cgwg gave their consent to have the original version of this shader\n"
"    distributed under the GPL in this message:\n"
"\n"
"        http://board.byuu.org/viewtopic.php?p=26075#p26075\n"
"\n"
"        \"Feel free to distribute my shaders under the GPL. After all, the\n"
"        barrel distortion code was taken from the Curvature shader, which is\n"
"        under the GPL.\"\n"
"    )\n"
"	This shader variant is pre-configured with screen curvature\n"
"*/\n"
"\n"
"#pragma parameter CRTgamma \"CRTGeom Target Gamma\" 2.4 0.1 5.0 0.1\n"
"#pragma parameter monitorgamma \"CRTGeom Monitor Gamma\" 2.2 0.1 5.0 0.1\n"
"#pragma parameter d \"CRTGeom Distance\" 1.5 0.1 3.0 0.1\n"
"#pragma parameter CURVATURE \"CRTGeom Curvature Toggle\" 1.0 0.0 1.0 1.0\n"
"#pragma parameter R \"CRTGeom Curvature Radius\" 2.0 0.1 10.0 0.1\n"
"#pragma parameter cornersize \"CRTGeom Corner Size\" 0.03 0.001 1.0 0.005\n"
"#pragma parameter cornersmooth \"CRTGeom Corner Smoothness\" 1000.0 80.0 2000.0 100.0\n"
"#pragma parameter x_tilt \"CRTGeom Horizontal Tilt\" 0.0 -0.5 0.5 0.05\n"
"#pragma parameter y_tilt \"CRTGeom Vertical Tilt\" 0.0 -0.5 0.5 0.05\n"
"#pragma parameter overscan_x \"CRTGeom Horiz. Overscan %\" 100.0 -125.0 125.0 1.0\n"
"#pragma parameter overscan_y \"CRTGeom Vert. Overscan %\" 100.0 -125.0 125.0 1.0\n"
"#pragma parameter DOTMASK \"CRTGeom Dot Mask Strength\" 0.3 0.0 1.0 0.1\n"
"#pragma parameter SHARPER \"CRTGeom Sharpness\" 1.0 1.0 3.0 1.0\n"
"#pragma parameter scanline_weight \"CRTGeom Scanline Weight\" 0.3 0.1 0.5 0.05\n"
"#pragma parameter lum \"CRTGeom Luminance\" 0.0 0.0 1.0 0.01\n"
"#pragma parameter interlace_detect \"CRTGeom Interlacing Simulation\" 0.0 0.0 1.0 1.0\n"
"#pragma parameter SATURATION \"CRTGeom Saturation\" 1.0 0.0 2.0 0.05\n"
"\n"
"#ifndef PARAMETER_UNIFORM\n"
"#define CRTgamma 2.4\n"
"#define monitorgamma 2.2\n"
"#define d 1.6\n"
"#define CURVATURE 1.0\n"
"#define R 2.0\n"
"#define cornersize 0.03\n"
"#define cornersmooth 1000.0\n"
"#define x_tilt 0.0\n"
"#define y_tilt 0.0\n"
"#define overscan_x 100.0\n"
"#define overscan_y 100.0\n"
"#define DOTMASK 0.3\n"
"#define SHARPER 1.0\n"
"#define scanline_weight 0.3\n"
"#define lum 0.0\n"
"#define interlace_detect 1.0\n"
"#define SATURATION 1.0\n"
"#endif\n"
"\n"
"#if defined(VERTEX)\n"
"\n"
"#if __VERSION__ >= 130\n"
"#define COMPAT_VARYING out\n"
"#define COMPAT_ATTRIBUTE in\n"
"#define COMPAT_TEXTURE texture\n"
"#else\n"
"#define COMPAT_VARYING varying \n"
"#define COMPAT_ATTRIBUTE attribute \n"
"#define COMPAT_TEXTURE texture2D\n"
"#endif\n"
"\n"
"#ifdef GL_ES\n"
"#define COMPAT_PRECISION mediump\n"
"#else\n"
"#define COMPAT_PRECISION\n"
"#endif\n"
"\n"
"COMPAT_ATTRIBUTE vec4 VertexCoord;\n"
"COMPAT_ATTRIBUTE vec4 COLOR;\n"
"COMPAT_ATTRIBUTE vec4 TexCoord;\n"
"COMPAT_VARYING vec4 COL0;\n"
"COMPAT_VARYING vec4 TEX0;\n"
"\n"
"vec4 _oPosition1; \n"
"uniform mat4 MVPMatrix;\n"
"uniform COMPAT_PRECISION int FrameDirection;\n"
"uniform COMPAT_PRECISION int FrameCount;\n"
"uniform COMPAT_PRECISION vec2 OutputSize;\n"
"uniform COMPAT_PRECISION vec2 TextureSize;\n"
"uniform COMPAT_PRECISION vec2 InputSize;\n"
"\n"
"COMPAT_VARYING vec2 overscan;\n"
"COMPAT_VARYING vec2 aspect;\n"
"COMPAT_VARYING vec3 stretch;\n"
"COMPAT_VARYING vec2 sinangle;\n"
"COMPAT_VARYING vec2 cosangle;\n"
"COMPAT_VARYING vec2 one;\n"
"COMPAT_VARYING float mod_factor;\n"
"COMPAT_VARYING vec2 ilfac;\n"
"\n"
"#ifdef PARAMETER_UNIFORM\n"
"uniform COMPAT_PRECISION float CRTgamma;\n"
"uniform COMPAT_PRECISION float monitorgamma;\n"
"uniform COMPAT_PRECISION float d;\n"
"uniform COMPAT_PRECISION float CURVATURE;\n"
"uniform COMPAT_PRECISION float R;\n"
"uniform COMPAT_PRECISION float cornersize;\n"
"uniform COMPAT_PRECISION float cornersmooth;\n"
"uniform COMPAT_PRECISION float x_tilt;\n"
"uniform COMPAT_PRECISION float y_tilt;\n"
"uniform COMPAT_PRECISION float overscan_x;\n"
"uniform COMPAT_PRECISION float overscan_y;\n"
"uniform COMPAT_PRECISION float DOTMASK;\n"
"uniform COMPAT_PRECISION float SHARPER;\n"
"uniform COMPAT_PRECISION float scanline_weight;\n"
"uniform COMPAT_PRECISION float lum;\n"
"uniform COMPAT_PRECISION float interlace_detect;\n"
"uniform COMPAT_PRECISION float SATURATION;\n"
"#endif\n"
"\n"
"#define FIX(c) max(abs(c), 1e-5);\n"
"\n"
"float intersect(vec2 xy)\n"
"        {\n"
"	float A = dot(xy,xy)+d*d;\n"
"	float B = 2.0*(R*(dot(xy,sinangle)-d*cosangle.x*cosangle.y)-d*d);\n"
"	float C = d*d + 2.0*R*d*cosangle.x*cosangle.y;\n"
"	return (-B-sqrt(B*B-4.0*A*C))/(2.0*A);\n"
"        }\n"
"\n"
"vec2 bkwtrans(vec2 xy)\n"
"        {\n"
"	float c = intersect(xy);\n"
"	vec2 point = vec2(c)*xy;\n"
"	point -= vec2(-R)*sinangle;\n"
"	point /= vec2(R);\n"
"	vec2 tang = sinangle/cosangle;\n"
"	vec2 poc = point/cosangle;\n"
"	float A = dot(tang,tang)+1.0;\n"
"	float B = -2.0*dot(poc,tang);\n"
"	float C = dot(poc,poc)-1.0;\n"
"	float a = (-B+sqrt(B*B-4.0*A*C))/(2.0*A);\n"
"	vec2 uv = (point-a*sinangle)/cosangle;\n"
"	float r = FIX(R*acos(a));\n"
"	return uv*r/sin(r/R);\n"
"        }\n"
"\n"
"vec2 fwtrans(vec2 uv)\n"
"        {\n"
"	float r = FIX(sqrt(dot(uv,uv)));\n"
"	uv *= sin(r/R)/r;\n"
"	float x = 1.0-cos(r/R);\n"
"	float D = d/R + x*cosangle.x*cosangle.y+dot(uv,sinangle);\n"
"	return d*(uv*cosangle-x*sinangle)/D;\n"
"        }\n"
"\n"
"vec3 maxscale()\n"
"        {\n"
"	vec2 c = bkwtrans(-R * sinangle / (1.0 + R/d*cosangle.x*cosangle.y));\n"
"	vec2 a = vec2(0.5,0.5)*aspect;\n"
"	vec2 lo = vec2(fwtrans(vec2(-a.x,c.y)).x, fwtrans(vec2(c.x,-a.y)).y)/aspect;\n"
"	vec2 hi = vec2(fwtrans(vec2(+a.x,c.y)).x, fwtrans(vec2(c.x,+a.y)).y)/aspect;\n"
"	return vec3((hi+lo)*aspect*0.5,max(hi.x-lo.x,hi.y-lo.y));\n"
"        }\n"
"\n"
"void main()\n"
"{\n"
"// START of parameters\n"
"\n"
"// gamma of simulated CRT\n"
"//	CRTgamma = 1.8;\n"
"// gamma of display monitor (typically 2.2 is correct)\n"
"//	monitorgamma = 2.2;\n"
"// overscan (e.g. 1.02 for 2% overscan)\n"
"	overscan = vec2(1.00,1.00);\n"
"// aspect ratio\n"
"	aspect = vec2(1.0, 0.75);\n"
"// lengths are measured in units of (approximately) the width\n"
"// of the monitor simulated distance from viewer to monitor\n"
"//	d = 2.0;\n"
"// radius of curvature\n"
"//	R = 1.5;\n"
"// tilt angle in radians\n"
"// (behavior might be a bit wrong if both components are\n"
"// nonzero)\n"
"	const vec2 angle = vec2(0.0,0.0);\n"
"// size of curved corners\n"
"//	cornersize = 0.03;\n"
"// border smoothness parameter\n"
"// decrease if borders are too aliased\n"
"//	cornersmooth = 1000.0;\n"
"\n"
"// END of parameters\n"
"\n"
"    vec4 _oColor;\n"
"    vec2 _otexCoord;\n"
"    gl_Position = VertexCoord.x * MVPMatrix[0] + VertexCoord.y * MVPMatrix[1] + VertexCoord.z * MVPMatrix[2] + VertexCoord.w * MVPMatrix[3];\n"
"    _oPosition1 = gl_Position;\n"
"    _oColor = COLOR;\n"
"    _otexCoord = TexCoord.xy*1.0001;\n"
"    COL0 = COLOR;\n"
"    TEX0.xy = TexCoord.xy*1.0001;\n"
"\n"
"// Precalculate a bunch of useful values we'll need in the fragment\n"
"// shader.\n"
"	sinangle = sin(vec2(x_tilt, y_tilt)) + vec2(0.001);//sin(vec2(max(abs(x_tilt), 1e-3), max(abs(y_tilt), 1e-3)));\n"
"	cosangle = cos(vec2(x_tilt, y_tilt)) + vec2(0.001);//cos(vec2(max(abs(x_tilt), 1e-3), max(abs(y_tilt), 1e-3)));\n"
"	stretch = maxscale();\n"
"\n"
"	ilfac = vec2(1.0,clamp(floor(InputSize.y/(200.0*(1.0-interlace_detect))), 1.0, 2.0));\n"
"\n"
"// The size of one texel, in texture-coordinates.\n"
"	vec2 sharpTextureSize = vec2(SHARPER * TextureSize.x, TextureSize.y);\n"
"	one = ilfac / sharpTextureSize;\n"
"\n"
"// Resulting X pixel-coordinate of the pixel we're drawing.\n"
"	mod_factor = TexCoord.x * TextureSize.x * OutputSize.x / InputSize.x;\n"
"\n"
"}\n"
"\n"
"#elif defined(FRAGMENT)\n"
"\n"
"#if __VERSION__ >= 130\n"
"#define COMPAT_VARYING in\n"
"#define COMPAT_TEXTURE texture\n"
"out vec4 FragColor;\n"
"#else\n"
"#define COMPAT_VARYING varying\n"
"#define FragColor gl_FragColor\n"
"#define COMPAT_TEXTURE texture2D\n"
"#endif\n"
"\n"
"#ifdef GL_ES\n"
"#ifdef GL_FRAGMENT_PRECISION_HIGH\n"
"precision highp float;\n"
"#else\n"
"precision mediump float;\n"
"#endif\n"
"#define COMPAT_PRECISION mediump\n"
"#else\n"
"#define COMPAT_PRECISION\n"
"#endif\n"
"\n"
"struct output_dummy {\n"
"    vec4 _color;\n"
"};\n"
"\n"
"uniform COMPAT_PRECISION int FrameDirection;\n"
"uniform COMPAT_PRECISION int FrameCount;\n"
"uniform COMPAT_PRECISION vec2 OutputSize;\n"
"uniform COMPAT_PRECISION vec2 TextureSize;\n"
"uniform COMPAT_PRECISION vec2 InputSize;\n"
"uniform sampler2D Texture;\n"
"COMPAT_VARYING vec4 TEX0;\n"
"\n"
"// Comment the next line to disable interpolation in linear gamma (and\n"
"// gain speed).\n"
"	#define LINEAR_PROCESSING\n"
"\n"
"// Enable screen curvature.\n"
"//        #define CURVATURE\n"
"\n"
"// Enable 3x oversampling of the beam profile\n"
"        #define OVERSAMPLE\n"
"\n"
"// Use the older, purely gaussian beam profile\n"
"        //#define USEGAUSSIAN\n"
"\n"
"// Macros.\n"
"#define FIX(c) max(abs(c), 1e-5);\n"
"#define PI 3.141592653589\n"
"\n"
"#ifdef LINEAR_PROCESSING\n"
"#       define TEX2D(c) pow(COMPAT_TEXTURE(Texture, (c)), vec4(CRTgamma))\n"
"#else\n"
"#       define TEX2D(c) COMPAT_TEXTURE(Texture, (c))\n"
"#endif\n"
"\n"
"COMPAT_VARYING vec2 one;\n"
"COMPAT_VARYING float mod_factor;\n"
"COMPAT_VARYING vec2 ilfac;\n"
"COMPAT_VARYING vec2 overscan;\n"
"COMPAT_VARYING vec2 aspect;\n"
"COMPAT_VARYING vec3 stretch;\n"
"COMPAT_VARYING vec2 sinangle;\n"
"COMPAT_VARYING vec2 cosangle;\n"
"\n"
"#ifdef PARAMETER_UNIFORM\n"
"uniform COMPAT_PRECISION float CRTgamma;\n"
"uniform COMPAT_PRECISION float monitorgamma;\n"
"uniform COMPAT_PRECISION float d;\n"
"uniform COMPAT_PRECISION float CURVATURE;\n"
"uniform COMPAT_PRECISION float R;\n"
"uniform COMPAT_PRECISION float cornersize;\n"
"uniform COMPAT_PRECISION float cornersmooth;\n"
"uniform COMPAT_PRECISION float x_tilt;\n"
"uniform COMPAT_PRECISION float y_tilt;\n"
"uniform COMPAT_PRECISION float overscan_x;\n"
"uniform COMPAT_PRECISION float overscan_y;\n"
"uniform COMPAT_PRECISION float DOTMASK;\n"
"uniform COMPAT_PRECISION float SHARPER;\n"
"uniform COMPAT_PRECISION float scanline_weight;\n"
"uniform COMPAT_PRECISION float lum;\n"
"uniform COMPAT_PRECISION float interlace_detect;\n"
"uniform COMPAT_PRECISION float SATURATION;\n"
"#endif\n"
"\n"
"float intersect(vec2 xy)\n"
"        {\n"
"	float A = dot(xy,xy)+d*d;\n"
"	float B = 2.0*(R*(dot(xy,sinangle)-d*cosangle.x*cosangle.y)-d*d);\n"
"	float C = d*d + 2.0*R*d*cosangle.x*cosangle.y;\n"
"	return (-B-sqrt(B*B-4.0*A*C))/(2.0*A);\n"
"        }\n"
"\n"
"vec2 bkwtrans(vec2 xy)\n"
"        {\n"
"	float c = intersect(xy);\n"
"	vec2 point = vec2(c)*xy;\n"
"	point -= vec2(-R)*sinangle;\n"
"	point /= vec2(R);\n"
"	vec2 tang = sinangle/cosangle;\n"
"	vec2 poc = point/cosangle;\n"
"	float A = dot(tang,tang)+1.0;\n"
"	float B = -2.0*dot(poc,tang);\n"
"	float C = dot(poc,poc)-1.0;\n"
"	float a = (-B+sqrt(B*B-4.0*A*C))/(2.0*A);\n"
"	vec2 uv = (point-a*sinangle)/cosangle;\n"
"	float r = FIX(R*acos(a));\n"
"	return uv*r/sin(r/R);\n"
"        }\n"
"\n"
"vec2 transform(vec2 coord)\n"
"        {\n"
"	coord *= TextureSize / InputSize;\n"
"	coord = (coord-vec2(0.5))*aspect*stretch.z+stretch.xy;\n"
"	return (bkwtrans(coord)/vec2(overscan_x / 100.0, overscan_y / 100.0)/aspect+vec2(0.5)) * InputSize / TextureSize;\n"
"        }\n"
"\n"
"float corner(vec2 coord)\n"
"        {\n"
"	coord *= TextureSize / InputSize;\n"
"	coord = (coord - vec2(0.5)) * vec2(overscan_x / 100.0, overscan_y / 100.0) + vec2(0.5);\n"
"	coord = min(coord, vec2(1.0)-coord) * aspect;\n"
"	vec2 cdist = vec2(cornersize);\n"
"	coord = (cdist - min(coord,cdist));\n"
"	float dist = sqrt(dot(coord,coord));\n"
"	return clamp((cdist.x-dist)*cornersmooth,0.0, 1.0)*1.0001;\n"
"        }\n"
"\n"
"// Calculate the influence of a scanline on the current pixel.\n"
"//\n"
"// 'distance' is the distance in texture coordinates from the current\n"
"// pixel to the scanline in question.\n"
"// 'color' is the colour of the scanline at the horizontal location of\n"
"// the current pixel.\n"
"vec4 scanlineWeights(float distance, vec4 color)\n"
"        {\n"
"	// \"wid\" controls the width of the scanline beam, for each RGB\n"
"	// channel The \"weights\" lines basically specify the formula\n"
"	// that gives you the profile of the beam, i.e. the intensity as\n"
"	// a function of distance from the vertical center of the\n"
"	// scanline. In this case, it is gaussian if width=2, and\n"
"	// becomes nongaussian for larger widths. Ideally this should\n"
"	// be normalized so that the integral across the beam is\n"
"	// independent of its width. That is, for a narrower beam\n"
"	// \"weights\" should have a higher peak at the center of the\n"
"	// scanline than for a wider beam.\n"
"#ifdef USEGAUSSIAN\n"
"	vec4 wid = 0.3 + 0.1 * pow(color, vec4(3.0));\n"
"	vec4 weights = vec4(distance / wid);\n"
"	return (lum + 0.4) * exp(-weights * weights) / wid;\n"
"#else\n"
"	vec4 wid = 2.0 + 2.0 * pow(color, vec4(4.0));\n"
"	vec4 weights = vec4(distance / scanline_weight);\n"
"	return (lum + 1.4) * exp(-pow(weights * inversesqrt(0.5 * wid), wid)) / (0.6 + 0.2 * wid);\n"
"#endif\n"
"        }\n"
"\n"
"vec3 saturation (vec3 textureColor)\n"
"{\n"
"    float lum=length(textureColor)*0.5775;\n"
"\n"
"    vec3 luminanceWeighting = vec3(0.3,0.6,0.1);\n"
"    if (lum<0.5) luminanceWeighting.rgb=(luminanceWeighting.rgb*luminanceWeighting.rgb)+(luminanceWeighting.rgb*luminanceWeighting.rgb);\n"
"\n"
"    float luminance = dot(textureColor, luminanceWeighting);\n"
"    vec3 greyScaleColor = vec3(luminance);\n"
"\n"
"    vec3 res = vec3(mix(greyScaleColor, textureColor, SATURATION));\n"
"    return res;\n"
"}\n"
"\n"
"\n"
"void main()\n"
"{\n"
"// Here's a helpful diagram to keep in mind while trying to\n"
"// understand the code:\n"
"//\n"
"//  |      |      |      |      |\n"
"// -------------------------------\n"
"//  |      |      |      |      |\n"
"//  |  01  |  11  |  21  |  31  | <-- current scanline\n"
"//  |      | @    |      |      |\n"
"// -------------------------------\n"
"//  |      |      |      |      |\n"
"//  |  02  |  12  |  22  |  32  | <-- next scanline\n"
"//  |      |      |      |      |\n"
"// -------------------------------\n"
"//  |      |      |      |      |\n"
"//\n"
"// Each character-cell represents a pixel on the output\n"
"// surface, \"@\" represents the current pixel (always somewhere\n"
"// in the bottom half of the current scan-line, or the top-half\n"
"// of the next scanline). The grid of lines represents the\n"
"// edges of the texels of the underlying texture.\n"
"\n"
"// Texture coordinates of the texel containing the active pixel.\n"
"	vec2 xy = (CURVATURE > 0.5) ? transform(TEX0.xy) : TEX0.xy;\n"
"\n"
"	float cval = corner(xy);\n"
"\n"
"// Of all the pixels that are mapped onto the texel we are\n"
"// currently rendering, which pixel are we currently rendering?\n"
"	vec2 ilvec = vec2(0.0,ilfac.y > 1.5 ? mod(float(FrameCount),2.0) : 0.0);\n"
"	vec2 ratio_scale = (xy * TextureSize - vec2(0.5) + ilvec)/ilfac;\n"
"#ifdef OVERSAMPLE\n"
"	float filter_ = InputSize.y/OutputSize.y;//fwidth(ratio_scale.y);\n"
"#endif\n"
"	vec2 uv_ratio = fract(ratio_scale);\n"
"\n"
"// Snap to the center of the underlying texel.\n"
"	xy = (floor(ratio_scale)*ilfac + vec2(0.5) - ilvec) / TextureSize;\n"
"\n"
"// Calculate Lanczos scaling coefficients describing the effect\n"
"// of various neighbour texels in a scanline on the current\n"
"// pixel.\n"
"	vec4 coeffs = PI * vec4(1.0 + uv_ratio.x, uv_ratio.x, 1.0 - uv_ratio.x, 2.0 - uv_ratio.x);\n"
"\n"
"// Prevent division by zero.\n"
"	coeffs = FIX(coeffs);\n"
"\n"
"// Lanczos2 kernel.\n"
"	coeffs = 2.0 * sin(coeffs) * sin(coeffs / 2.0) / (coeffs * coeffs);\n"
"\n"
"// Normalize.\n"
"	coeffs /= dot(coeffs, vec4(1.0));\n"
"\n"
"// Calculate the effective colour of the current and next\n"
"// scanlines at the horizontal location of the current pixel,\n"
"// using the Lanczos coefficients above.\n"
"	vec4 col  = clamp(mat4(\n"
"                        TEX2D(xy + vec2(-one.x, 0.0)),\n"
"                        TEX2D(xy),\n"
"                        TEX2D(xy + vec2(one.x, 0.0)),\n"
"                        TEX2D(xy + vec2(2.0 * one.x, 0.0))) * coeffs,\n"
"                        0.0, 1.0);\n"
"        vec4 col2 = clamp(mat4(\n"
"                        TEX2D(xy + vec2(-one.x, one.y)),\n"
"                        TEX2D(xy + vec2(0.0, one.y)),\n"
"                        TEX2D(xy + one),\n"
"                        TEX2D(xy + vec2(2.0 * one.x, one.y))) * coeffs,\n"
"                        0.0, 1.0);\n"
"\n"
"#ifndef LINEAR_PROCESSING\n"
"	col  = pow(col , vec4(CRTgamma));\n"
"	col2 = pow(col2, vec4(CRTgamma));\n"
"#endif\n"
"\n"
"// Calculate the influence of the current and next scanlines on\n"
"// the current pixel.\n"
"	vec4 weights  = scanlineWeights(uv_ratio.y, col);\n"
"	vec4 weights2 = scanlineWeights(1.0 - uv_ratio.y, col2);\n"
"#ifdef OVERSAMPLE\n"
"	uv_ratio.y =uv_ratio.y+1.0/3.0*filter_;\n"
"	weights = (weights+scanlineWeights(uv_ratio.y, col))/3.0;\n"
"	weights2=(weights2+scanlineWeights(abs(1.0-uv_ratio.y), col2))/3.0;\n"
"	uv_ratio.y =uv_ratio.y-2.0/3.0*filter_;\n"
"	weights=weights+scanlineWeights(abs(uv_ratio.y), col)/3.0;\n"
"	weights2=weights2+scanlineWeights(abs(1.0-uv_ratio.y), col2)/3.0;\n"
"#endif\n"
"\n"
"	vec3 mul_res  = (col * weights + col2 * weights2).rgb * vec3(cval);\n"
"\n"
"// dot-mask emulation:\n"
"// Output pixels are alternately tinted green and magenta.\n"
"vec3 dotMaskWeights = mix(\n"
"	vec3(1.0, 1.0 - DOTMASK, 1.0),\n"
"	vec3(1.0 - DOTMASK, 1.0, 1.0 - DOTMASK),\n"
"	floor(mod(mod_factor, 2.0))\n"
"        );\n"
"\n"
"	mul_res *= dotMaskWeights;\n"
"\n"
"// Convert the image gamma for display on our output device.\n"
"	mul_res = pow(mul_res, vec3(1.0 / monitorgamma));\n"
"        mul_res = saturation(mul_res);\n"
"\n"
"// Color the texel.\n"
"    output_dummy _OUT;\n"
"    _OUT._color = vec4(mul_res, 1.0);\n"
"    FragColor = vec4(_OUT._color.rgb, 1.0);\n"
"    return;\n"
"} \n"
"#endif\n"
},
