## `--ignore-beams` flag

The `--ignore-beams` option disables the automatic beam-energy consistency check that normally occurs during the analysis initialisation phase.

### Default behaviour

For most analysis routines corresponding to experimental measurements, the centre-of-mass energy is specified in the analysis `.info` file.
During initialisation, Rivet checks the beam configuration in the input HepMC events against the allowed energies listed in the `.info` file.

If none of the allowed energies match, the analysis routine is **disabled** and will not run.

### Behaviour with `--ignore-beams`

When `--ignore-beams` is supplied, this energy cross-check is **skipped**.
This allows analyses to be executed even if the event sample's beam energy does not exactly match the values listed in the `.info` file.

This can be useful, for example, when testing or validating analyses with Monte Carlo samples at slightly different energies.

>>> [!caution]
The `--ignore-beams` flag is only safe to use for analyses that correspond to **a single centre-of-mass energy**.
For analyses covering multiple energies, Rivet cannot determine which subset of histograms should be filled.
In such cases, use the `ENERGY` option (see below) to explicitly set which energy the analysis should assume.
>>>

### Overriding beam energy

The `ENERGY` option can be used to **force an analysis to assume a specific centre-of-mass energy**,
regardless of the actual beam configuration in the HepMC events. This option can be used, for example,
to select which histograms are filled in analyses that include results for multiple energies.

Example usage:

```bash
rivet --ignore-beams -a ALICE_2010_I852264:ENERGY=7000 myevents.hepmc
```
