/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.misc.CollectorMemoryTracker;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SimpleCollector;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.FixedBitSet;

public class MemoryAccountingBitsetCollector
extends SimpleCollector {
    final CollectorMemoryTracker tracker;
    FixedBitSet bitSet = new FixedBitSet(0);
    int length = 0;
    int docBase = 0;

    public MemoryAccountingBitsetCollector(CollectorMemoryTracker tracker) {
        this.tracker = tracker;
        tracker.updateBytes(this.bitSet.ramBytesUsed());
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.length += context.reader().maxDoc();
        FixedBitSet newBitSet = FixedBitSet.ensureCapacity(this.bitSet, this.length);
        if (newBitSet != this.bitSet) {
            this.tracker.updateBytes(newBitSet.ramBytesUsed() - this.bitSet.ramBytesUsed());
            this.bitSet = newBitSet;
        }
    }

    @Override
    public void collect(int doc) {
        this.bitSet.set(this.docBase + doc);
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

