/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.bootstrap;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Constants;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.bootstrap.Natives;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.core.internal.io.IOUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.plugins.Platforms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.plugins.PluginInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.plugins.PluginsService;

final class Spawner
implements Closeable {
    private final List<Process> processes = new ArrayList<Process>();
    private AtomicBoolean spawned = new AtomicBoolean();

    Spawner() {
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(() -> this.processes.stream().map(s -> s::destroy).iterator());
    }

    void spawnNativeControllers(Environment environment, boolean inheritIo) throws IOException {
        if (!this.spawned.compareAndSet(false, true)) {
            throw new IllegalStateException("native controllers already spawned");
        }
        if (!Files.exists(environment.modulesFile(), new LinkOption[0])) {
            throw new IllegalStateException("modules directory [" + environment.modulesFile() + "] not found");
        }
        List<Path> paths = PluginsService.findPluginDirs(environment.modulesFile());
        for (Path modules : paths) {
            PluginInfo info = PluginInfo.readFromProperties(modules);
            Path spawnPath = Platforms.nativeControllerPath(modules);
            if (!Files.isRegularFile(spawnPath, new LinkOption[0])) continue;
            if (!info.hasNativeController()) {
                String message = String.format(Locale.ROOT, "module [%s] does not have permission to fork native controller", modules.getFileName());
                throw new IllegalArgumentException(message);
            }
            Process process = this.spawnNativeController(spawnPath, environment.tmpFile(), inheritIo);
            this.processes.add(process);
        }
    }

    private Process spawnNativeController(Path spawnPath, Path tmpPath, boolean inheritIo) throws IOException {
        String command = Constants.WINDOWS ? Natives.getShortPathName(spawnPath.toString()) : spawnPath.toString();
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.environment().clear();
        pb.environment().put("TMPDIR", tmpPath.toString());
        if (inheritIo) {
            pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        return pb.start();
    }

    List<Process> getProcesses() {
        return Collections.unmodifiableList(this.processes);
    }
}

