/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class FlushJobResponse
implements ToXContentObject {
    public static final ParseField FLUSHED = new ParseField("flushed", new String[0]);
    public static final ParseField LAST_FINALIZED_BUCKET_END = new ParseField("last_finalized_bucket_end", new String[0]);
    public static final ConstructingObjectParser<FlushJobResponse, Void> PARSER = new ConstructingObjectParser("flush_job_response", true, a -> {
        boolean flushed = (Boolean)a[0];
        Date date = a[1] == null ? null : new Date((Long)a[1]);
        return new FlushJobResponse(flushed, date);
    });
    private final boolean flushed;
    private final Date lastFinalizedBucketEnd;

    public static FlushJobResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public FlushJobResponse(boolean flushed, @Nullable Date lastFinalizedBucketEnd) {
        this.flushed = flushed;
        this.lastFinalizedBucketEnd = lastFinalizedBucketEnd;
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    @Nullable
    public Date getLastFinalizedBucketEnd() {
        return this.lastFinalizedBucketEnd;
    }

    public int hashCode() {
        return Objects.hash(this.flushed, this.lastFinalizedBucketEnd);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FlushJobResponse that = (FlushJobResponse)other;
        return that.flushed == this.flushed && Objects.equals(this.lastFinalizedBucketEnd, that.lastFinalizedBucketEnd);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FLUSHED.getPreferredName(), this.flushed);
        if (this.lastFinalizedBucketEnd != null) {
            builder.timeField(LAST_FINALIZED_BUCKET_END.getPreferredName(), LAST_FINALIZED_BUCKET_END.getPreferredName() + "_string", this.lastFinalizedBucketEnd.getTime());
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), FLUSHED);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_FINALIZED_BUCKET_END);
    }
}

