/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.Script;

public abstract class SingleGroupSource
implements ToXContentObject {
    protected static final ParseField FIELD = new ParseField("field", new String[0]);
    protected static final ParseField SCRIPT = new ParseField("script", new String[0]);
    protected final String field;
    protected final Script script;

    public SingleGroupSource(String field, Script script) {
        this.field = field;
        this.script = script;
    }

    public abstract Type getType();

    public String getField() {
        return this.field;
    }

    public Script getScript() {
        return this.script;
    }

    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        if (this.script != null) {
            builder.field(SCRIPT.getPreferredName(), this.script);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleGroupSource)) {
            return false;
        }
        SingleGroupSource that = (SingleGroupSource)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.script, that.script);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.script);
    }

    public static enum Type {
        TERMS,
        HISTOGRAM,
        DATE_HISTOGRAM,
        GEOTILE_GRID;


        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

