/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.Locale;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.ShapeField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;

public enum ShapeRelation implements Writeable
{
    INTERSECTS("intersects"),
    DISJOINT("disjoint"),
    WITHIN("within"),
    CONTAINS("contains");

    private final String relationName;

    private ShapeRelation(String relationName) {
        this.relationName = relationName;
    }

    public static ShapeRelation readFromStream(StreamInput in) throws IOException {
        return in.readEnum(ShapeRelation.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static ShapeRelation getRelationByName(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        for (ShapeRelation relation : ShapeRelation.values()) {
            if (!relation.relationName.equals(name)) continue;
            return relation;
        }
        return null;
    }

    public ShapeField.QueryRelation getLuceneRelation() {
        switch (this) {
            case INTERSECTS: {
                return ShapeField.QueryRelation.INTERSECTS;
            }
            case DISJOINT: {
                return ShapeField.QueryRelation.DISJOINT;
            }
            case WITHIN: {
                return ShapeField.QueryRelation.WITHIN;
            }
            case CONTAINS: {
                return ShapeField.QueryRelation.CONTAINS;
            }
        }
        throw new IllegalArgumentException("ShapeRelation [" + this + "] not supported");
    }

    public String getRelationName() {
        return this.relationName;
    }
}

