/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;

public enum ByteSizeUnit implements Writeable
{
    BYTES{

        @Override
        public long toBytes(long size) {
            return size;
        }

        @Override
        public long toKB(long size) {
            return size / 1024L;
        }

        @Override
        public long toMB(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toGB(long size) {
            return size / 0x40000000L;
        }

        @Override
        public long toTB(long size) {
            return size / 0x10000000000L;
        }

        @Override
        public long toPB(long size) {
            return size / 0x4000000000000L;
        }

        @Override
        public String getSuffix() {
            return "b";
        }
    }
    ,
    KB{

        @Override
        public long toBytes(long size) {
            return 2.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKB(long size) {
            return size;
        }

        @Override
        public long toMB(long size) {
            return size / 1024L;
        }

        @Override
        public long toGB(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toTB(long size) {
            return size / 0x40000000L;
        }

        @Override
        public long toPB(long size) {
            return size / 0x10000000000L;
        }

        @Override
        public String getSuffix() {
            return "kb";
        }
    }
    ,
    MB{

        @Override
        public long toBytes(long size) {
            return 3.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKB(long size) {
            return 3.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMB(long size) {
            return size;
        }

        @Override
        public long toGB(long size) {
            return size / 1024L;
        }

        @Override
        public long toTB(long size) {
            return size / 0x100000L;
        }

        @Override
        public long toPB(long size) {
            return size / 0x40000000L;
        }

        @Override
        public String getSuffix() {
            return "mb";
        }
    }
    ,
    GB{

        @Override
        public long toBytes(long size) {
            return 4.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKB(long size) {
            return 4.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMB(long size) {
            return 4.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGB(long size) {
            return size;
        }

        @Override
        public long toTB(long size) {
            return size / 1024L;
        }

        @Override
        public long toPB(long size) {
            return size / 0x100000L;
        }

        @Override
        public String getSuffix() {
            return "gb";
        }
    }
    ,
    TB{

        @Override
        public long toBytes(long size) {
            return 5.x(size, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toKB(long size) {
            return 5.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMB(long size) {
            return 5.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGB(long size) {
            return 5.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTB(long size) {
            return size;
        }

        @Override
        public long toPB(long size) {
            return size / 1024L;
        }

        @Override
        public String getSuffix() {
            return "tb";
        }
    }
    ,
    PB{

        @Override
        public long toBytes(long size) {
            return 6.x(size, 0x4000000000000L, 8191L);
        }

        @Override
        public long toKB(long size) {
            return 6.x(size, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toMB(long size) {
            return 6.x(size, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toGB(long size) {
            return 6.x(size, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toTB(long size) {
            return 6.x(size, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toPB(long size) {
            return size;
        }

        @Override
        public String getSuffix() {
            return "pb";
        }
    };

    static final long C0 = 1L;
    static final long C1 = 1024L;
    static final long C2 = 0x100000L;
    static final long C3 = 0x40000000L;
    static final long C4 = 0x10000000000L;
    static final long C5 = 0x4000000000000L;
    static final long MAX = Long.MAX_VALUE;

    public static ByteSizeUnit fromId(int id) {
        if (id < 0 || id >= ByteSizeUnit.values().length) {
            throw new IllegalArgumentException("No byte size unit found for id [" + id + "]");
        }
        return ByteSizeUnit.values()[id];
    }

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public abstract long toBytes(long var1);

    public abstract long toKB(long var1);

    public abstract long toMB(long var1);

    public abstract long toGB(long var1);

    public abstract long toTB(long var1);

    public abstract long toPB(long var1);

    public abstract String getSuffix();

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static ByteSizeUnit readFrom(StreamInput in) throws IOException {
        return ByteSizeUnit.fromId(in.readVInt());
    }
}

