/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MatchAllDocsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ConstantFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.BaseTermQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryRewriteContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;

public class TermQueryBuilder
extends BaseTermQueryBuilder<TermQueryBuilder> {
    public static final String NAME = "term";
    private static final ParseField TERM_FIELD = new ParseField("term", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);

    public TermQueryBuilder(String fieldName, String value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, int value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, long value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, float value) {
        super(fieldName, Float.valueOf(value));
    }

    public TermQueryBuilder(String fieldName, double value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, boolean value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, Object value) {
        super(fieldName, value);
    }

    public TermQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public static TermQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String queryName = null;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                TermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (TERM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = TermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = TermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[term] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (token.isValue()) {
                TermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
                fieldName = currentFieldName;
                value = TermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            throw new ParsingException(parser.getTokenLocation(), "[term] query does not support array of values", new Object[0]);
        }
        TermQueryBuilder termQuery = new TermQueryBuilder(fieldName, value);
        termQuery.boost(boost);
        if (queryName != null) {
            termQuery.queryName(queryName);
        }
        return termQuery;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryShardContext context = queryRewriteContext.convertToShardContext();
        if (context != null) {
            MappedFieldType fieldType = context.fieldMapper(this.fieldName);
            if (fieldType == null) {
                return new MatchNoneQueryBuilder();
            }
            if (fieldType instanceof ConstantFieldType) {
                Query query = fieldType.termQuery(this.value, context);
                if (query instanceof MatchAllDocsQuery) {
                    return new MatchAllQueryBuilder();
                }
                if (query instanceof MatchNoDocsQuery) {
                    return new MatchNoneQueryBuilder();
                }
                assert (false) : "Constant fields must produce match-all or match-none queries, got " + query;
            }
        }
        return super.doRewrite(queryRewriteContext);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType mapper = context.fieldMapper(this.fieldName);
        if (mapper == null) {
            throw new IllegalStateException("Rewrite first");
        }
        return mapper.termQuery(this.value, context);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

