/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ElasticsearchParseException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.CompoundProcessor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.ConfigurationUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.IngestDocument;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.IngestMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.Processor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptService;

public final class Pipeline {
    public static final String DESCRIPTION_KEY = "description";
    public static final String PROCESSORS_KEY = "processors";
    public static final String VERSION_KEY = "version";
    public static final String ON_FAILURE_KEY = "on_failure";
    private final String id;
    @Nullable
    private final String description;
    @Nullable
    private final Integer version;
    private final CompoundProcessor compoundProcessor;
    private final IngestMetric metrics;
    private final LongSupplier relativeTimeProvider;

    public Pipeline(String id, @Nullable String description, @Nullable Integer version, CompoundProcessor compoundProcessor) {
        this(id, description, version, compoundProcessor, System::nanoTime);
    }

    Pipeline(String id, @Nullable String description, @Nullable Integer version, CompoundProcessor compoundProcessor, LongSupplier relativeTimeProvider) {
        this.id = id;
        this.description = description;
        this.compoundProcessor = compoundProcessor;
        this.version = version;
        this.metrics = new IngestMetric();
        this.relativeTimeProvider = relativeTimeProvider;
    }

    public static Pipeline create(String id, Map<String, Object> config, Map<String, Processor.Factory> processorFactories, ScriptService scriptService) throws Exception {
        String description = ConfigurationUtils.readOptionalStringProperty(null, null, config, DESCRIPTION_KEY);
        Integer version = ConfigurationUtils.readIntProperty(null, null, config, VERSION_KEY, null);
        List<Map<String, Object>> processorConfigs = ConfigurationUtils.readList(null, null, config, PROCESSORS_KEY);
        List<Processor> processors = ConfigurationUtils.readProcessorConfigs(processorConfigs, scriptService, processorFactories);
        List<Map<String, Object>> onFailureProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, ON_FAILURE_KEY);
        List<Processor> onFailureProcessors = ConfigurationUtils.readProcessorConfigs(onFailureProcessorConfigs, scriptService, processorFactories);
        if (!config.isEmpty()) {
            throw new ElasticsearchParseException("pipeline [" + id + "] doesn't support one or more provided configuration parameters " + Arrays.toString(config.keySet().toArray()), new Object[0]);
        }
        if (onFailureProcessorConfigs != null && onFailureProcessors.isEmpty()) {
            throw new ElasticsearchParseException("pipeline [" + id + "] cannot have an empty on_failure option defined", new Object[0]);
        }
        CompoundProcessor compoundProcessor = new CompoundProcessor(false, Collections.unmodifiableList(processors), Collections.unmodifiableList(onFailureProcessors));
        return new Pipeline(id, description, version, compoundProcessor);
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        long startTimeInNanos = this.relativeTimeProvider.getAsLong();
        this.metrics.preIngest();
        this.compoundProcessor.execute(ingestDocument, (result, e) -> {
            long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTimeInNanos);
            this.metrics.postIngest(ingestTimeInMillis);
            if (e != null) {
                this.metrics.ingestFailed();
            }
            handler.accept((IngestDocument)result, (Exception)e);
        });
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public CompoundProcessor getCompoundProcessor() {
        return this.compoundProcessor;
    }

    public List<Processor> getProcessors() {
        return this.compoundProcessor.getProcessors();
    }

    public List<Processor> getOnFailureProcessors() {
        return this.compoundProcessor.getOnFailureProcessors();
    }

    public List<Processor> flattenAllProcessors() {
        return this.compoundProcessor.flattenProcessors();
    }

    public IngestMetric getMetrics() {
        return this.metrics;
    }
}

