/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.monitor.fs;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.UUIDs;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.ClusterSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.core.internal.io.IOUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.env.NodeEnvironment;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.monitor.NodeHealthService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.monitor.StatusInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.Scheduler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;

public class FsHealthService
extends AbstractLifecycleComponent
implements NodeHealthService {
    private static final Logger logger = LogManager.getLogger(FsHealthService.class);
    private final ThreadPool threadPool;
    private volatile boolean enabled;
    private final TimeValue refreshInterval;
    private volatile TimeValue slowPathLoggingThreshold;
    private final NodeEnvironment nodeEnv;
    private final LongSupplier currentTimeMillisSupplier;
    private volatile Scheduler.Cancellable scheduledFuture;
    @Nullable
    private volatile Set<Path> unhealthyPaths;
    public static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting("monitor.fs.health.enabled", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.fs.health.refresh_interval", TimeValue.timeValueSeconds(120L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> SLOW_PATH_LOGGING_THRESHOLD_SETTING = Setting.timeSetting("monitor.fs.health.slow_path_logging_threshold", TimeValue.timeValueSeconds(5L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope, Setting.Property.Dynamic);

    public FsHealthService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool, NodeEnvironment nodeEnv) {
        this.threadPool = threadPool;
        this.enabled = ENABLED_SETTING.get(settings);
        this.refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.slowPathLoggingThreshold = SLOW_PATH_LOGGING_THRESHOLD_SETTING.get(settings);
        this.currentTimeMillisSupplier = threadPool::relativeTimeInMillis;
        this.nodeEnv = nodeEnv;
        clusterSettings.addSettingsUpdateConsumer(SLOW_PATH_LOGGING_THRESHOLD_SETTING, this::setSlowPathLoggingThreshold);
        clusterSettings.addSettingsUpdateConsumer(ENABLED_SETTING, this::setEnabled);
    }

    @Override
    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(new FsHealthMonitor(), this.refreshInterval, "generic");
    }

    @Override
    protected void doStop() {
        this.scheduledFuture.cancel();
    }

    @Override
    protected void doClose() {
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSlowPathLoggingThreshold(TimeValue slowPathLoggingThreshold) {
        this.slowPathLoggingThreshold = slowPathLoggingThreshold;
    }

    @Override
    public StatusInfo getHealth() {
        StatusInfo statusInfo;
        Set<Path> unhealthyPaths = this.unhealthyPaths;
        if (!this.enabled) {
            statusInfo = new StatusInfo(StatusInfo.Status.HEALTHY, "health check disabled");
        } else if (unhealthyPaths == null) {
            statusInfo = new StatusInfo(StatusInfo.Status.HEALTHY, "health check passed");
        } else {
            String info = "health check failed on [" + unhealthyPaths.stream().map(k -> k.toString()).collect(Collectors.joining(",")) + "]";
            statusInfo = new StatusInfo(StatusInfo.Status.UNHEALTHY, info);
        }
        return statusInfo;
    }

    class FsHealthMonitor
    implements Runnable {
        static final String TEMP_FILE_NAME = ".es_temp_file";
        private byte[] byteToWrite = UUIDs.randomBase64UUID().getBytes(StandardCharsets.UTF_8);

        FsHealthMonitor() {
        }

        @Override
        public void run() {
            try {
                if (FsHealthService.this.enabled) {
                    this.monitorFSHealth();
                    logger.debug("health check succeeded");
                }
            }
            catch (Exception e) {
                logger.error("health check failed", (Throwable)e);
            }
        }

        private void monitorFSHealth() {
            HashSet<Path> currentUnhealthyPaths = null;
            for (Path path : FsHealthService.this.nodeEnv.nodeDataPaths()) {
                long executionStartTime = FsHealthService.this.currentTimeMillisSupplier.getAsLong();
                try {
                    if (!Files.exists(path, new LinkOption[0])) continue;
                    Path tempDataPath = path.resolve(TEMP_FILE_NAME);
                    Files.deleteIfExists(tempDataPath);
                    try (OutputStream os = Files.newOutputStream(tempDataPath, StandardOpenOption.CREATE_NEW);){
                        os.write(this.byteToWrite);
                        IOUtils.fsync(tempDataPath, false);
                    }
                    Files.delete(tempDataPath);
                    long elapsedTime = FsHealthService.this.currentTimeMillisSupplier.getAsLong() - executionStartTime;
                    if (elapsedTime <= FsHealthService.this.slowPathLoggingThreshold.millis()) continue;
                    logger.warn("health check of [{}] took [{}ms] which is above the warn threshold of [{}]", (Object)path, (Object)elapsedTime, (Object)FsHealthService.this.slowPathLoggingThreshold);
                }
                catch (Exception ex) {
                    logger.error((Message)new ParameterizedMessage("health check of [{}] failed", (Object)path), (Throwable)ex);
                    if (currentUnhealthyPaths == null) {
                        currentUnhealthyPaths = new HashSet<Path>(1);
                    }
                    currentUnhealthyPaths.add(path);
                }
            }
            FsHealthService.this.unhealthyPaths = currentUnhealthyPaths;
        }
    }
}

