/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.transport;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportResponse;

public class TaskTransportChannel
implements TransportChannel {
    private final TransportChannel channel;
    private final Releasable onTaskFinished;

    TaskTransportChannel(TransportChannel channel, Releasable onTaskFinished) {
        this.channel = channel;
        this.onTaskFinished = onTaskFinished;
    }

    @Override
    public String getProfileName() {
        return this.channel.getProfileName();
    }

    @Override
    public String getChannelType() {
        return this.channel.getChannelType();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        try {
            this.onTaskFinished.close();
        }
        finally {
            this.channel.sendResponse(response);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        try {
            this.onTaskFinished.close();
        }
        finally {
            this.channel.sendResponse(exception);
        }
    }

    @Override
    public Version getVersion() {
        return this.channel.getVersion();
    }

    public TransportChannel getChannel() {
        return this.channel;
    }
}

