/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.TransitGatewayRoute;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SearchTransitGatewayRoutesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<TransitGatewayRoute> routes;
    private Boolean additionalRoutesAvailable;

    public List<TransitGatewayRoute> getRoutes() {
        if (this.routes == null) {
            this.routes = new SdkInternalList();
        }
        return this.routes;
    }

    public void setRoutes(Collection<TransitGatewayRoute> routes) {
        if (routes == null) {
            this.routes = null;
            return;
        }
        this.routes = new SdkInternalList<TransitGatewayRoute>(routes);
    }

    public SearchTransitGatewayRoutesResult withRoutes(TransitGatewayRoute ... routes) {
        if (this.routes == null) {
            this.setRoutes(new SdkInternalList<TransitGatewayRoute>(routes.length));
        }
        for (TransitGatewayRoute ele : routes) {
            this.routes.add(ele);
        }
        return this;
    }

    public SearchTransitGatewayRoutesResult withRoutes(Collection<TransitGatewayRoute> routes) {
        this.setRoutes(routes);
        return this;
    }

    public void setAdditionalRoutesAvailable(Boolean additionalRoutesAvailable) {
        this.additionalRoutesAvailable = additionalRoutesAvailable;
    }

    public Boolean getAdditionalRoutesAvailable() {
        return this.additionalRoutesAvailable;
    }

    public SearchTransitGatewayRoutesResult withAdditionalRoutesAvailable(Boolean additionalRoutesAvailable) {
        this.setAdditionalRoutesAvailable(additionalRoutesAvailable);
        return this;
    }

    public Boolean isAdditionalRoutesAvailable() {
        return this.additionalRoutesAvailable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoutes() != null) {
            sb.append("Routes: ").append(this.getRoutes()).append(",");
        }
        if (this.getAdditionalRoutesAvailable() != null) {
            sb.append("AdditionalRoutesAvailable: ").append(this.getAdditionalRoutesAvailable());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTransitGatewayRoutesResult)) {
            return false;
        }
        SearchTransitGatewayRoutesResult other = (SearchTransitGatewayRoutesResult)obj;
        if (other.getRoutes() == null ^ this.getRoutes() == null) {
            return false;
        }
        if (other.getRoutes() != null && !other.getRoutes().equals(this.getRoutes())) {
            return false;
        }
        if (other.getAdditionalRoutesAvailable() == null ^ this.getAdditionalRoutesAvailable() == null) {
            return false;
        }
        return other.getAdditionalRoutesAvailable() == null || other.getAdditionalRoutesAvailable().equals(this.getAdditionalRoutesAvailable());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoutes() == null ? 0 : this.getRoutes().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalRoutesAvailable() == null ? 0 : this.getAdditionalRoutesAvailable().hashCode());
        return hashCode;
    }

    public SearchTransitGatewayRoutesResult clone() {
        try {
            return (SearchTransitGatewayRoutesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

