/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DnsNameState;
import com.amazonaws.services.ec2.model.PrivateDnsDetails;
import com.amazonaws.services.ec2.model.ServiceTypeDetail;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ServiceDetail
implements Serializable,
Cloneable {
    private String serviceName;
    private String serviceId;
    private SdkInternalList<ServiceTypeDetail> serviceType;
    private SdkInternalList<String> availabilityZones;
    private String owner;
    private SdkInternalList<String> baseEndpointDnsNames;
    private String privateDnsName;
    private SdkInternalList<PrivateDnsDetails> privateDnsNames;
    private Boolean vpcEndpointPolicySupported;
    private Boolean acceptanceRequired;
    private Boolean managesVpcEndpoints;
    private SdkInternalList<Tag> tags;
    private String privateDnsNameVerificationState;

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceDetail withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public ServiceDetail withServiceId(String serviceId) {
        this.setServiceId(serviceId);
        return this;
    }

    public List<ServiceTypeDetail> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new SdkInternalList();
        }
        return this.serviceType;
    }

    public void setServiceType(Collection<ServiceTypeDetail> serviceType) {
        if (serviceType == null) {
            this.serviceType = null;
            return;
        }
        this.serviceType = new SdkInternalList<ServiceTypeDetail>(serviceType);
    }

    public ServiceDetail withServiceType(ServiceTypeDetail ... serviceType) {
        if (this.serviceType == null) {
            this.setServiceType(new SdkInternalList<ServiceTypeDetail>(serviceType.length));
        }
        for (ServiceTypeDetail ele : serviceType) {
            this.serviceType.add(ele);
        }
        return this;
    }

    public ServiceDetail withServiceType(Collection<ServiceTypeDetail> serviceType) {
        this.setServiceType(serviceType);
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList<String>(availabilityZones);
    }

    public ServiceDetail withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones(new SdkInternalList<String>(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add(ele);
        }
        return this;
    }

    public ServiceDetail withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public ServiceDetail withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public List<String> getBaseEndpointDnsNames() {
        if (this.baseEndpointDnsNames == null) {
            this.baseEndpointDnsNames = new SdkInternalList();
        }
        return this.baseEndpointDnsNames;
    }

    public void setBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
        if (baseEndpointDnsNames == null) {
            this.baseEndpointDnsNames = null;
            return;
        }
        this.baseEndpointDnsNames = new SdkInternalList<String>(baseEndpointDnsNames);
    }

    public ServiceDetail withBaseEndpointDnsNames(String ... baseEndpointDnsNames) {
        if (this.baseEndpointDnsNames == null) {
            this.setBaseEndpointDnsNames(new SdkInternalList<String>(baseEndpointDnsNames.length));
        }
        for (String ele : baseEndpointDnsNames) {
            this.baseEndpointDnsNames.add(ele);
        }
        return this;
    }

    public ServiceDetail withBaseEndpointDnsNames(Collection<String> baseEndpointDnsNames) {
        this.setBaseEndpointDnsNames(baseEndpointDnsNames);
        return this;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public ServiceDetail withPrivateDnsName(String privateDnsName) {
        this.setPrivateDnsName(privateDnsName);
        return this;
    }

    public List<PrivateDnsDetails> getPrivateDnsNames() {
        if (this.privateDnsNames == null) {
            this.privateDnsNames = new SdkInternalList();
        }
        return this.privateDnsNames;
    }

    public void setPrivateDnsNames(Collection<PrivateDnsDetails> privateDnsNames) {
        if (privateDnsNames == null) {
            this.privateDnsNames = null;
            return;
        }
        this.privateDnsNames = new SdkInternalList<PrivateDnsDetails>(privateDnsNames);
    }

    public ServiceDetail withPrivateDnsNames(PrivateDnsDetails ... privateDnsNames) {
        if (this.privateDnsNames == null) {
            this.setPrivateDnsNames(new SdkInternalList<PrivateDnsDetails>(privateDnsNames.length));
        }
        for (PrivateDnsDetails ele : privateDnsNames) {
            this.privateDnsNames.add(ele);
        }
        return this;
    }

    public ServiceDetail withPrivateDnsNames(Collection<PrivateDnsDetails> privateDnsNames) {
        this.setPrivateDnsNames(privateDnsNames);
        return this;
    }

    public void setVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
        this.vpcEndpointPolicySupported = vpcEndpointPolicySupported;
    }

    public Boolean getVpcEndpointPolicySupported() {
        return this.vpcEndpointPolicySupported;
    }

    public ServiceDetail withVpcEndpointPolicySupported(Boolean vpcEndpointPolicySupported) {
        this.setVpcEndpointPolicySupported(vpcEndpointPolicySupported);
        return this;
    }

    public Boolean isVpcEndpointPolicySupported() {
        return this.vpcEndpointPolicySupported;
    }

    public void setAcceptanceRequired(Boolean acceptanceRequired) {
        this.acceptanceRequired = acceptanceRequired;
    }

    public Boolean getAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public ServiceDetail withAcceptanceRequired(Boolean acceptanceRequired) {
        this.setAcceptanceRequired(acceptanceRequired);
        return this;
    }

    public Boolean isAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public void setManagesVpcEndpoints(Boolean managesVpcEndpoints) {
        this.managesVpcEndpoints = managesVpcEndpoints;
    }

    public Boolean getManagesVpcEndpoints() {
        return this.managesVpcEndpoints;
    }

    public ServiceDetail withManagesVpcEndpoints(Boolean managesVpcEndpoints) {
        this.setManagesVpcEndpoints(managesVpcEndpoints);
        return this;
    }

    public Boolean isManagesVpcEndpoints() {
        return this.managesVpcEndpoints;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public ServiceDetail withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ServiceDetail withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setPrivateDnsNameVerificationState(String privateDnsNameVerificationState) {
        this.privateDnsNameVerificationState = privateDnsNameVerificationState;
    }

    public String getPrivateDnsNameVerificationState() {
        return this.privateDnsNameVerificationState;
    }

    public ServiceDetail withPrivateDnsNameVerificationState(String privateDnsNameVerificationState) {
        this.setPrivateDnsNameVerificationState(privateDnsNameVerificationState);
        return this;
    }

    public ServiceDetail withPrivateDnsNameVerificationState(DnsNameState privateDnsNameVerificationState) {
        this.privateDnsNameVerificationState = privateDnsNameVerificationState.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceName() != null) {
            sb.append("ServiceName: ").append(this.getServiceName()).append(",");
        }
        if (this.getServiceId() != null) {
            sb.append("ServiceId: ").append(this.getServiceId()).append(",");
        }
        if (this.getServiceType() != null) {
            sb.append("ServiceType: ").append(this.getServiceType()).append(",");
        }
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getBaseEndpointDnsNames() != null) {
            sb.append("BaseEndpointDnsNames: ").append(this.getBaseEndpointDnsNames()).append(",");
        }
        if (this.getPrivateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.getPrivateDnsName()).append(",");
        }
        if (this.getPrivateDnsNames() != null) {
            sb.append("PrivateDnsNames: ").append(this.getPrivateDnsNames()).append(",");
        }
        if (this.getVpcEndpointPolicySupported() != null) {
            sb.append("VpcEndpointPolicySupported: ").append(this.getVpcEndpointPolicySupported()).append(",");
        }
        if (this.getAcceptanceRequired() != null) {
            sb.append("AcceptanceRequired: ").append(this.getAcceptanceRequired()).append(",");
        }
        if (this.getManagesVpcEndpoints() != null) {
            sb.append("ManagesVpcEndpoints: ").append(this.getManagesVpcEndpoints()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPrivateDnsNameVerificationState() != null) {
            sb.append("PrivateDnsNameVerificationState: ").append(this.getPrivateDnsNameVerificationState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDetail)) {
            return false;
        }
        ServiceDetail other = (ServiceDetail)obj;
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getServiceId() == null ^ this.getServiceId() == null) {
            return false;
        }
        if (other.getServiceId() != null && !other.getServiceId().equals(this.getServiceId())) {
            return false;
        }
        if (other.getServiceType() == null ^ this.getServiceType() == null) {
            return false;
        }
        if (other.getServiceType() != null && !other.getServiceType().equals(this.getServiceType())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getBaseEndpointDnsNames() == null ^ this.getBaseEndpointDnsNames() == null) {
            return false;
        }
        if (other.getBaseEndpointDnsNames() != null && !other.getBaseEndpointDnsNames().equals(this.getBaseEndpointDnsNames())) {
            return false;
        }
        if (other.getPrivateDnsName() == null ^ this.getPrivateDnsName() == null) {
            return false;
        }
        if (other.getPrivateDnsName() != null && !other.getPrivateDnsName().equals(this.getPrivateDnsName())) {
            return false;
        }
        if (other.getPrivateDnsNames() == null ^ this.getPrivateDnsNames() == null) {
            return false;
        }
        if (other.getPrivateDnsNames() != null && !other.getPrivateDnsNames().equals(this.getPrivateDnsNames())) {
            return false;
        }
        if (other.getVpcEndpointPolicySupported() == null ^ this.getVpcEndpointPolicySupported() == null) {
            return false;
        }
        if (other.getVpcEndpointPolicySupported() != null && !other.getVpcEndpointPolicySupported().equals(this.getVpcEndpointPolicySupported())) {
            return false;
        }
        if (other.getAcceptanceRequired() == null ^ this.getAcceptanceRequired() == null) {
            return false;
        }
        if (other.getAcceptanceRequired() != null && !other.getAcceptanceRequired().equals(this.getAcceptanceRequired())) {
            return false;
        }
        if (other.getManagesVpcEndpoints() == null ^ this.getManagesVpcEndpoints() == null) {
            return false;
        }
        if (other.getManagesVpcEndpoints() != null && !other.getManagesVpcEndpoints().equals(this.getManagesVpcEndpoints())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPrivateDnsNameVerificationState() == null ^ this.getPrivateDnsNameVerificationState() == null) {
            return false;
        }
        return other.getPrivateDnsNameVerificationState() == null || other.getPrivateDnsNameVerificationState().equals(this.getPrivateDnsNameVerificationState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getServiceId() == null ? 0 : this.getServiceId().hashCode());
        hashCode = 31 * hashCode + (this.getServiceType() == null ? 0 : this.getServiceType().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getBaseEndpointDnsNames() == null ? 0 : this.getBaseEndpointDnsNames().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsName() == null ? 0 : this.getPrivateDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsNames() == null ? 0 : this.getPrivateDnsNames().hashCode());
        hashCode = 31 * hashCode + (this.getVpcEndpointPolicySupported() == null ? 0 : this.getVpcEndpointPolicySupported().hashCode());
        hashCode = 31 * hashCode + (this.getAcceptanceRequired() == null ? 0 : this.getAcceptanceRequired().hashCode());
        hashCode = 31 * hashCode + (this.getManagesVpcEndpoints() == null ? 0 : this.getManagesVpcEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateDnsNameVerificationState() == null ? 0 : this.getPrivateDnsNameVerificationState().hashCode());
        return hashCode;
    }

    public ServiceDetail clone() {
        try {
            return (ServiceDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

