/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeNetworkInsightsPathsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeNetworkInsightsPathsRequestMarshaller
implements Marshaller<Request<DescribeNetworkInsightsPathsRequest>, DescribeNetworkInsightsPathsRequest> {
    @Override
    public Request<DescribeNetworkInsightsPathsRequest> marshall(DescribeNetworkInsightsPathsRequest describeNetworkInsightsPathsRequest) {
        SdkInternalList describeNetworkInsightsPathsRequestFiltersList;
        if (describeNetworkInsightsPathsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeNetworkInsightsPathsRequest> request = new DefaultRequest<DescribeNetworkInsightsPathsRequest>(describeNetworkInsightsPathsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeNetworkInsightsPaths");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeNetworkInsightsPathsRequestNetworkInsightsPathIdsList = (SdkInternalList)describeNetworkInsightsPathsRequest.getNetworkInsightsPathIds();
        if (!describeNetworkInsightsPathsRequestNetworkInsightsPathIdsList.isEmpty() || !describeNetworkInsightsPathsRequestNetworkInsightsPathIdsList.isAutoConstruct()) {
            int networkInsightsPathIdsListIndex = 1;
            for (String describeNetworkInsightsPathsRequestNetworkInsightsPathIdsListValue : describeNetworkInsightsPathsRequestNetworkInsightsPathIdsList) {
                if (describeNetworkInsightsPathsRequestNetworkInsightsPathIdsListValue != null) {
                    request.addParameter("NetworkInsightsPathId." + networkInsightsPathIdsListIndex, StringUtils.fromString(describeNetworkInsightsPathsRequestNetworkInsightsPathIdsListValue));
                }
                ++networkInsightsPathIdsListIndex;
            }
        }
        if (!(describeNetworkInsightsPathsRequestFiltersList = (SdkInternalList)describeNetworkInsightsPathsRequest.getFilters()).isEmpty() || !describeNetworkInsightsPathsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeNetworkInsightsPathsRequestFiltersListValue : describeNetworkInsightsPathsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeNetworkInsightsPathsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeNetworkInsightsPathsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeNetworkInsightsPathsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeNetworkInsightsPathsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeNetworkInsightsPathsRequest.getMaxResults()));
        }
        if (describeNetworkInsightsPathsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeNetworkInsightsPathsRequest.getNextToken()));
        }
        return request;
    }
}

