/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.EbsInfo;
import com.amazonaws.services.ec2.model.transform.EbsOptimizedInfoStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class EbsInfoStaxUnmarshaller
implements Unmarshaller<EbsInfo, StaxUnmarshallerContext> {
    private static EbsInfoStaxUnmarshaller instance;

    @Override
    public EbsInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        EbsInfo ebsInfo = new EbsInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return ebsInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ebsOptimizedSupport", targetDepth)) {
                    ebsInfo.setEbsOptimizedSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("encryptionSupport", targetDepth)) {
                    ebsInfo.setEncryptionSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ebsOptimizedInfo", targetDepth)) {
                    ebsInfo.setEbsOptimizedInfo(EbsOptimizedInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("nvmeSupport", targetDepth)) continue;
                ebsInfo.setNvmeSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return ebsInfo;
    }

    public static EbsInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EbsInfoStaxUnmarshaller();
        }
        return instance;
    }
}

