/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.EnclaveOptions;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class EnclaveOptionsStaxUnmarshaller
implements Unmarshaller<EnclaveOptions, StaxUnmarshallerContext> {
    private static EnclaveOptionsStaxUnmarshaller instance;

    @Override
    public EnclaveOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        EnclaveOptions enclaveOptions = new EnclaveOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return enclaveOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("enabled", targetDepth)) continue;
                enclaveOptions.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return enclaveOptions;
    }

    public static EnclaveOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EnclaveOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

