/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.ExportImageResult;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.ExportTaskS3LocationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ExportImageResultStaxUnmarshaller
implements Unmarshaller<ExportImageResult, StaxUnmarshallerContext> {
    private static ExportImageResultStaxUnmarshaller instance;

    @Override
    public ExportImageResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        ExportImageResult exportImageResult = new ExportImageResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return exportImageResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("description", targetDepth)) {
                    exportImageResult.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("diskImageFormat", targetDepth)) {
                    exportImageResult.setDiskImageFormat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("exportImageTaskId", targetDepth)) {
                    exportImageResult.setExportImageTaskId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageId", targetDepth)) {
                    exportImageResult.setImageId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("roleName", targetDepth)) {
                    exportImageResult.setRoleName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("progress", targetDepth)) {
                    exportImageResult.setProgress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("s3ExportLocation", targetDepth)) {
                    exportImageResult.setS3ExportLocation(ExportTaskS3LocationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("status", targetDepth)) {
                    exportImageResult.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("statusMessage", targetDepth)) {
                    exportImageResult.setStatusMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    exportImageResult.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                exportImageResult.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return exportImageResult;
    }

    public static ExportImageResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ExportImageResultStaxUnmarshaller();
        }
        return instance;
    }
}

