/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.PathComponent;
import com.amazonaws.services.ec2.model.transform.AnalysisAclRuleStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.AnalysisComponentStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.AnalysisPacketHeaderStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.AnalysisRouteTableRouteStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.AnalysisSecurityGroupRuleStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PathComponentStaxUnmarshaller
implements Unmarshaller<PathComponent, StaxUnmarshallerContext> {
    private static PathComponentStaxUnmarshaller instance;

    @Override
    public PathComponent unmarshall(StaxUnmarshallerContext context) throws Exception {
        PathComponent pathComponent = new PathComponent();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return pathComponent;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("sequenceNumber", targetDepth)) {
                    pathComponent.setSequenceNumber(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("aclRule", targetDepth)) {
                    pathComponent.setAclRule(AnalysisAclRuleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("component", targetDepth)) {
                    pathComponent.setComponent(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("destinationVpc", targetDepth)) {
                    pathComponent.setDestinationVpc(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("outboundHeader", targetDepth)) {
                    pathComponent.setOutboundHeader(AnalysisPacketHeaderStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("inboundHeader", targetDepth)) {
                    pathComponent.setInboundHeader(AnalysisPacketHeaderStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("routeTableRoute", targetDepth)) {
                    pathComponent.setRouteTableRoute(AnalysisRouteTableRouteStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("securityGroupRule", targetDepth)) {
                    pathComponent.setSecurityGroupRule(AnalysisSecurityGroupRuleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sourceVpc", targetDepth)) {
                    pathComponent.setSourceVpc(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("subnet", targetDepth)) {
                    pathComponent.setSubnet(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpc", targetDepth)) continue;
                pathComponent.setVpc(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return pathComponent;
    }

    public static PathComponentStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PathComponentStaxUnmarshaller();
        }
        return instance;
    }
}

